/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import mill.api.SystemStreams;
import mill.api.SystemStreams$;
import mill.main.client.InputPumper;
import mill.moduledefs.Scaladoc;
import os.ProcessInput;
import os.ProcessOutput;
import os.SubProcess;
import scala.Function0;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n * Represents a set of streams that look similar to those provided by the\n * operating system. These may internally be proxied/redirected/processed, but\n * from the consumer's perspective they look just like the stdout/stderr/stdin\n * that any Unix process receives from the OS.\n */")
@ScalaSignature(bytes="\u0006\u0005\teg\u0001\u0002$H\u00011C\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001\u0016\u0005\t;\u0002\u0011\t\u0011)A\u0005+\"Aa\f\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005`\u0001\t\u0005\t\u0015!\u0003V\u0011!\u0001\u0007A!b\u0001\n\u0003\t\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u000b\u0019\u0004A\u0011A4\b\u000b]<\u0005\u0012\u0001=\u0007\u000b\u0019;\u0005\u0012A=\t\u000b\u0019LA\u0011\u0001>\t\u000fmL!\u0019!C\u0001y\"1Q0\u0003Q\u0001\n!Dq!a\u0001\n\t\u0003\t)\u0001\u0003\u0004\u0002\u0014%!\t\u0001\u0016\u0004\u0007\u00037IA!!\b\t\r\u0019|A\u0011AA\u0016\u0011\u001d\t\td\u0004C\u0001\u0003gAq!!\u0013\u0010\t\u0003\tYE\u0002\u0004\u0002\u0004&!\u0011Q\u0011\u0005\u000b\u0003\u001b\u001b\"\u0011!Q\u0001\n\u0005=\u0005B\u00024\u0014\t\u0003\t)\nC\u0004\u0002\u001cN!\t!a\r\t\u000f\u0005u5\u0003\"\u0001\u0002 \"9\u00111V\u0005\u0005\u0002\u00055\u0006bBAj\u0013\u0011\u0005\u0011Q\u001b\u0005\b\u0003OLA\u0011AAu\u000f!\t\t0\u0003E\u0001\u0013\u0006Mh\u0001CA{\u0013!\u0005\u0011*a>\t\r\u0019dB\u0011AA}\u0011%\tY\u0010\bb\u0001\n\u0003\ti\u0010\u0003\u0005\u0003\fq\u0001\u000b\u0011BA\u0000\u000f\u001d\u0011i\u0001\bE\u0001\u0005\u001f1qAa\u0005\u001d\u0011\u0003\u0011)\u0002\u0003\u0004gC\u0011\u0005!qC\u0004\b\u00053a\u0002\u0012\u0001B\u000e\r\u001d\u0011i\u0002\bE\u0001\u0005?AaA\u001a\u0013\u0005\u0002\t\u0005ra\u0002B\u00129!\u0005!Q\u0005\u0004\b\u0005Oa\u0002\u0012\u0001B\u0015\u0011\u00191w\u0005\"\u0001\u0003\u0016\"9!1G\u0014\u0005\u0002\tUba\u0002BL9\u0005\u0005!\u0011\u0014\u0005\u0007M*\"\tAa'\t\u000f\tM\"F\"\u0001\u0003 \"9!\u0011\u0015\u0016\u0005B\t\r\u0006b\u0002BQU\u0011\u0005#1\u0016\u0005\b\u0005CSC\u0011\u0001BX\u0011\u001d\u0011\u0019L\u000bC!\u0003SDqA!$+\t\u0003\nIOB\u0004\u0003.q\t\tAa\f\t\r\u0019\u0014D\u0011\u0001B\u0019\u0011\u001d\u0011\u0019D\rD\u0001\u0005kAqAa\u000e3\t\u0003\u0012I\u0004C\u0004\u00038I\"\tE!\u0011\t\u000f\t]\"\u0007\"\u0011\u0003\\!9!q\f\u001a\u0005B\t\u0005\u0004b\u0002B0e\u0011\u0005#\u0011\u000e\u0005\b\u0005[\u0012D\u0011\tB8\u0011\u001d\u0011\tH\rC!\u0005gBqA!\u001f3\t\u0003\n)\u0001C\u0004\u0003|I\"\tE!\u000f\t\u000f\tu$\u0007\"\u0011\u0002j\"9!q\u0010\u001a\u0005B\t\u0005\u0005b\u0002BGe\u0011\u0005\u0013\u0011\u001e\u0005\b\u0005\u001f\u0013D\u0011\tBI\u0011\u001d\u0011),\u0003C\u0005\u0005o3qA!4\n\u0001%\u0013y\rC\u0005\u0003R\u000e\u0013\t\u0011)A\u0005Q\"1am\u0011C\u0001\u0005'\u0014QbU=ti\u0016l7\u000b\u001e:fC6\u001c(B\u0001%J\u0003\r\t\u0007/\u001b\u0006\u0002\u0015\u0006!Q.\u001b7m\u0007\u0001\u0019\"\u0001A'\u0011\u00059\u000bV\"A(\u000b\u0003A\u000bQa]2bY\u0006L!AU(\u0003\r\u0005s\u0017PU3g\u0003\ryW\u000f^\u000b\u0002+B\u0011akW\u0007\u0002/*\u0011\u0001,W\u0001\u0003S>T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\nY\u0001K]5oiN#(/Z1n\u0003\u0011yW\u000f\u001e\u0011\u0002\u0007\u0015\u0014(/\u0001\u0003feJ\u0004\u0013AA5o+\u0005\u0011\u0007C\u0001,d\u0013\t!wKA\u0006J]B,Ho\u0015;sK\u0006l\u0017aA5oA\u00051A(\u001b8jiz\"B\u0001\u001b6lYB\u0011\u0011\u000eA\u0007\u0002\u000f\")1k\u0002a\u0001+\")al\u0002a\u0001+\")\u0001m\u0002a\u0001E\"\"\u0001A\u001c;v!\ty'/D\u0001q\u0015\t\t\u0018*\u0001\u0006n_\u0012,H.\u001a3fMNL!a\u001d9\u0003\u0011M\u001b\u0017\r\\1e_\u000e\fQA^1mk\u0016\f\u0013A^\u0001\u0003>=R#F\u0003\u0011+AI+\u0007O]3tK:$8\u000fI1!g\u0016$\be\u001c4!gR\u0014X-Y7tAQD\u0017\r\u001e\u0011m_>\\\u0007e]5nS2\f'\u000f\t;pAQDwn]3!aJ|g/\u001b3fI\u0002\u0012\u0017\u0010\t;iK*\u0001#\u0006I8qKJ\fG/\u001b8hAML8\u000f^3n]\u0001\"\u0006.Z:fA5\f\u0017\u0010I5oi\u0016\u0014h.\u00197ms\u0002\u0012W\r\t9s_bLW\rZ\u0018sK\u0012L'/Z2uK\u0012|\u0003O]8dKN\u001cX\r\u001a\u0017!EV$(\u0002\t\u0016!MJ|W\u000e\t;iK\u0002\u001awN\\:v[\u0016\u0014xe\u001d\u0011qKJ\u001c\b/Z2uSZ,\u0007\u0005\u001e5fs\u0002bwn\\6!UV\u001cH\u000f\t7jW\u0016\u0004C\u000f[3!gR$w.\u001e;0gR$WM\u001d:0gR$\u0017N\u001c\u0006!U\u0001\"\b.\u0019;!C:L\b%\u00168jq\u0002\u0002(o\\2fgN\u0004#/Z2fSZ,7\u000f\t4s_6\u0004C\u000f[3!\u001fNs#\u0002\t\u00160\u00035\u0019\u0016p\u001d;f[N#(/Z1ngB\u0011\u0011.C\n\u0003\u00135#\u0012\u0001_\u0001\t_JLw-\u001b8bYV\t\u0001.A\u0005pe&<\u0017N\\1mA!\"AB\u001c;\u0000C\t\t\t!\u0001B~_)R#\u0002\t\u0011!U\u0001\"\u0006.\u001a\u0011pe&<\u0017N\\1mAML8\u000f^3nAM$(/Z1ng\u0002zg\r\t;iSN\u0004\u0003O]8dKN\u001cH\u0006\t2fM>\u0014X\rI1os\u0002\u0012X\rZ5sK\u000e$\u0018n\u001c8/\u0015\u0001\u0002\u0003E\u000b\u0006!A\u0001R\u0003ET(U\u000bj\u0002\u0013p\\;!g\"|W\u000f\u001c3!]>$\b%^:fAQD\u0017n]\u0011!)\",\u0017\u0010\t3pA9|G\u000fI4fi\u0002\u001a\u0017\r\u001d;ve\u0016$\u0007\u0005\u001d:pa\u0016\u0014H.\u001f\u0011cs\u0002j\u0015\u000e\u001c7(g\u0002\u001aH\u000fZ8vi>*'O\u001d\u0006!A\u0001R\u0003E]3eSJ,7\r^5p]2\u0002\u0013M\u001c3!i\",8\u000fI8oYf\u0004s-\u001a;!a&\u001c7.\u001a3!kB\u0004cM]8nAQDW\rI'jY2\u00043/\u001a:wKJ\u0004Cn\\4!M&dWm\u001d\u0011bgft7\r\u001b:p]>,8\u000f\\=/\u0015\u0001\u0002\u0003E\u000b\u0011UQ\u0006$\b%\\3b]N\u0004C\u000f[1uAQDW\r\t7pON\u0004S.Y=!CB\u0004X-\u0019:!_V$\be\u001c4!_J$WM\u001d\u0017!UVl'\r\\5oO\u0002Jx.\u001e:!Y><7\u000fI1oI\u0002\u001a8M]3xS:<\u0007%\u001e9\u000bA\u0001\u0002#\u0006I=pkJ\u0004C/\u001a:nS:\fGN\u0003\u0011!A)z\u0013AC5t\u001fJLw-\u001b8bYR\u0011\u0011q\u0001\t\u0004\u001d\u0006%\u0011bAA\u0006\u001f\n9!i\\8mK\u0006t\u0007&B\u0007oi\u0006=\u0011EAA\t\u0003\tEvF\u000b\u0016\u000bA\u0001\u0002#\u0006I+tK\u0012\u0004Co\u001c\u0011dQ\u0016\u001c7\u000eI<iKRDWM\u001d\u0011uQ\u0016\u00043/_:uK6\u00043\u000f\u001e:fC6\u001c\b%\u0019:fA\u0005dG\u000e\t\u0012pe&<\u0017N\\1mE1\u0002\u0013\u000eL3/AQDW-\u001f\u0006!A\u0001R\u0003\u0005[1wK\u0002rw\u000e\u001e\u0011cK\u0016t\u0007e\u001c<feJLG\rZ3o]\u0001*6/\u001a3!M>\u0014\beY8eK\u0002\u0002\u0018\r\u001e5tAQD\u0017\r\u001e\u0011oK\u0016$\u0007\u0005^8!o>\u00148\u000e\t3jM\u001a,'/\u001a8uYfT\u0001\u0005\t\u0011+A%4\u0007\u0005\u001e5fs\u0002B\u0017M^3!E\u0016,g\u000eI8wKJ\u0014\u0018\u000e\u001a3f]\u0002BSML4/A!\fg\u000e\u001a7j]\u001e\u00043/\u001e2qe>\u001cWm]:!gR$w.\u001e;0gR$WM\u001d:*\u0015\u0001\u0002\u0003E\u000b\u0006!A\u0001R\u0003%Q:tk6,7\u000f\t;iCR\u0004C\u000f[3!CB\u0004H.[2bi&|g\u000eI8oYf\u0004So]3tAm[v/\u001b;i'R\u0014X-Y7t;v\u0003Co\u001c\u0011pm\u0016\u0014(/\u001b3f\u0015\u0001\u0002\u0003E\u000b\u0011ti\u0012|W\u000f^\u0018ti\u0012,'O]\u0018ti\u0012LgN\f\u0006!A\u0001Rs&A\u0006pe&<\u0017N\\1m\u000bJ\u0014\b&\u0002\boi\u0006]\u0011EAA\r\u0003\u0005\rsF\u000b\u0016\u000bA\u0001\u0002#\u0006\t+iK\u0002z'/[4j]\u0006d\u0007E\\8o[=4XM\u001d:jI\u0016\u00043\u000f\u001e3feJd\u0003%^:fI\u00022wN\u001d\u0011eK\n,xmZ5oO\u0002\u0002XO\u001d9pg\u0016\u001c\b%\u001a\u0018h]\u0001Jg\rI=pk*\u0001\u0003\u0005\t\u0016!o\u0006tG\u000f\t;pAA\u0014\u0018N\u001c;!gR,hM\u001a\u0011xQ&dW\r\t;iK\u0002\u001a\u0018p\u001d;f[\u0002\u001aHO]3b[N\u0004sN^3se&$W\rI1sK\u0002jWm]:fI\u0002*\bO\u0003\u0011!A)z#A\u0005)v[B,G\r\u0015:pG\u0016\u001c8/\u00138qkR\u001cBaD'\u0002 A!\u0011\u0011EA\u0014\u001b\t\t\u0019C\u0003\u0002\u0002&\u0005\u0011qn]\u0005\u0005\u0003S\t\u0019C\u0001\u0007Qe>\u001cWm]:J]B,H\u000f\u0006\u0002\u0002.A\u0019\u0011qF\b\u000e\u0003%\tAB]3eSJ,7\r\u001e$s_6,\"!!\u000e\u0011\t\u0005]\u00121\t\b\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011QH-\u0002\t1\fgnZ\u0005\u0005\u0003\u0003\nY$\u0001\bQe>\u001cWm]:Ck&dG-\u001a:\n\t\u0005\u0015\u0013q\t\u0002\t%\u0016$\u0017N]3di*!\u0011\u0011IA\u001e\u00031\u0001(o\\2fgNLe\u000e];u)\u0011\ti%a\u0019\u0011\u000b9\u000by%a\u0015\n\u0007\u0005EsJ\u0001\u0003T_6,\u0007\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\u0007G2LWM\u001c;\u000b\u0007\u0005u\u0013*\u0001\u0003nC&t\u0017\u0002BA1\u0003/\u00121\"\u00138qkR\u0004V/\u001c9fe\"A\u0011Q\r\n\u0005\u0002\u0004\t9'A\u0005qe>\u001cWm]:J]B)a*!\u001b\u0002n%\u0019\u00111N(\u0003\u0011q\u0012\u0017P\\1nKz\u0002B!a\u001c\u0002\u00009!\u0011\u0011OA>\u001d\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\u0017\u00061AH]8pizJ!!!\n\n\t\u0005u\u00141E\u0001\u000b'V\u0014\u0007K]8dKN\u001c\u0018b\u00013\u0002\u0002*!\u0011QPA\u0012\u0005M\u0001V/\u001c9fIB\u0013xnY3tg>+H\u000f];u'\u0011\u0019R*a\"\u0011\t\u0005\u0005\u0012\u0011R\u0005\u0005\u0003\u0017\u000b\u0019CA\u0007Qe>\u001cWm]:PkR\u0004X\u000f^\u0001\u0005I\u0016\u001cH\u000fE\u0002W\u0003#K1!a%X\u00051yU\u000f\u001e9viN#(/Z1n)\u0011\t9*!'\u0011\u0007\u0005=2\u0003C\u0004\u0002\u000eV\u0001\r!a$\u0002\u0015I,G-\u001b:fGR$v.A\u0007qe>\u001cWm]:PkR\u0004X\u000f\u001e\u000b\u0005\u0003\u001b\n\t\u000b\u0003\u0005\u0002$^!\t\u0019AAS\u0003)\u0001(o\\2fgN|U\u000f\u001e\t\u0006\u001d\u0006%\u0014q\u0015\t\u0005\u0003_\nI+\u0003\u0003\u0002\u0014\u0006\u0005\u0015aC<ji\"\u001cFO]3b[N,B!a,\u00028R!\u0011\u0011WAh)\u0011\t\u0019,!3\u0011\t\u0005U\u0016q\u0017\u0007\u0001\t\u001d\tI\f\u0007b\u0001\u0003w\u0013\u0011\u0001V\t\u0005\u0003{\u000b\u0019\rE\u0002O\u0003\u007fK1!!1P\u0005\u001dqu\u000e\u001e5j]\u001e\u00042ATAc\u0013\r\t9m\u0014\u0002\u0004\u0003:L\b\u0002CAf1\u0011\u0005\r!!4\u0002\u0003Q\u0004RATA5\u0003gCa!!5\u0019\u0001\u0004A\u0017!D:zgR,Wn\u0015;sK\u0006l7/A\u000fxSRDGk\u001c9MKZ,GnU=ti\u0016l7\u000b\u001e:fC6\u0004&o\u001c=z+\u0011\t9.a7\u0015\t\u0005e\u0017Q\u001c\t\u0005\u0003k\u000bY\u000eB\u0004\u0002:f\u0011\r!a/\t\u0011\u0005-\u0017\u0004\"a\u0001\u0003?\u0004RATA5\u00033DS!\u00078u\u0003G\f#!!:\u0002\tsy#F\u000b\u0006!A\u0001R\u0003%T1oC\u001e,7\u000f\t;iK\u0002:Gn\u001c2bY\u0002zg/\u001a:sS\u0012,\u0007e\u001c4!ANK8\u000f^3n]mLg\u000eL8vi2*'O]?a]\u0001ze/\u001a:sS\u0012,7\u000fI8gAQDwn]3!gR\u0014X-Y7tA\u0005\u0014XM\u0003\u0011!A)\u0002s\r\\8cC2d\u0003e]8!o\u0016\u00043-\u00198o_R\u0004#.^:uA=4XM\u001d:jI\u0016\u0004C\u000f[3nAA,'/L;tK6\u001a\u0018\u000e^3!S:\u0004\u0013\rI7vYRLG\u000f\u001b:fC\u0012,G\rI3om&\u0014xN\\7f]RT\u0001\u0005\t\u0011+A\t,7-Y;tK\u0002\"\u0017N\u001a4fe\u0016tG\u000f\t;ie\u0016\fGm\u001d\u0011nCf\u0004\u0013N\u001c;fe2,\u0017M^3!C:$\u0007e\u001d;p[B\u0004sN^3sA\u0015\f7\r\u001b\u0011pi\",'oJ:!_Z,'/L<sSR,7O\f\u0006!A\u0001R\u0003%\u00138ti\u0016\fG\r\f\u0011xK\u0002zg/\u001a:.oJLG/\u001a\u0011uQ\u0016l\u0007e\u001a7pE\u0006dG.\u001f\u0011xSRD\u0007%\u0019\u0011tKR\u0004sN\u001a\u0011tiJ,\u0017-\\:!i\"\fG\u000f\t3pKN\u0004cn\u001c;iS:<\u0007EY;u\u0015\u0001\u0002\u0003E\u000b\u0011g_J<\u0018M\u001d3!i>\u0004C\u000f[3!a\u0016\u0014X\u0006\u001e5sK\u0006$\u0007eW.UQJ,\u0017\r\u001a'pG\u0006d7\u000b\u001e:fC6\u001chfY;se\u0016tG/X/!gR\u0014X-Y7tY\u0001\nG\u000e\\8xS:<\u0007eY1mY\u0016\u00148O\u0003\u0011!A)\u0002Co\u001c\u0011fC\u000eD\u0007E]3bG\"\u0004C\u000f[3je\u0002zwO\u001c\u0011uQJ,\u0017\rZ\u0017m_\u000e\fG\u000eI:ue\u0016\fWn\u001d\u0011xSRDw.\u001e;!G2\f7\u000f[5oO\u0002\n7M]8tg\u0002jW\u000f\u001c;ja2,\u0007\u0005\u001e5sK\u0006$7O\u0003\u0011!A)z\u0013\u0001H:fiR{\u0007\u000fT3wK2\u001c\u0016p\u001d;f[N#(/Z1n!J|\u00070\u001f\u000b\u0003\u0003W\u00042ATAw\u0013\r\tyo\u0014\u0002\u0005+:LG/\u0001\nUQJ,\u0017\r\u001a'pG\u0006d7\u000b\u001e:fC6\u001c\bcAA\u00189\t\u0011B\u000b\u001b:fC\u0012dunY1m'R\u0014X-Y7t'\taR\n\u0006\u0002\u0002t\u000691-\u001e:sK:$XCAA\u0000!\u0015\u0011\tAa\u0002i\u001b\t\u0011\u0019AC\u0002\u0003\u0006=\u000bA!\u001e;jY&!!\u0011\u0002B\u0002\u0005=!\u0015P\\1nS\u000e4\u0016M]5bE2,\u0017\u0001C2veJ,g\u000e\u001e\u0011\u0002\u0007=+H\u000fE\u0002\u0003\u0012\u0005j\u0011\u0001\b\u0002\u0004\u001fV$8CA\u0011V)\t\u0011y!A\u0002FeJ\u00042A!\u0005%\u0005\r)%O]\n\u0003IU#\"Aa\u0007\u0002\u0005%s\u0007c\u0001B\tO\t\u0011\u0011J\\\n\u0004O\t-\u0002c\u0001B\te\t\u0001\u0002K]8ys&s\u0007/\u001e;TiJ,\u0017-\\\n\u0003e\t$\"Aa\u000b\u0002\u0011\u0011,G.Z4bi\u0016$\u0012AY\u0001\u0005e\u0016\fG\r\u0006\u0002\u0003<A\u0019aJ!\u0010\n\u0007\t}rJA\u0002J]R$\u0002Ba\u000f\u0003D\tM#q\u000b\u0005\b\u0005\u000b2\u0004\u0019\u0001B$\u0003\u0005\u0011\u0007#\u0002(\u0003J\t5\u0013b\u0001B&\u001f\n)\u0011I\u001d:bsB\u0019aJa\u0014\n\u0007\tEsJ\u0001\u0003CsR,\u0007b\u0002B+m\u0001\u0007!1H\u0001\u0004_\u001a4\u0007b\u0002B-m\u0001\u0007!1H\u0001\u0004Y\u0016tG\u0003\u0002B\u001e\u0005;BqA!\u00128\u0001\u0004\u00119%\u0001\u0006sK\u0006$gJQ=uKN$\u0002Ba\u000f\u0003d\t\u0015$q\r\u0005\b\u0005\u000bB\u0004\u0019\u0001B$\u0011\u001d\u0011)\u0006\u000fa\u0001\u0005wAqA!\u00179\u0001\u0004\u0011Y\u0004\u0006\u0003\u0003H\t-\u0004b\u0002B-s\u0001\u0007!1H\u0001\re\u0016\fG-\u00117m\u0005f$Xm\u001d\u000b\u0003\u0005\u000f\nA!\\1sWR!\u00111\u001eB;\u0011\u001d\u00119h\u000fa\u0001\u0005w\t\u0011B]3bI2LW.\u001b;\u0002\u001b5\f'o[*vaB|'\u000f^3e\u0003%\tg/Y5mC\ndW-A\u0003sKN,G/\u0001\u0003tW&\u0004H\u0003\u0002BB\u0005\u0013\u00032A\u0014BC\u0013\r\u00119i\u0014\u0002\u0005\u0019>tw\rC\u0004\u0003\f~\u0002\rAa!\u0002\u00039\fQa\u00197pg\u0016\f!\u0002\u001e:b]N4WM\u001d+p)\u0011\u0011\u0019Ia%\t\rM\u000b\u0005\u0019AAH)\t\u0011)CA\tQe>D\u0018pT;uaV$8\u000b\u001e:fC6\u001c2AKAH)\t\u0011i\nE\u0002\u0003\u0012)\"\"!a$\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0011\u0005-(Q\u0015BT\u0005SCqA!\u0012.\u0001\u0004\u00119\u0005C\u0004\u0003V5\u0002\rAa\u000f\t\u000f\teS\u00061\u0001\u0003<Q!\u00111\u001eBW\u0011\u001d\u0011)E\fa\u0001\u0005\u000f\"B!a;\u00032\"9!QI\u0018A\u0002\tm\u0012!\u00024mkND\u0017\u0001\u00043fEV<\u0007K]5oi2tG\u0003BAv\u0005sCqAa/C\u0001\u0004\u0011i,A\u0001t!\u0011\u0011yLa2\u000f\t\t\u0005'1\u0019\t\u0004\u0003gz\u0015b\u0001Bc\u001f\u00061\u0001K]3eK\u001aLAA!3\u0003L\n11\u000b\u001e:j]\u001eT1A!2P\u0005M!UMY;h\t\u0016dWmZ1uKN#(/Z1n'\t\u0019\u0005.A\u0005eK2,w-\u0019;faQ!!Q\u001bBl!\r\tyc\u0011\u0005\u0007\u0005#,\u0005\u0019\u00015")
public class SystemStreams {
    private final PrintStream out;
    private final PrintStream err;
    private final InputStream in;

    public static void setTopLevelSystemStreamProxy() {
        SystemStreams$.MODULE$.setTopLevelSystemStreamProxy();
    }

    @Scaladoc(value="/**\n   * Manages the global override of `System.{in,out,err}`. Overrides of those streams are\n   * global, so we cannot just override them per-use-site in a multithreaded environment\n   * because different threads may interleave and stomp over each other's over-writes.\n   * Instead, we over-write them globally with a set of streams that does nothing but\n   * forward to the per-thread [[ThreadLocalStreams.current]] streams, allowing callers\n   * to each reach their own thread-local streams without clashing across multiple threads\n   */")
    public static <T> T withTopLevelSystemStreamProxy(Function0<T> t) {
        return SystemStreams$.MODULE$.withTopLevelSystemStreamProxy(t);
    }

    public static <T> T withStreams(SystemStreams systemStreams, Function0<T> t) {
        return SystemStreams$.MODULE$.withStreams(systemStreams, t);
    }

    @Scaladoc(value="/**\n   * The original non-override stderr, used for debugging purposes e.g. if you\n   * want to print stuff while the system streams override are messed up\n   */")
    public static PrintStream originalErr() {
        return SystemStreams$.MODULE$.originalErr();
    }

    @Scaladoc(value="/**\n   * Used to check whether the system streams are all \"original\", i,e. they\n   * have not been overridden. Used for code paths that need to work differently\n   * if they have been overridden (e.g. handling subprocess stdout/stderr)\n   *\n   * Assumes that the application only uses [[withStreams]] to override\n   * stdout/stderr/stdin.\n   */")
    public static boolean isOriginal() {
        return SystemStreams$.MODULE$.isOriginal();
    }

    public static SystemStreams original() {
        return SystemStreams$.MODULE$.original();
    }

    public PrintStream out() {
        return this.out;
    }

    public PrintStream err() {
        return this.err;
    }

    public InputStream in() {
        return this.in;
    }

    public SystemStreams(PrintStream out, PrintStream err, InputStream in) {
        this.out = out;
        this.err = err;
        this.in = in;
    }

    public static class DebugDelegateStream
    extends SystemStreams {
        public DebugDelegateStream(SystemStreams delegate0) {
            super(new PrintStream(new ThreadLocalStreams.ProxyOutputStream(delegate0){
                private final SystemStreams delegate0$1;

                public OutputStream delegate() {
                    return this.delegate0$1.out();
                }

                public void write(byte[] b, int off, int len) {
                    SystemStreams$.MODULE$.mill$api$SystemStreams$$debugPrintln(new String(b, off, len));
                    super.write(b, off, len);
                }

                public void write(byte[] b) {
                    SystemStreams$.MODULE$.mill$api$SystemStreams$$debugPrintln(new String(b));
                    super.write(b);
                }

                public void write(int b) {
                    SystemStreams$.MODULE$.mill$api$SystemStreams$$debugPrintln(new String(new byte[]{(byte)b}));
                    super.write(b);
                }
                {
                    this.delegate0$1 = delegate0$1;
                }
            }), new PrintStream(new ThreadLocalStreams.ProxyOutputStream(delegate0){
                private final SystemStreams delegate0$1;

                public OutputStream delegate() {
                    return this.delegate0$1.err();
                }

                public void write(byte[] b, int off, int len) {
                    SystemStreams$.MODULE$.mill$api$SystemStreams$$debugPrintln(new String(b, off, len));
                    super.write(b, off, len);
                }

                public void write(byte[] b) {
                    SystemStreams$.MODULE$.mill$api$SystemStreams$$debugPrintln(new String(b));
                    super.write(b);
                }

                public void write(int b) {
                    SystemStreams$.MODULE$.mill$api$SystemStreams$$debugPrintln(new String(new byte[]{(byte)b}));
                    super.write(b);
                }
                {
                    this.delegate0$1 = delegate0$1;
                }
            }), delegate0.in());
        }
    }

    private static class PumpedProcessInput
    implements ProcessInput {
        @Override
        public ProcessBuilder.Redirect redirectFrom() {
            return ProcessBuilder.Redirect.PIPE;
        }

        public Some<InputPumper> processInput(Function0<SubProcess.InputStream> processIn) {
            return new Some<InputPumper>(new InputPumper(() -> System.in, () -> ((SubProcess.InputStream)processIn.apply()).wrapped(), Predef$.MODULE$.boolean2Boolean(true), () -> true));
        }
    }

    private static class PumpedProcessOutput
    implements ProcessOutput {
        private final OutputStream dest;

        @Override
        public ProcessBuilder.Redirect redirectTo() {
            return ProcessBuilder.Redirect.PIPE;
        }

        public Some<InputPumper> processOutput(Function0<SubProcess.OutputStream> processOut) {
            return new Some<InputPumper>(new InputPumper(() -> ((SubProcess.OutputStream)processOut.apply()).wrapped(), () -> $this.dest, Predef$.MODULE$.boolean2Boolean(false), () -> true));
        }

        public PumpedProcessOutput(OutputStream dest) {
            this.dest = dest;
        }
    }
}

