/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.attribute.validate.ValidatorFormat;

public enum Format {
    PNG("svg", "png", true, true){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.SVG;
        }
    }
    ,
    SVG("svg", "svg", false, true){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.SVG;
        }
    }
    ,
    SVG_STANDALONE("svg", "svg", false, true){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.SVG;
        }
    }
    ,
    DOT("dot", "dot"),
    XDOT("xdot", "xdot"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.XDOT;
        }
    }
    ,
    PLAIN("plain", "txt"),
    PLAIN_EXT("plain-ext", "txt"),
    PS("ps", "ps"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.POSTSCRIPT;
        }
    }
    ,
    PS2("ps2", "ps"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.POSTSCRIPT;
        }
    }
    ,
    JSON("json", "json"),
    JSON0("json0", "json"),
    IMAP("imap", "imap"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.MAP;
        }
    }
    ,
    CMAPX("cmapx", "cmapx"){

        @Override
        ValidatorFormat forValidator() {
            return ValidatorFormat.CMAP;
        }
    };

    final String vizName;
    public final String fileExtension;
    final boolean image;
    final boolean svg;

    private Format(String vizName, String fileExtension) {
        this(vizName, fileExtension, false, false);
    }

    private Format(String vizName, String fileExtension, boolean image, boolean svg) {
        this.vizName = vizName;
        this.fileExtension = fileExtension;
        this.image = image;
        this.svg = svg;
    }

    ValidatorFormat forValidator() {
        return ValidatorFormat.OTHER;
    }
}

