/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache.shaded.dirs.impl;

import coursier.cache.shaded.dirs.Constants;
import coursier.cache.shaded.dirs.impl.Windows;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;

public final class WindowsPowerShell
implements Windows {
    private static final String UTF8_BOM = "\ufeff";
    private static Object base64Encoder = null;
    private static Method base64EncodeMethod = null;
    static final String SCRIPT_START_BASE64 = Constants.operatingSystem == 'w' ? WindowsPowerShell.toUTF16LEBase64("& {\n[Console]::OutputEncoding = [System.Text.Encoding]::UTF8\nAdd-Type @\"\nusing System;\nusing System.Runtime.InteropServices;\npublic class Dir {\n  [DllImport(\"shell32.dll\")]\n  private static extern int SHGetKnownFolderPath([MarshalAs(UnmanagedType.LPStruct)] Guid rfid, uint dwFlags, IntPtr hToken, out IntPtr pszPath);\n  public static string GetKnownFolderPath(string rfid) {\n    IntPtr pszPath;\n    if (SHGetKnownFolderPath(new Guid(rfid), 0, IntPtr.Zero, out pszPath) != 0) return \"\";\n    string path = Marshal.PtrToStringUni(pszPath);\n    Marshal.FreeCoTaskMem(pszPath);\n    return path;\n  }\n}\n\"@\n") : null;

    @Override
    public String[] winDirs(String ... stringArray) {
        String[] stringArray2;
        int n = stringArray.length;
        StringBuilder stringBuilder = new StringBuilder(n * 68);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("[Dir]::GetKnownFolderPath(\"");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\")\n");
        }
        String string = SCRIPT_START_BASE64 + WindowsPowerShell.toUTF16LEBase64(stringBuilder + "}");
        String string2 = System.getenv("Path");
        String[] stringArray3 = stringArray2 = string2 == null ? new String[]{} : string2.split(File.pathSeparator);
        if (stringArray2.length == 0) {
            return WindowsPowerShell.windowsFallback(n, string);
        }
        try {
            return WindowsPowerShell.runWinCommands(n, stringArray2, string);
        }
        catch (IOException iOException) {
            return WindowsPowerShell.windowsFallback(n, string);
        }
    }

    private static String toUTF16LEBase64(String string) {
        byte[] byArray = string.getBytes(Charset.forName("UTF-16LE"));
        if (base64EncodeMethod == null) {
            WindowsPowerShell.initBase64Encoding();
        }
        try {
            return (String)base64EncodeMethod.invoke(base64Encoder, new Object[]{byArray});
        }
        catch (Exception exception) {
            throw new RuntimeException("Base64 encoding failed!", exception);
        }
    }

    private static void initBase64Encoding() {
        try {
            base64Encoder = Class.forName("java.util.Base64").getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
            base64EncodeMethod = base64Encoder.getClass().getMethod("encodeToString", byte[].class);
        }
        catch (Exception exception) {
            try {
                base64EncodeMethod = Class.forName("sun.misc.BASE64Encoder").getMethod("encode", byte[].class);
            }
            catch (Exception exception2) {
                throw new RuntimeException("Could not find any viable Base64 encoder! (java.util.Base64 failed with: " + exception.getMessage() + ")", exception2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] runCommands(int n, Charset charset, String ... stringArray) throws IOException {
        Process process = new ProcessBuilder(stringArray).start();
        String[] stringArray2 = new String[n];
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), charset));
        try {
            for (int i = 0; i < n; ++i) {
                String string = bufferedReader.readLine();
                if (i == 0 && Constants.operatingSystem == 'w' && string != null && string.startsWith(UTF8_BOM)) {
                    string = string.substring(UTF8_BOM.length());
                }
                stringArray2[i] = string;
            }
            String[] stringArray3 = stringArray2;
            return stringArray3;
        }
        finally {
            process.destroy();
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static String[] runWinCommands(int n, String[] stringArray, String string) throws IOException {
        String[] stringArray2 = new String[]{"powershell.exe", "pwsh.exe"};
        IOException iOException = null;
        for (String string2 : stringArray) {
            for (String string3 : stringArray2) {
                File file = new File(string2, string3);
                if (!file.exists()) continue;
                try {
                    return WindowsPowerShell.runCommands(n, Charset.forName("UTF-8"), file.toString(), "-NoProfile", "-EncodedCommand", string);
                }
                catch (IOException iOException2) {
                    iOException = iOException == null ? iOException2 : iOException;
                }
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("no directories");
    }

    private static String[] windowsFallback(int n, String string) {
        File file = new File("C:\\Program Files\\Powershell");
        String[] stringArray = file.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length + 1];
        String string2 = System.getenv("SystemRoot");
        if (string2 == null) {
            string2 = "C:\\Windows";
        }
        stringArray2[0] = string2 + "\\System32\\WindowsPowerShell\\v1.0\\";
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = new File(file, stringArray[i]).toString();
        }
        try {
            return WindowsPowerShell.runWinCommands(n, stringArray2, string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Couldn't find pwsh.exe or powershell.exe on path or in default system locations", iOException);
        }
    }
}

