/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.StringTokenizer;
import pcgen.base.util.MapToList;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseSelectionActor;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.PatternMatchingReference;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.Skill;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.AssociatedChanges;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MoncskillToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race>,
ChooseSelectionActor<Skill> {
    private static final Class<Skill> SKILL_CLASS = Skill.class;

    public String getTokenName() {
        return "MONCSKILL";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        boolean firstToken = true;
        boolean foundAny = false;
        boolean foundOther = false;
        StringTokenizer tok = new StringTokenizer(value, "|");
        CDOMGroupRef monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, new String[]{"Monster"});
        while (tok.hasMoreTokens()) {
            CDOMReference<Skill> skill;
            String tokText = tok.nextToken();
            if (".CLEAR".equals(tokText)) {
                if (!firstToken) {
                    return new ParseResult.Fail("Non-sensical situation was encountered while parsing " + this.getTokenName() + ": When used, .CLEAR must be the first argument", context);
                }
                context.getListContext().removeAllFromList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList);
            } else if (tokText.startsWith(".CLEAR.")) {
                skill = null;
                String clearText = tokText.substring(7);
                if ("ALL".equals(clearText)) {
                    skill = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
                } else if ("LIST".equals(clearText)) {
                    context.getObjectContext().removeFromList((CDOMObject)race, ListKey.NEW_CHOOSE_ACTOR, (Object)this);
                } else {
                    skill = this.getSkillReference(context, clearText);
                    if (skill == null) {
                        return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                    }
                }
                if (skill != null) {
                    context.getListContext().removeFromList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList, skill);
                }
            } else {
                skill = null;
                if ("ALL".equals(tokText)) {
                    foundAny = true;
                    skill = context.getReferenceContext().getCDOMAllReference(SKILL_CLASS);
                } else {
                    foundOther = true;
                    if ("LIST".equals(tokText)) {
                        context.getObjectContext().addToList((CDOMObject)race, ListKey.NEW_CHOOSE_ACTOR, (Object)this);
                    } else {
                        skill = this.getSkillReference(context, tokText);
                        if (skill == null) {
                            return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName(), context);
                        }
                    }
                }
                if (skill != null) {
                    AssociatedPrereqObject apo = context.getListContext().addToList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList, skill);
                    apo.setAssociation(AssociationKey.SKILL_COST, (Object)SkillCost.CLASS);
                }
            }
            firstToken = false;
        }
        if (foundAny && foundOther) {
            return new ParseResult.Fail("Non-sensical " + this.getTokenName() + ": Contains ANY and a specific reference: " + value, context);
        }
        return ParseResult.SUCCESS;
    }

    private CDOMReference<Skill> getSkillReference(LoadContext context, String tokText) {
        if (tokText.endsWith("%")) {
            return new PatternMatchingReference(Skill.class, context.getReferenceContext().getCDOMAllReference(SKILL_CLASS), tokText);
        }
        return TokenUtilities.getTypeOrPrimitive((LoadContext)context, SKILL_CLASS, (String)tokText);
    }

    public String[] unparse(LoadContext context, Race race) {
        Collection listAdded;
        MapToList map;
        Collection listRemoved;
        CDOMGroupRef monsterList = context.getReferenceContext().getCDOMTypeReference(ClassSkillList.class, new String[]{"Monster"});
        AssociatedChanges changes = context.getListContext().getChangesInList(this.getTokenName(), (CDOMObject)race, (CDOMReference)monsterList);
        Changes listChanges = context.getObjectContext().getListChanges((CDOMObject)race, ListKey.NEW_CHOOSE_ACTOR);
        ArrayList<String> list = new ArrayList<String>();
        Collection removedItems = changes.getRemoved();
        if (removedItems != null && !removedItems.isEmpty()) {
            if (changes.includesGlobalClear()) {
                context.addWriteMessage("Non-sensical relationship in " + this.getTokenName() + ": global .CLEAR and local .CLEAR. performed");
                return null;
            }
            list.add(".CLEAR." + ReferenceUtilities.joinLstFormat((Collection)removedItems, (String)"|.CLEAR."));
        }
        if ((listRemoved = listChanges.getRemoved()) != null && !listRemoved.isEmpty() && listRemoved.contains((Object)this)) {
            list.add(".CLEAR.LIST");
        }
        if (changes.includesGlobalClear()) {
            list.add(".CLEAR");
        }
        if ((map = changes.getAddedAssociations()) != null && !map.isEmpty()) {
            Set added = map.getKeySet();
            for (CDOMReference ab : added) {
                for (AssociatedPrereqObject assoc : map.getListFor((Object)ab)) {
                    if (SkillCost.CLASS.equals(assoc.getAssociation(AssociationKey.SKILL_COST))) continue;
                    context.addWriteMessage("Skill Cost must be CLASS for Token " + this.getTokenName());
                    return null;
                }
            }
            list.add(ReferenceUtilities.joinLstFormat((Collection)added, (String)"|"));
        }
        if ((listAdded = listChanges.getAdded()) != null && !listAdded.isEmpty()) {
            for (ChooseSelectionActor csa : listAdded) {
                if (!csa.getSource().equals(this.getTokenName())) continue;
                try {
                    list.add(csa.getLstFormat());
                }
                catch (PersistenceLayerException e) {
                    context.addWriteMessage("Error writing Prerequisite: " + (Object)((Object)e));
                    return null;
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public Class<Race> getTokenClass() {
        return Race.class;
    }

    public void applyChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        pc.addMonCSkill(skill, (Object)obj);
    }

    public void removeChoice(ChooseDriver obj, Skill skill, PlayerCharacter pc) {
        pc.removeMonCSkill(skill, (Object)obj);
    }

    public String getSource() {
        return this.getTokenName();
    }

    public String getLstFormat() {
        return "LIST";
    }

    public Class<Skill> getChoiceClass() {
        return SKILL_CLASS;
    }
}

