/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.core.PCClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class MaxlevelToken
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "MAXLEVEL";
    }

    public ParseResult parseToken(LoadContext context, PCClass pcc, String value) {
        Integer lim;
        if ("NOLIMIT".equalsIgnoreCase(value)) {
            lim = -1;
        } else {
            try {
                lim = Integer.valueOf(value);
                if (lim <= 0) {
                    return new ParseResult.Fail("Value less than 1 is not valid for " + this.getTokenName() + ": " + value, context);
                }
            }
            catch (NumberFormatException nfe) {
                return new ParseResult.Fail("Value was not a number for " + this.getTokenName() + ": " + value, context);
            }
        }
        context.getObjectContext().put((CDOMObject)pcc, IntegerKey.LEVEL_LIMIT, lim);
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, PCClass pcc) {
        Integer lim = context.getObjectContext().getInteger((CDOMObject)pcc, IntegerKey.LEVEL_LIMIT);
        if (lim == null) {
            return null;
        }
        String returnString = lim.toString();
        if (lim.equals(-1)) {
            returnString = "NOLIMIT";
        } else if (lim <= 0) {
            context.addWriteMessage(this.getTokenName() + " must be an integer > 0");
            return null;
        }
        return new String[]{returnString};
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

