/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.race;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.Race;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.Logging;

public class HitdiceadvancementToken
extends AbstractTokenWithSeparator<Race>
implements CDOMPrimaryToken<Race> {
    @Override
    public String getTokenName() {
        return "HITDICEADVANCEMENT";
    }

    @Override
    protected char separator() {
        return ',';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Race race, String value) {
        StringTokenizer commaTok = new StringTokenizer(value, ",");
        context.getObjectContext().removeList(race, ListKey.HITDICE_ADVANCEMENT);
        int last = 0;
        while (commaTok.hasMoreTokens()) {
            int hd;
            String tok = commaTok.nextToken();
            if ("*".equals(tok)) {
                if (commaTok.hasMoreTokens()) {
                    return new ParseResult.Fail("Found * in " + this.getTokenName() + " but was not at end of list", context);
                }
                hd = Integer.MAX_VALUE;
            } else {
                try {
                    hd = Integer.parseInt(tok);
                    if (hd < last) {
                        return new ParseResult.Fail("Found " + hd + " in " + this.getTokenName() + " but was < 1 " + "or the previous value in the list: " + value, context);
                    }
                    last = hd;
                }
                catch (NumberFormatException nfe) {
                    return new ParseResult.Fail(nfe.getMessage(), context);
                }
            }
            context.getObjectContext().addToList(race, ListKey.HITDICE_ADVANCEMENT, hd);
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Race race) {
        Changes<Integer> changes = context.getObjectContext().getListChanges(race, ListKey.HITDICE_ADVANCEMENT);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean needsComma = false;
        int last = 0;
        Collection<Integer> list = changes.getAdded();
        Iterator<Integer> it = list.iterator();
        while (it.hasNext()) {
            if (needsComma) {
                sb.append(',');
            }
            needsComma = true;
            Integer hd = it.next();
            if (hd == Integer.MAX_VALUE) {
                if (it.hasNext()) {
                    context.addWriteMessage("Integer MAX_VALUE found in " + this.getTokenName() + " was not at the end of the array.");
                    return null;
                }
                sb.append('*');
                continue;
            }
            if (hd < last) {
                Logging.errorPrint("Found " + hd + " in " + this.getTokenName() + " but was <= zero " + "or the previous value in the list: " + list);
                return null;
            }
            last = hd;
            sb.append(hd);
        }
        return new String[]{sb.toString()};
    }

    @Override
    public Class<Race> getTokenClass() {
        return Race.class;
    }
}

