/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import gmgen.GMGenSystem;
import gmgen.io.SimpleFileFilter;
import java.awt.Component;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import pcgen.core.SettingsHandler;
import plugin.dicebag.gui.DiceBagModel;
import plugin.dicebag.gui.DiceBagPluginModel;
import plugin.dicebag.gui.DiceBagPluginView;

public class DiceBagPluginController {
    private DiceBagPluginModel theModel = new DiceBagPluginModel();
    private DiceBagPluginView theView = new DiceBagPluginView(this.theModel);

    public DiceBagPluginController() {
        this.openInitialBags();
    }

    public Component getComponent() {
        return this.theView.getMainComponent();
    }

    public static File chooseSaveFile(DiceBagModel bag) {
        File returnValue = null;
        JFileChooser save = new JFileChooser();
        String[] fileExt = new String[]{"dbg"};
        SimpleFileFilter ff = new SimpleFileFilter(fileExt, "GMGen Dice Bag");
        save.addChoosableFileFilter(ff);
        save.setFileFilter(ff);
        if (bag.getFilePath() != null) {
            save.setSelectedFile(new File(bag.getFilePath()));
        } else {
            String sFile = SettingsHandler.getGMGenOption("DiceBag.LastFile", System.getProperty("user.dir"));
            save.setCurrentDirectory(new File(sFile));
        }
        if (save.showSaveDialog(GMGenSystem.inst) == 0) {
            SettingsHandler.setGMGenOption("DiceBag.LastFile", save.getSelectedFile().getParent());
            String fileName = save.getSelectedFile().getName();
            String dirName = save.getSelectedFile().getParent();
            String ext = "";
            if (fileName.indexOf(".dbg") < 0) {
                ext = ".dbg";
            }
            returnValue = new File(dirName + File.separator + fileName + ext);
        }
        return returnValue;
    }

    public void fileNew() {
        this.theModel.addNewDicebag();
    }

    public boolean fileOpen() {
        File defaultFile;
        boolean returnValue = false;
        String sFile = SettingsHandler.getGMGenOption("DiceBag.LastFile", System.getProperty("user.dir"));
        JFileChooser open = new JFileChooser();
        if (sFile != null && (defaultFile = new File(sFile)).exists()) {
            open.setCurrentDirectory(defaultFile);
        }
        String[] fileExt = new String[]{"dbg"};
        SimpleFileFilter ff = new SimpleFileFilter(fileExt, "GMGen Dice Bag");
        open.addChoosableFileFilter(ff);
        open.setFileFilter(ff);
        if (open.showOpenDialog(GMGenSystem.inst) == 0) {
            this.openFile(open.getSelectedFile());
            returnValue = true;
        }
        return returnValue;
    }

    public void openFile(File file) {
        SettingsHandler.setGMGenOption("DiceBag.LastFile", file.getParent());
        this.theModel.loadDiceBag(file);
    }

    public void fileSave() {
        File saveFile;
        if (this.theModel.getActiveBag() != null && (saveFile = DiceBagPluginController.chooseSaveFile(this.theModel.getActiveBag())) != null) {
            int choice;
            if (saveFile.exists() && (choice = JOptionPane.showConfirmDialog(this.getComponent(), "File Exists, Overwrite?", "File Exists", 0, 3)) == 1) {
                return;
            }
            this.theModel.saveDiceBag(this.theModel.getActiveBag(), saveFile);
        }
    }

    public void windowClosed() {
        this.theView.closeAll();
    }

    protected void openInitialBags() {
        String lastFiles = SettingsHandler.getGMGenOption("DiceBagcloseFiles", "");
        StringTokenizer tok = new StringTokenizer(lastFiles, "|");
        boolean noLoads = true;
        int i = 0;
        while (tok.hasMoreTokens()) {
            String fileName = tok.nextToken();
            File file = new File(fileName);
            if (file.exists() && fileName.endsWith(".dbg")) {
                try {
                    this.theModel.loadDiceBag(file);
                    noLoads = false;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ++i;
        }
        if (noLoads) {
            this.fileNew();
        }
    }
}

