/*
 * Decompiled with CFR 0.152.
 */
package pcgen.system;

import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.lang.StringUtils;
import pcgen.output.publish.OutputDB;
import pcgen.util.Logging;

public class PCGenPropBundle {
    private static ResourceBundle d_properties;
    private static ResourceBundle autobuildProperties;
    private static ResourceBundle svnProperties;

    private PCGenPropBundle() {
    }

    public static String getCodeMonkeys() {
        return PCGenPropBundle.getPropValue("CodeMonkeys", null);
    }

    public static String getEngineeringMonkeys() {
        return PCGenPropBundle.getPropValue("EngineeringMonkeys", null);
    }

    public static String getHeadCodeMonkey() {
        return PCGenPropBundle.getPropValue("HeadCodeMonkey", "Bryan McRoberts");
    }

    public static String getListMonkeys() {
        return PCGenPropBundle.getPropValue("ListMonkeys", null);
    }

    public static String getMailingList() {
        return PCGenPropBundle.getPropValue("MailingList", "http://groups.yahoo.com/group/pcgen");
    }

    public static String getProdVersionSeries() {
        return PCGenPropBundle.getPropValue("ProdVersionSeries", null);
    }

    public static String getReleaseDate() {
        return PCGenPropBundle.getPropValue("ReleaseDate", null);
    }

    public static String getTestMonkeys() {
        return PCGenPropBundle.getPropValue("TestMonkeys", null);
    }

    public static String getVersionNumber() {
        return PCGenPropBundle.getPropValue("VersionNumber", null);
    }

    public static String getWWWHome() {
        return PCGenPropBundle.getPropValue("WWWHome", "http://pcgen.sourceforge.net/");
    }

    private static String getPropValue(String propName, String fallback) {
        String result = null;
        if (propName != null && d_properties != null) {
            try {
                result = d_properties.getString(propName);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (result == null) {
            result = fallback != null ? fallback : "Missing property " + propName;
        }
        return result;
    }

    public static String getAutobuildNumber() {
        String buildNumKey = "BuildNumber";
        if (autobuildProperties != null && autobuildProperties.containsKey("BuildNumber")) {
            return autobuildProperties.getString("BuildNumber");
        }
        return "";
    }

    public static String getAutobuildDate() {
        String buildTimeKey = "BuildTime";
        if (autobuildProperties != null && autobuildProperties.containsKey("BuildTime")) {
            return autobuildProperties.getString("BuildTime");
        }
        return "";
    }

    public static String getAutobuildString() {
        String autobuildNumber = PCGenPropBundle.getAutobuildNumber();
        String autobuildDate = PCGenPropBundle.getAutobuildDate();
        if (StringUtils.isNotBlank(autobuildNumber)) {
            return " autobuild #" + autobuildNumber + " built on " + autobuildDate;
        }
        return "";
    }

    public static String getSvnRevisionNumber() {
        String svnRevNumKey = "svnrevision";
        if (svnProperties != null && svnProperties.containsKey("svnrevision")) {
            return svnProperties.getString("svnrevision");
        }
        return "";
    }

    public static String getSvnRevisionString() {
        String svnRevisionNumber = PCGenPropBundle.getSvnRevisionNumber();
        if (StringUtils.isNotBlank(svnRevisionNumber)) {
            return " r" + svnRevisionNumber;
        }
        return "";
    }

    static {
        FileInputStream fis;
        d_properties = null;
        autobuildProperties = null;
        svnProperties = null;
        try {
            d_properties = ResourceBundle.getBundle("pcgen/resources/prop/PCGenProp");
        }
        catch (MissingResourceException mre) {
            d_properties = null;
        }
        try {
            File autobuildProps = new File("autobuild.properties");
            if (autobuildProps.isFile() && autobuildProps.canRead()) {
                fis = new FileInputStream(autobuildProps);
                autobuildProperties = new PropertyResourceBundle(fis);
            }
        }
        catch (MissingResourceException mre) {
            Logging.errorPrint("Failed to load autobuild.properties", mre);
            autobuildProperties = null;
        }
        catch (IOException e) {
            Logging.errorPrint("autobuildProperties. failed", e);
        }
        try {
            File svnProps = new File("svn.properties");
            if (svnProps.isFile() && svnProps.canRead()) {
                fis = new FileInputStream(svnProps);
                svnProperties = new PropertyResourceBundle(fis);
            }
        }
        catch (MissingResourceException mre) {
            Logging.errorPrint("Failed to load autobuild.properties", mre);
            svnProperties = null;
        }
        catch (IOException e) {
            Logging.errorPrint("Failed to load autobuild.properties", e);
            svnProperties = null;
        }
        try {
            TemplateModel wrappedVersion = ObjectWrapper.DEFAULT_WRAPPER.wrap((Object)PCGenPropBundle.getVersionNumber());
            OutputDB.addGlobalModel("version", wrappedVersion);
        }
        catch (TemplateModelException e) {
            Logging.errorPrint("Failed to load version for FreeMarker", e);
        }
    }
}

