/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import pcgen.base.lang.UnreachableError;
import pcgen.core.utils.CoreUtility;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;

public class URIFactory {
    public static final URI FAILED_URI;
    private final URI rootURI;
    private final String offset;

    public URIFactory(URI root, String offset) {
        if (root == null) {
            throw new IllegalArgumentException("root URI cannot be null");
        }
        if (offset == null || offset.isEmpty()) {
            throw new IllegalArgumentException("URI offset cannot be null");
        }
        this.rootURI = root;
        this.offset = offset;
    }

    public URI getRootURI() {
        return this.rootURI;
    }

    public String getOffset() {
        return this.offset;
    }

    public URI getURI() {
        return URIFactory.getNonNormalizedPathURI(this.rootURI, this.offset).normalize();
    }

    public int hashCode() {
        return this.offset.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof URIFactory) {
            URIFactory other = (URIFactory)o;
            return this.offset.equals(other.offset) && this.rootURI.equals(other.rootURI);
        }
        return false;
    }

    private static URI getNonNormalizedPathURI(URI pccPath, String basePath) {
        String pathNoLeader;
        if (basePath.length() <= 0) {
            Logging.errorPrint("Empty Path to LST file in " + pccPath);
            return FAILED_URI;
        }
        if (basePath.charAt(0) == '@') {
            String pathNoLeader2 = URIFactory.trimLeadingFileSeparator(basePath.substring(1));
            String path = CoreUtility.fixFilenamePath(pathNoLeader2);
            return new File(ConfigurationSettings.getPccFilesDir(), path).toURI();
        }
        if (basePath.charAt(0) == '&') {
            String pathNoLeader3 = URIFactory.trimLeadingFileSeparator(basePath.substring(1));
            String path = CoreUtility.fixFilenamePath(pathNoLeader3);
            return new File(PCGenSettings.getVendorDataDir(), path).toURI();
        }
        if (basePath.charAt(0) == '$') {
            String pathNoLeader4 = URIFactory.trimLeadingFileSeparator(basePath.substring(1));
            String path = CoreUtility.fixFilenamePath(pathNoLeader4);
            return new File(PCGenSettings.getHomebrewDataDir(), path).toURI();
        }
        if (basePath.charAt(0) == '*') {
            String pathNoLeader5 = URIFactory.trimLeadingFileSeparator(basePath.substring(1));
            String path = CoreUtility.fixFilenamePath(pathNoLeader5);
            File pccFile = new File(PCGenSettings.getHomebrewDataDir(), path);
            if (pccFile.exists()) {
                return pccFile.toURI();
            }
            pccFile = new File(PCGenSettings.getVendorDataDir(), path);
            if (pccFile.exists()) {
                return pccFile.toURI();
            }
            return new File(ConfigurationSettings.getPccFilesDir(), path).toURI();
        }
        if (basePath.indexOf(58) > 0) {
            try {
                URL url = new URL(basePath);
                return new URI(url.getProtocol(), url.getHost(), url.getPath(), null);
            }
            catch (URISyntaxException e) {
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if ((pathNoLeader = URIFactory.trimLeadingFileSeparator(basePath)).startsWith("data")) {
            String path = CoreUtility.fixFilenamePath(pathNoLeader.substring(5));
            return new File(ConfigurationSettings.getPccFilesDir(), path).toURI();
        }
        String path = pccPath.getPath();
        try {
            return new URI(pccPath.getScheme(), null, path.substring(0, path.lastIndexOf(47) + 1) + basePath.replace('\\', '/'), null);
        }
        catch (URISyntaxException e) {
            Logging.errorPrint("URIFactory failed to convert " + path.substring(0, path.lastIndexOf(47) + 1) + basePath + " to a URI: " + e.getLocalizedMessage());
            return FAILED_URI;
        }
    }

    private static String trimLeadingFileSeparator(String basePath) {
        String pathNoLeader = basePath;
        if (pathNoLeader.startsWith("/") || pathNoLeader.startsWith(File.separator)) {
            pathNoLeader = pathNoLeader.substring(1);
        }
        return pathNoLeader;
    }

    static {
        try {
            FAILED_URI = new URI("file:/FAIL");
        }
        catch (URISyntaxException e) {
            throw new UnreachableError((Throwable)e);
        }
    }
}

