/*
 * Decompiled with CFR 0.152.
 */
package pcgen.persistence.lst;

import java.net.URI;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.GameMode;
import pcgen.core.LevelInfo;
import pcgen.core.XPTable;
import pcgen.persistence.lst.LevelLstToken;
import pcgen.persistence.lst.LstToken;
import pcgen.persistence.lst.LstUtils;
import pcgen.persistence.lst.TokenStore;
import pcgen.util.Logging;

public final class LevelLoader {
    private LevelLoader() {
    }

    public static String parseLine(GameMode gameMode, String inputLine, int lineNum, URI source, String xpTable) {
        if (gameMode == null) {
            return "";
        }
        if (inputLine.startsWith("XPTABLE:")) {
            String value = inputLine.substring(8);
            if (value.indexOf("\t") >= 0) {
                value = value.substring(0, value.indexOf("\t"));
            }
            if ((value = value.trim()).equals("")) {
                Logging.errorPrint("Error parsing level line \"" + inputLine + "\": empty XPTABLE value.");
            } else {
                value = value.intern();
                gameMode.addXPTableName(value);
                return value;
            }
        }
        if (xpTable.equals("")) {
            xpTable = "Default";
            gameMode.addXPTableName(xpTable);
        }
        LevelInfo levelInfo = new LevelInfo();
        StringTokenizer colToken = new StringTokenizer(inputLine, "\t");
        Map<String, LstToken> tokenMap = TokenStore.inst().getTokenMap(LevelLstToken.class);
        while (colToken.hasMoreTokens()) {
            String colString = colToken.nextToken().trim();
            int idxColon = colString.indexOf(58);
            String key = "";
            try {
                key = colString.substring(0, idxColon);
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
            LevelLstToken token = (LevelLstToken)tokenMap.get(key);
            if (token != null) {
                String value = colString.substring(idxColon + 1).intern();
                LstUtils.deprecationCheck(token, levelInfo.getLevelString(), source, value);
                if (token.parse(levelInfo, value)) continue;
                Logging.errorPrint("LevelLoader got invalid " + key + " value of '" + value + "' in '" + inputLine + "' at line " + lineNum + " of " + source + ". Token ignored.");
                continue;
            }
            Logging.errorPrint("LevelLoader got unexpected token of '" + colString + "' at line " + lineNum + ". Token ignored.");
        }
        if (LevelLoader.validateLevelInfo(gameMode, xpTable, levelInfo, inputLine, lineNum, source)) {
            gameMode.addLevelInfo(xpTable, levelInfo);
        }
        return xpTable;
    }

    private static boolean validateLevelInfo(GameMode gameMode, String xpTable, LevelInfo levelInfo, String inputLine, int lineNum, URI source) {
        String level = levelInfo.getLevelString();
        if (level == null) {
            Logging.errorPrint("LevelLoader got empty level value in '" + inputLine + "' at line " + lineNum + " of " + source + ". Line ignored.");
            return false;
        }
        XPTable existingTable = gameMode.getLevelInfo(xpTable);
        if (existingTable == null) {
            return true;
        }
        if (existingTable.getLevelInfo(level) != null) {
            Logging.errorPrint("LevelLoader got duplicate level value of '" + level + "' in '" + inputLine + "' at line " + lineNum + " of " + source + ". Line ignored.");
            return false;
        }
        if (!LevelLoader.isNumeric(level)) {
            return true;
        }
        if (!existingTable.validateSequence(level)) {
            Logging.errorPrint("LevelLoader got out of sequence level value of '" + level + "' in '" + inputLine + "' at line " + lineNum + " of " + source + ". Line ignored.");
        }
        return true;
    }

    private static boolean isNumeric(String level) {
        try {
            Integer.parseInt(level);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

