/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.File;
import org.apache.commons.lang.StringUtils;

public class ExportUtilities {
    private ExportUtilities() {
    }

    public static String getOutputExtension(String templateFilename, boolean isPdf) {
        String extension;
        if (isPdf) {
            return "pdf";
        }
        if (templateFilename.endsWith(".ftl")) {
            templateFilename = templateFilename.substring(0, templateFilename.length() - 4);
        }
        if (StringUtils.isEmpty(extension = StringUtils.substringAfterLast(templateFilename, "."))) {
            extension = StringUtils.substringAfterLast(templateFilename, "-");
        }
        return extension;
    }

    public static boolean isPdfTemplate(File templateFile) {
        return ExportUtilities.isPdfTemplate(templateFile.getName());
    }

    public static boolean isPdfTemplate(String templateFilename) {
        String extension = ExportUtilities.getOutputExtension(templateFilename, false);
        return extension.equalsIgnoreCase("pdf") || extension.equalsIgnoreCase("fo") || extension.equalsIgnoreCase("xslt") || extension.equalsIgnoreCase("xsl");
    }
}

