/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.prefs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui2.tools.Utility;

class NewPurchaseMethodDialog
extends JDialog {
    static final long serialVersionUID = -5321303573914291162L;
    private JButton cancelButton;
    private JButton okButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel buttonPanel;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTextField nameEdit;
    private JTextField pointsEdit;
    private boolean wasCancelled = true;

    public NewPurchaseMethodDialog(JDialog parent, boolean modal) {
        super((Dialog)parent, modal);
        this.initComponents();
        Utility.setDialogRelativeLocation(parent, this);
    }

    private NewPurchaseMethodDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        Utility.setDialogRelativeLocation(parent, this);
    }

    public String getEnteredName() {
        return this.nameEdit.getText().trim();
    }

    public int getEnteredPoints() {
        try {
            int points = Integer.parseInt(this.pointsEdit.getText());
            return points;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean getWasCancelled() {
        return this.wasCancelled;
    }

    public static void main(String[] args) {
        new NewPurchaseMethodDialog((Frame)new JFrame(), true).setVisible(true);
    }

    private void cancelButtonActionPerformed() {
        this.wasCancelled = true;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.nameEdit = new JTextField();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.pointsEdit = new JTextField();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Enter name and points for Purchase Method");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                NewPurchaseMethodDialog.this.closeDialog();
            }
        });
        this.jPanel1.setLayout(new FlowLayout(0));
        this.jLabel1.setText("Name:");
        this.jLabel1.setPreferredSize(new Dimension(140, 15));
        this.jPanel1.add(this.jLabel1);
        this.nameEdit.setPreferredSize(new Dimension(140, 20));
        this.jPanel1.add(this.nameEdit);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel2.setLayout(new FlowLayout(0));
        this.jLabel2.setText("Points:");
        this.jLabel2.setPreferredSize(new Dimension(140, 15));
        this.jPanel2.add(this.jLabel2);
        this.pointsEdit.setPreferredSize(new Dimension(30, 20));
        this.jPanel2.add(this.pointsEdit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewPurchaseMethodDialog.this.cancelButtonActionPerformed();
            }
        });
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.buttonPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewPurchaseMethodDialog.this.okButtonActionPerformed();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed() {
        if (this.getEnteredName().length() == 0) {
            ShowMessageDelegate.showMessageDialog("Please enter a name for this method.", "PCGen", MessageType.ERROR);
            return;
        }
        if (this.getEnteredPoints() <= 0) {
            ShowMessageDelegate.showMessageDialog("Invalid points value. Please try again.", "PCGen", MessageType.ERROR);
            return;
        }
        this.wasCancelled = false;
        this.setVisible(false);
        this.dispose();
    }
}

