/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import pcgen.facade.core.LanguageChooserFacade;
import pcgen.facade.core.LanguageFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DelegatingListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.Utility;
import pcgen.gui2.util.FacadeListModel;
import pcgen.gui2.util.JListEx;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.gui2.util.treeview.DataView;
import pcgen.gui2.util.treeview.DataViewColumn;
import pcgen.gui2.util.treeview.TreeView;
import pcgen.gui2.util.treeview.TreeViewModel;
import pcgen.gui2.util.treeview.TreeViewPath;
import pcgen.system.LanguageBundle;

public class LanguageChooserDialog
extends JDialog
implements ActionListener,
ReferenceListener<Integer> {
    private final LanguageChooserFacade chooser;
    private final JTreeViewTable<LanguageFacade> availTable;
    private final JLabel remainingLabel;
    private final LangTreeViewModel treeViewModel;
    private final FacadeListModel<LanguageFacade> listModel;
    private final JListEx list;

    public LanguageChooserDialog(Frame frame, LanguageChooserFacade chooser) {
        super(frame, true);
        this.chooser = chooser;
        this.availTable = new JTreeViewTable();
        this.remainingLabel = new JLabel();
        this.treeViewModel = new LangTreeViewModel();
        this.list = new JListEx();
        this.listModel = new FacadeListModel();
        this.treeViewModel.setDelegate(chooser.getAvailableList());
        this.listModel.setListFacade(chooser.getSelectedList());
        chooser.getRemainingSelections().addReferenceListener(this);
        this.initComponents();
        this.pack();
        Utility.installEscapeCloseOperation(this);
    }

    private void initComponents() {
        this.setTitle(this.chooser.getName());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                LanguageChooserDialog.this.treeViewModel.setDelegate(null);
                LanguageChooserDialog.this.listModel.setListFacade(null);
                LanguageChooserDialog.this.chooser.getRemainingSelections().removeReferenceListener(LanguageChooserDialog.this);
            }
        });
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout());
        JSplitPane split = new JSplitPane();
        JPanel leftPane = new JPanel(new BorderLayout());
        this.availTable.setTreeViewModel(this.treeViewModel);
        this.availTable.addActionListener(this);
        leftPane.add((Component)new JScrollPane(this.availTable), "Center");
        JPanel buttonPane1 = new JPanel(new FlowLayout());
        JButton addButton = new JButton(LanguageBundle.getString("in_sumLangAddLanguage"));
        addButton.setActionCommand("ADD");
        addButton.addActionListener(this);
        buttonPane1.add(addButton);
        buttonPane1.add(new JLabel(Icons.Forward16.getImageIcon()));
        leftPane.add((Component)buttonPane1, "South");
        split.setLeftComponent(leftPane);
        JPanel rightPane = new JPanel(new BorderLayout());
        JPanel labelPane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        labelPane.add((Component)new JLabel(LanguageBundle.getString("in_sumLangRemain")), new GridBagConstraints());
        this.remainingLabel.setText(this.chooser.getRemainingSelections().getReference().toString());
        labelPane.add((Component)this.remainingLabel, gbc);
        labelPane.add((Component)new JLabel(LanguageBundle.getString("in_sumSelectedLang")), gbc);
        rightPane.add((Component)labelPane, "North");
        this.list.setModel(this.listModel);
        this.list.setSelectionMode(0);
        this.list.addActionListener(this);
        rightPane.add((Component)new JScrollPane(this.list), "Center");
        JPanel buttonPane2 = new JPanel(new FlowLayout());
        buttonPane2.add(new JLabel(Icons.Back16.getImageIcon()));
        JButton removeButton = new JButton(LanguageBundle.getString("in_sumLangRemoveLanguage"));
        removeButton.setActionCommand("REMOVE");
        removeButton.addActionListener(this);
        buttonPane2.add(removeButton);
        rightPane.add((Component)buttonPane2, "South");
        split.setRightComponent(rightPane);
        pane.add((Component)split, "Center");
        JPanel bottomPane = new JPanel(new FlowLayout());
        JButton button = new JButton(LanguageBundle.getString("in_ok"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_ok"));
        button.setActionCommand("OK");
        button.addActionListener(this);
        bottomPane.add(button);
        button = new JButton(LanguageBundle.getString("in_cancel"));
        button.setMnemonic(LanguageBundle.getMnemonic("in_mn_cancel"));
        button.setActionCommand("CANCEL");
        button.addActionListener(this);
        bottomPane.add(button);
        pane.add((Component)bottomPane, "South");
    }

    @Override
    public void referenceChanged(ReferenceEvent<Integer> e) {
        this.remainingLabel.setText(e.getNewReference().toString());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ADD") || e.getSource() == this.availTable) {
            List<Object> data = this.availTable.getSelectedData();
            if (!data.isEmpty()) {
                for (Object object : data) {
                    if (!(object instanceof LanguageFacade)) continue;
                    this.chooser.addSelected((LanguageFacade)object);
                }
            }
            return;
        }
        if (e.getActionCommand().equals("REMOVE") || e.getSource() == this.list) {
            Object value = this.list.getSelectedValue();
            if (value != null) {
                this.chooser.removeSelected((LanguageFacade)value);
            }
            return;
        }
        if (e.getActionCommand().equals("OK")) {
            this.chooser.commit();
        } else {
            this.chooser.rollback();
        }
        this.dispose();
    }

    private static enum LanguageTreeView implements TreeView<LanguageFacade>
    {
        NAME("in_nameLabel"),
        TYPE_NAME("in_typeName");

        private String name;

        private LanguageTreeView(String name) {
            this.name = LanguageBundle.getString(name);
        }

        @Override
        public String getViewName() {
            return this.name;
        }

        @Override
        public List<TreeViewPath<LanguageFacade>> getPaths(LanguageFacade pobj) {
            ArrayList<TreeViewPath<LanguageFacade>> paths = new ArrayList<TreeViewPath<LanguageFacade>>();
            switch (this) {
                case NAME: {
                    return Collections.singletonList(new TreeViewPath<LanguageFacade>(pobj));
                }
                case TYPE_NAME: {
                    for (String type : pobj.getTypes()) {
                        paths.add(new TreeViewPath<LanguageFacade>(pobj, (Object)type));
                    }
                    return paths;
                }
            }
            throw new InternalError();
        }
    }

    private static class LangTreeViewModel
    extends DelegatingListFacade<LanguageFacade>
    implements TreeViewModel<LanguageFacade>,
    DataView<LanguageFacade> {
        private static final ListFacade<TreeView<LanguageFacade>> views = new DefaultListFacade<LanguageTreeView>(Arrays.asList(LanguageTreeView.values()));

        private LangTreeViewModel() {
        }

        @Override
        public ListFacade<? extends TreeView<LanguageFacade>> getTreeViews() {
            return views;
        }

        @Override
        public int getDefaultTreeViewIndex() {
            return 0;
        }

        @Override
        public DataView<LanguageFacade> getDataView() {
            return this;
        }

        @Override
        public ListFacade<LanguageFacade> getDataModel() {
            return this;
        }

        @Override
        public List<?> getData(LanguageFacade obj) {
            return Collections.emptyList();
        }

        @Override
        public List<? extends DataViewColumn> getDataColumns() {
            return Collections.emptyList();
        }

        @Override
        public String getPrefsKey() {
            return LanguageBundle.getString("in_sumLangAvailable");
        }
    }
}

