/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.logging.Level;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.core.SourceSelectionFacade;
import pcgen.facade.core.TempBonusFacade;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.SortedListFacade;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.gui2.PCGenActionMap;
import pcgen.gui2.PCGenFrame;
import pcgen.gui2.tools.CharacterSelectionListener;
import pcgen.gui2.util.AbstractListMenu;
import pcgen.gui2.util.AbstractRadioListMenu;
import pcgen.gui2.util.PCGMenu;
import pcgen.gui2.util.PCGMenuItem;
import pcgen.system.CharacterManager;
import pcgen.system.FacadeFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Comparators;
import pcgen.util.Logging;

public final class PCGenMenuBar
extends JMenuBar
implements CharacterSelectionListener {
    private final PCGenFrame frame;
    private final PCGenActionMap actionMap;
    private final EquipmentSetMenu equipmentMenu;
    private final TempBonusMenu tempMenu;
    private CharacterFacade character;

    public PCGenMenuBar(PCGenFrame frame) {
        this.frame = frame;
        this.actionMap = frame.getActionMap();
        this.equipmentMenu = new EquipmentSetMenu();
        this.tempMenu = new TempBonusMenu();
        this.initComponents();
    }

    private void initComponents() {
        this.add(new FileMenu());
        this.add(this.createEditMenu());
        this.add(this.createSourcesMenu());
        this.add(this.createToolsMenu());
        this.add(this.createHelpMenu());
    }

    private JMenu createEditMenu() {
        PCGMenu menu = new PCGMenu(this.actionMap.get("edit"));
        menu.add(new PCGMenuItem(this.actionMap.get("edit.addkit")));
        menu.addSeparator();
        menu.add(this.equipmentMenu);
        menu.add(this.tempMenu);
        return menu;
    }

    private JMenu createSourcesMenu() {
        PCGMenu menu = new PCGMenu(this.actionMap.get("sources"));
        menu.add(new PCGMenuItem(this.actionMap.get("sources.select")));
        menu.addSeparator();
        menu.add(new QuickSourceMenu());
        menu.addSeparator();
        menu.add(new PCGMenuItem(this.actionMap.get("sources.reload")));
        menu.add(new PCGMenuItem(this.actionMap.get("sources.unload")));
        menu.addSeparator();
        menu.add(this.actionMap.get("sources.installData"));
        return menu;
    }

    private JMenu createToolsMenu() {
        PCGMenu menu = new PCGMenu(this.actionMap.get("tools"));
        PCGMenu filtersMenu = new PCGMenu(this.actionMap.get("tools.filters"));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.kit")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.race")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.class")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.ability")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.skill")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.equipment")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.spell")));
        filtersMenu.add(new PCGMenuItem(this.actionMap.get("tools.filters.template")));
        PCGMenu generatorsMenu = new PCGMenu(this.actionMap.get("tools.generators"));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.treasure")));
        generatorsMenu.addSeparator();
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.stat")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.race")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.class")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.ability")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.skill")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.equipment")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.spell")));
        generatorsMenu.add(new PCGMenuItem(this.actionMap.get("tools.generators.template")));
        menu.add(new PCGMenuItem(this.actionMap.get("tools.preferences")));
        menu.addSeparator();
        menu.add(new PCGMenuItem(this.actionMap.get("tools.gmgen")));
        menu.addSeparator();
        menu.add(new PCGMenuItem(this.actionMap.get("tools.log")));
        menu.add(new LoggingLevelMenu());
        menu.add(new PCGMenuItem(this.actionMap.get("tools.calculator")));
        menu.add(new PCGMenuItem(this.actionMap.get("tools.coreview")));
        return menu;
    }

    private JMenu createHelpMenu() {
        PCGMenu menu = new PCGMenu(this.actionMap.get("help"));
        menu.add(new PCGMenuItem(this.actionMap.get("help.docs")));
        menu.addSeparator();
        menu.add(new PCGMenuItem(this.actionMap.get("help.ogl")));
        menu.add(new PCGMenuItem(this.actionMap.get("help.sponsors")));
        menu.add(new PCGMenuItem(this.actionMap.get("help.tod")));
        menu.addSeparator();
        menu.add(new PCGMenuItem(this.actionMap.get("help.about")));
        return menu;
    }

    @Override
    public void setCharacter(CharacterFacade character) {
        this.character = character;
        this.equipmentMenu.setListModel(character.getEquipmentSets());
        this.tempMenu.setListModel(character.getAvailableTempBonuses());
    }

    private static class LoggingLevelWrapper {
        private final Level level;

        public LoggingLevelWrapper(Level level) {
            this.level = level;
        }

        public String toString() {
            return LanguageBundle.getString("in_loglvl" + this.level.getName());
        }

        public Level getLevel() {
            return this.level;
        }
    }

    private class LoggingLevelMenu
    extends AbstractRadioListMenu<LoggingLevelWrapper> {
        public LoggingLevelMenu() {
            super(PCGenMenuBar.this.actionMap.get("tools.loggingLevel"));
            DefaultListFacade<LoggingLevelWrapper> levels = new DefaultListFacade<LoggingLevelWrapper>();
            Level currentLvl = Logging.getCurrentLoggingLevel();
            LoggingLevelWrapper current = null;
            for (Level level : Logging.getLoggingLevels()) {
                LoggingLevelWrapper levelWrapper = new LoggingLevelWrapper(level);
                levels.addElement(levelWrapper);
                if (level != currentLvl) continue;
                current = levelWrapper;
            }
            this.setListModel(levels);
            this.setSelectedItem(current);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object item = e.getItemSelectable().getSelectedObjects()[0];
                Level level = ((LoggingLevelWrapper)item).getLevel();
                Logging.setCurrentLoggingLevel(level);
            }
        }
    }

    private class TempBonusMenu
    extends AbstractListMenu<TempBonusFacade>
    implements ItemListener {
        public TempBonusMenu() {
            super(PCGenMenuBar.this.actionMap.get("edit.tempbonus"));
        }

        @Override
        protected JMenuItem createMenuItem(TempBonusFacade item, int index) {
            return new AbstractListMenu.CheckBoxMenuItem(item, PCGenMenuBar.this.character.getTempBonuses().containsElement(item), this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            TempBonusFacade bonus = (TempBonusFacade)e.getItemSelectable().getSelectedObjects()[0];
            if (e.getStateChange() == 1) {
                PCGenMenuBar.this.character.addTempBonus(bonus);
            } else {
                PCGenMenuBar.this.character.removeTempBonus(bonus);
            }
        }
    }

    private class EquipmentSetMenu
    extends AbstractRadioListMenu<EquipmentSetFacade> {
        public EquipmentSetMenu() {
            super(PCGenMenuBar.this.actionMap.get("edit.equipmentset"));
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    private class QuickSourceMenu
    extends AbstractRadioListMenu<SourceSelectionFacade>
    implements ReferenceListener<SourceSelectionFacade> {
        public QuickSourceMenu() {
            super(PCGenMenuBar.this.actionMap.get("sources.load"));
            ReferenceFacade<SourceSelectionFacade> ref = PCGenMenuBar.this.frame.getCurrentSourceSelectionRef();
            this.setSelectedItem(ref.getReference());
            ListFacade<SourceSelectionFacade> sources = FacadeFactory.getDisplayedSourceSelections();
            this.setListModel(new SortedListFacade<SourceSelectionFacade>(Comparators.toStringIgnoreCaseCollator(), sources));
            ref.addReferenceListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object item = e.getItemSelectable().getSelectedObjects()[0];
                if (PCGenMenuBar.this.frame.loadSourceSelection((SourceSelectionFacade)item)) {
                    this.setSelectedItem(PCGenMenuBar.this.frame.getCurrentSourceSelectionRef().getReference());
                }
            }
        }

        @Override
        public void referenceChanged(ReferenceEvent<SourceSelectionFacade> e) {
            this.clearSelection();
            this.setSelectedItem(e.getNewReference());
        }
    }

    private class PartyMenu
    extends AbstractListMenu<File>
    implements ActionListener {
        public PartyMenu() {
            super(PCGenMenuBar.this.actionMap.get("file.party"));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.party.open")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.party.close")));
            this.addSeparator();
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.party.save")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.party.saveas")));
            this.addSeparator();
            this.setOffset(6);
            this.setListModel(CharacterManager.getRecentParties());
        }

        protected PCGMenuItem createMenuItem(File item, int index) {
            PCGMenuItem menuItem = new PCGMenuItem();
            menuItem.setText(index + 1 + " " + item.getName());
            menuItem.setToolTipText(item.getAbsolutePath());
            menuItem.setActionCommand(item.getAbsolutePath());
            menuItem.setMnemonic(String.valueOf(index + 1).charAt(0));
            menuItem.addActionListener(this);
            return menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenMenuBar.this.frame.loadPartyFromFile(new File(e.getActionCommand()));
        }
    }

    private class FileMenu
    extends AbstractListMenu<File>
    implements ActionListener {
        public FileMenu() {
            super(PCGenMenuBar.this.actionMap.get("file"));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.new")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.open")));
            this.addSeparator();
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.close")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.closeall")));
            this.addSeparator();
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.save")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.saveas")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.saveall")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.reverttosaved")));
            this.addSeparator();
            this.add(new PartyMenu());
            this.addSeparator();
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.print")));
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.export")));
            this.addSeparator();
            this.setOffset(16);
            this.setListModel(CharacterManager.getRecentCharacters());
            this.addSeparator();
            this.add(new PCGMenuItem(PCGenMenuBar.this.actionMap.get("file.exit")));
        }

        protected PCGMenuItem createMenuItem(File item, int index) {
            PCGMenuItem menuItem = new PCGMenuItem();
            menuItem.setText(index + 1 + " " + item.getName());
            menuItem.setToolTipText(LanguageBundle.getFormattedString("in_OpenRecentCharTip", item.getAbsolutePath()));
            menuItem.setActionCommand(item.getAbsolutePath());
            menuItem.setMnemonic(String.valueOf(index + 1).charAt(0));
            menuItem.addActionListener(this);
            return menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PCGenMenuBar.this.frame.loadCharacterFromFile(new File(e.getActionCommand()));
        }
    }
}

