/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.prereq;

import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.core.Ability;
import pcgen.core.AbilityUtilities;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteException;
import pcgen.core.prereq.PrerequisiteTest;
import pcgen.core.prereq.PrerequisiteTestFactory;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;

public final class PrereqHandler {
    private PrereqHandler() {
    }

    public static boolean passesAll(Collection<Prerequisite> prereqList, PlayerCharacter aPC, Object caller) {
        if (prereqList == null || prereqList.isEmpty()) {
            return true;
        }
        if (caller instanceof Ability && AbilityUtilities.isFeat(caller) && Globals.checkRule("FEATPRE")) {
            return true;
        }
        if (caller instanceof CDOMObject && aPC != null && aPC.checkQualifyList((CDOMObject)caller)) {
            return true;
        }
        for (Prerequisite prereq : prereqList) {
            if (PrereqHandler.passes(prereq, aPC, caller)) continue;
            return false;
        }
        return true;
    }

    public static boolean passesAll(Collection<Prerequisite> prereqList, Equipment equip, PlayerCharacter aPC) {
        if (prereqList == null) {
            return true;
        }
        for (Prerequisite prereq : prereqList) {
            if (PrereqHandler.passes(prereq, equip, aPC)) continue;
            return false;
        }
        return true;
    }

    public static boolean passes(Prerequisite prereq, PlayerCharacter aPC, Object caller) {
        if (aPC == null && prereq.isCharacterRequired()) {
            return true;
        }
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        PrerequisiteTest test = factory.getTest(prereq.getKind());
        if (test == null) {
            Logging.errorPrintLocalised("PrereqHandler.Unable_to_find_implementation", prereq.toString());
            return false;
        }
        boolean overrideQualify = prereq.isOverrideQualify();
        boolean autoQualifies = false;
        int total = 0;
        if (caller instanceof CDOMObject && aPC != null && aPC.checkQualifyList((CDOMObject)caller) && !overrideQualify) {
            autoQualifies = true;
        }
        if (autoQualifies) {
            return true;
        }
        try {
            CDOMObject cdomCaller = caller instanceof CDOMObject ? (CDOMObject)caller : null;
            total = test.passes(prereq, aPC, cdomCaller);
        }
        catch (PrerequisiteException pe) {
            Logging.errorPrintLocalised("PrereqHandler.Exception_in_test", pe);
        }
        catch (Exception e) {
            String callerString = caller != null ? " for " + String.valueOf(caller) : "";
            Logging.errorPrint("Problem encountered when testing PREREQ " + String.valueOf(prereq) + callerString + ". See following trace for details.", e);
        }
        return total > 0;
    }

    public static boolean passes(Prerequisite preReq, Equipment equip, PlayerCharacter aPC) {
        if (equip == null) {
            return true;
        }
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        PrerequisiteTest test = factory.getTest(preReq.getKind());
        if (test == null) {
            String message = "PrereqHandler.Unable_to_find_implementation";
            Logging.errorPrintLocalised("PrereqHandler.Unable_to_find_implementation", preReq.toString());
            return false;
        }
        int total = 0;
        try {
            total = test.passes(preReq, equip, aPC);
        }
        catch (PrerequisiteException pe) {
            String message = "PrereqHandler.Exception_in_test";
            Logging.errorPrintLocalised("PrereqHandler.Exception_in_test", pe);
        }
        return total > 0;
    }

    public static String toHtmlString(Collection<Prerequisite> anArrayList) {
        if (anArrayList == null || anArrayList.isEmpty()) {
            return "";
        }
        PrerequisiteTestFactory factory = PrerequisiteTestFactory.getInstance();
        StringBuilder pString = new StringBuilder(anArrayList.size() * 20);
        String delimiter = "";
        for (Prerequisite preReq : anArrayList) {
            PrerequisiteTest preReqTest = factory.getTest(preReq.getKind());
            if (preReqTest == null) {
                String message = "PrereqHandler.No_known_formatter";
                Logging.errorPrintLocalised("PrereqHandler.No_known_formatter", preReq.getKind());
                continue;
            }
            pString.append(delimiter);
            pString.append(preReqTest.toHtmlString(preReq));
            String property = "PrereqHandler.HTML_prerequisite_delimiter";
            delimiter = LanguageBundle.getString("PrereqHandler.HTML_prerequisite_delimiter");
        }
        return pString.toString();
    }
}

