/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import pcgen.core.GameMode;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.core.npcgen.EquipmentTableParser;
import pcgen.system.ConfigurationSettings;
import pcgen.util.Logging;

public class TreasureGenerator {
    private static TreasureGenerator theInstance = new TreasureGenerator();
    private static HashMap<GameMode, List<EquipmentTable>> theTreasureTables = new HashMap();
    private static File tablesDir = new File(new File(ConfigurationSettings.getSystemsDir()) + File.separator + "npcgen" + File.separator + "treasure");

    private TreasureGenerator() {
    }

    public static TreasureGenerator getInstance() {
        return theInstance;
    }

    public List<EquipmentTable> getTables(GameMode aMode) {
        List<EquipmentTable> tables = theTreasureTables.get(aMode);
        if (tables == null) {
            try {
                EquipmentTableParser parser = new EquipmentTableParser(aMode);
                File[] fileNames = tablesDir.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File aDir, String aName) {
                        return aName.toLowerCase().endsWith(".xml");
                    }
                });
                tables = new ArrayList<EquipmentTable>();
                tables.addAll(parser.parse(fileNames));
                theTreasureTables.put(aMode, tables);
                return tables;
            }
            catch (Exception ex) {
                Logging.errorPrint("Error loading tables", ex);
            }
        }
        return tables;
    }

    public static void addTable(GameMode aMode, EquipmentTable aTable) {
        List<EquipmentTable> tables = theTreasureTables.get(aMode);
        if (tables == null) {
            tables = new ArrayList<EquipmentTable>();
            theTreasureTables.put(aMode, tables);
        }
        tables.add(aTable);
    }
}

