/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.ChooseDriver;
import pcgen.cdom.base.ChooseInformation;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.chooser.ChoiceManagerList;
import pcgen.core.chooser.ChooseController;

public class NoChoiceManager
implements ChoiceManagerList<String> {
    private final ChooseDriver owner;
    private final int choicesPerUnitCost;
    private ChooseController<String> controller = new ChooseController();
    private final ChooseInformation<String> info;
    private transient int preChooserChoices;

    public NoChoiceManager(ChooseDriver cdo, ChooseInformation<String> chooseType, int cost) {
        this.owner = cdo;
        this.info = chooseType;
        this.choicesPerUnitCost = cost;
    }

    @Override
    public void getChoices(PlayerCharacter pc, List<String> availableList, List<String> selectedList) {
        availableList.addAll(this.info.getSet(pc));
        selectedList.addAll(pc.getAssociationList(this.owner));
        this.preChooserChoices = selectedList.size();
    }

    @Override
    public String typeHandled() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean conditionallyApply(PlayerCharacter pc, String item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean applyChoices(PlayerCharacter pc, List<String> selected) {
        int i;
        List<String> oldSelections = this.info.getChoiceActor().getCurrentlySelected(this.owner, pc);
        int oldSelectionSize = oldSelections == null ? 0 : oldSelections.size();
        int newSelectionSize = selected.size();
        for (i = oldSelectionSize; i > newSelectionSize; --i) {
            this.info.getChoiceActor().removeChoice(pc, this.owner, "");
        }
        for (i = oldSelectionSize; i < newSelectionSize; ++i) {
            this.info.getChoiceActor().applyChoice(this.owner, "", pc);
        }
        this.adjustPool(selected);
        return oldSelectionSize != newSelectionSize;
    }

    @Override
    public List<String> doChooser(PlayerCharacter aPc, List<String> availableList, List<String> selectedList, List<String> reservedList) {
        selectedList.add("");
        return new ArrayList<String>(selectedList);
    }

    @Override
    public List<String> doChooserRemove(PlayerCharacter aPC, List<String> availableList, List<String> selectedList, List<String> reservedList) {
        selectedList.remove(0);
        return selectedList;
    }

    protected void adjustPool(List<String> selected) {
        this.controller.adjustPool(selected);
    }

    @Override
    public void setController(ChooseController<String> cc) {
        this.controller = cc;
    }

    @Override
    public int getChoicesPerUnitCost() {
        return this.choicesPerUnitCost;
    }

    @Override
    public int getPreChooserChoices() {
        return this.preChooserChoices;
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, ChooseDriver target, String choice) {
        this.info.restoreChoice(pc, target, this.info.decodeChoice(Globals.getContext(), choice));
    }

    @Override
    public int getNumEffectiveChoices(List<? extends String> selectedList, List<String> reservedList, PlayerCharacter aPc) {
        return 0;
    }

    @Override
    public void removeChoice(PlayerCharacter pc, ChooseDriver obj, String selection) {
        this.info.removeChoice(pc, obj, selection);
    }

    @Override
    public String decodeChoice(String choice) {
        return this.info.decodeChoice(Globals.getContext(), choice);
    }

    @Override
    public void applyChoice(PlayerCharacter pc, ChooseDriver cdo, String selection) {
        this.info.getChoiceActor().applyChoice(cdo, "", pc);
    }

    @Override
    public String encodeChoice(String obj) {
        return this.info.encodeChoice(obj);
    }
}

