/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet.analysis;

import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.EquipmentFacet;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;

public class TotalWeightFacet {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);
    private EquipmentFacet equipmentFacet;

    public Float getTotalWeight(CharID id) {
        float totalWeight = 0.0f;
        Float floatZero = Float.valueOf(0.0f);
        boolean firstClothing = !Globals.checkRule("CLOTHINGENCUMBRANCE");
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        for (Equipment eq : this.equipmentFacet.getSet(id)) {
            if (eq.getCarried().compareTo(floatZero) <= 0 || eq.getParent() != null) continue;
            if (eq.getChildCount() > 0) {
                totalWeight = (float)((double)totalWeight + (eq.getWeightAsDouble(pc) + (double)eq.getContainedWeight(pc).floatValue()));
                continue;
            }
            if (firstClothing && eq.isEquipped() && eq.isType("CLOTHING")) {
                firstClothing = false;
                totalWeight = (float)((double)totalWeight + eq.getWeightAsDouble(pc) * (double)Math.max(eq.getCarried().floatValue() - 1.0f, 0.0f));
                continue;
            }
            totalWeight = (float)((double)totalWeight + eq.getWeightAsDouble(pc) * (double)eq.getCarried().floatValue());
        }
        return Float.valueOf(totalWeight);
    }

    public void setEquipmentFacet(EquipmentFacet equipmentFacet) {
        this.equipmentFacet = equipmentFacet;
    }
}

