/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.facet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.FacetLibrary;
import pcgen.cdom.facet.PlayerCharacterTrackingFacet;
import pcgen.core.PlayerCharacter;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusPair;

public class BonusCheckingFacet {
    private final PlayerCharacterTrackingFacet trackingFacet = FacetLibrary.getFacet(PlayerCharacterTrackingFacet.class);

    public double getBonus(CharID id, String bonusType, String bonusName) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        return pc.getTotalBonusTo(bonusType, bonusName);
    }

    public double calcBonus(CharID id, Map<BonusObj, ? extends CDOMObject> map) {
        double iBonus = 0.0;
        for (Map.Entry<BonusObj, ? extends CDOMObject> me : map.entrySet()) {
            BonusObj bonus = me.getKey();
            CDOMObject source = me.getValue();
            iBonus += this.getBonusValue(id, bonus, source.getQualifiedKey()).doubleValue();
        }
        return iBonus;
    }

    private Number getBonusValue(CharID id, BonusObj bonus, String sourceIdentifier) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        return bonus.resolve(pc, sourceIdentifier);
    }

    public double getAllBonusValues(CharID id, Collection<BonusObj> bonuses, String sourceIdentifier) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        double value = 0.0;
        for (BonusObj bo : bonuses) {
            value += bo.resolve(pc, sourceIdentifier).doubleValue();
        }
        return value;
    }

    public Collection<String> getExpandedBonusInfo(CharID id, String bonusName) {
        PlayerCharacter pc = this.trackingFacet.getPC(id);
        ArrayList<String> list = new ArrayList<String>();
        for (BonusObj bonus : pc.getActiveBonusList()) {
            if (!bonus.getTypeOfBonus().equals(bonusName)) continue;
            String bonusInfo = bonus.getBonusInfo();
            if (bonusInfo.indexOf("%LIST") >= 0) {
                List<BonusPair> bpList = pc.getStringListFromBonus(bonus);
                for (BonusPair bonusPair : bpList) {
                    String key = bonusPair.fullyQualifiedBonusType;
                    if (key.startsWith(bonusName)) {
                        key = key.substring(bonusName.length() + 1);
                    }
                    list.add(key);
                }
                continue;
            }
            list.add(bonus.getBonusInfo());
        }
        return list;
    }
}

