/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMListObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.list.DomainSpellList;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.util.Logging;

public class SpellReferenceChoiceSet
implements PrimitiveChoiceSet<CDOMListObject<Spell>> {
    private final Set<CDOMReference<? extends CDOMListObject<Spell>>> set;

    public SpellReferenceChoiceSet(Collection<CDOMReference<? extends CDOMListObject<Spell>>> listRefCollection) {
        if (listRefCollection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (listRefCollection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new HashSet<CDOMReference<? extends CDOMListObject<Spell>>>(listRefCollection);
        if (this.set.size() != listRefCollection.size() && Logging.isLoggable(Level.WARNING)) {
            Logging.log(Level.WARNING, "Found duplicate item in " + listRefCollection);
        }
    }

    @Override
    public String getLSTformat(boolean useAny) {
        TreeSet sortedSet = new TreeSet(ReferenceUtilities.REFERENCE_SORTER);
        sortedSet.addAll(this.set);
        StringBuilder sb = new StringBuilder();
        ArrayList<CDOMReference> domainList = new ArrayList<CDOMReference>();
        boolean needComma = false;
        for (CDOMReference cDOMReference : sortedSet) {
            if (DomainSpellList.class.equals(cDOMReference.getReferenceClass())) {
                domainList.add(cDOMReference);
                continue;
            }
            if (needComma) {
                sb.append(",");
            }
            sb.append(cDOMReference.getLSTformat(false));
            needComma = true;
        }
        for (CDOMReference cDOMReference : domainList) {
            if (needComma) {
                sb.append(",");
            }
            sb.append("DOMAIN.");
            sb.append(cDOMReference.getLSTformat(false));
            needComma = true;
        }
        return sb.toString();
    }

    @Override
    public Class<CDOMListObject> getChoiceClass() {
        return CDOMListObject.class;
    }

    @Override
    public Set<CDOMListObject<Spell>> getSet(PlayerCharacter pc) {
        HashSet<CDOMListObject<Spell>> returnSet = new HashSet<CDOMListObject<Spell>>();
        for (CDOMReference<? extends CDOMListObject<Spell>> ref : this.set) {
            returnSet.addAll(ref.getContainedObjects());
        }
        return returnSet;
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpellReferenceChoiceSet) {
            SpellReferenceChoiceSet other = (SpellReferenceChoiceSet)obj;
            return this.set.equals(other.set);
        }
        return false;
    }

    @Override
    public GroupingState getGroupingState() {
        GroupingState state = GroupingState.EMPTY;
        for (CDOMReference<? extends CDOMListObject<Spell>> listref : this.set) {
            state = state.add(listref.getGroupingState());
        }
        return state;
    }
}

