/*
 * Decompiled with CFR 0.152.
 */
package gmgen.plugin;

import gmgen.plugin.Combatant;
import gmgen.plugin.PcgSystemInitiative;
import gmgen.plugin.PlayerCharacterOutput;
import gmgen.plugin.State;
import gmgen.plugin.SystemAttribute;
import gmgen.plugin.SystemHP;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jdom.Content;
import org.jdom.Element;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PCCheck;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.analysis.SkillModifier;
import pcgen.core.analysis.SkillRankControl;
import pcgen.core.character.CharacterSpell;
import pcgen.core.display.CharacterDisplay;
import pcgen.core.display.DescriptionFormatting;
import pcgen.core.display.SkillDisplay;
import pcgen.core.spell.Spell;
import pcgen.pluginmgr.PCGenMessageHandler;
import pcgen.pluginmgr.messages.RequestOpenPlayerCharacterMessage;
import pcgen.util.Logging;
import pcgen.util.enumeration.View;

public class PcgCombatant
extends Combatant {
    protected PlayerCharacter pc;
    private CharacterDisplay display;
    protected PcRenderer renderer;
    protected float crAdj = 0.0f;
    private final PCGenMessageHandler messageHandler;

    public PcgCombatant(PlayerCharacter pc, PCGenMessageHandler mh) {
        this.messageHandler = mh;
        this.pc = pc;
        this.display = pc.getDisplay();
        this.init = new PcgSystemInitiative(pc);
        PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "CON");
        this.hitPoints = new SystemHP(new SystemAttribute("Constitution", pc.getTotalStatFor(stat)), pc.hitPoints(), pc.hitPoints());
        this.setCombatantType("PC");
    }

    public PcgCombatant(PlayerCharacter pc, String type, PCGenMessageHandler mh) {
        this(pc, mh);
        this.setCombatantType(type);
    }

    public PcgCombatant(Element combatant, PCGenMessageHandler comp, PCGenMessageHandler mh) {
        this.messageHandler = mh;
        try {
            String pcgFilename = combatant.getChild("PCG").getAttribute("file").getValue();
            if (StringUtils.isNotBlank(pcgFilename)) {
                File pcgFile = new File(pcgFilename);
                RequestOpenPlayerCharacterMessage msg = new RequestOpenPlayerCharacterMessage(comp, pcgFile, true);
                this.messageHandler.handleMessage(msg);
                this.pc = msg.getPlayerCharacter();
            }
            if (this.pc == null) {
                this.pc = new PlayerCharacter();
                this.pc.setName(combatant.getAttributeValue("name"));
            }
            this.display = this.pc.getDisplay();
            this.init = new PcgSystemInitiative(this.pc);
            PCStat stat = Globals.getContext().getReferenceContext().silentlyGetConstructedCDOMObject(PCStat.class, "CON");
            this.hitPoints = new SystemHP(new SystemAttribute("Constitution", this.pc.getTotalStatFor(stat)), this.pc.hitPoints(), this.pc.hitPoints());
            this.setStatus(State.getState(combatant.getAttribute("status").getValue()));
            this.setCombatantType(combatant.getAttribute("type").getValue());
            this.init.setBonus(combatant.getChild("Initiative").getAttribute("bonus").getIntValue());
            try {
                this.init.setCurrentInitiative(combatant.getChild("Initiative").getAttribute("current").getIntValue());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.hitPoints.setMax(combatant.getChild("HitPoints").getAttribute("max").getIntValue());
            this.hitPoints.setCurrent(combatant.getChild("HitPoints").getAttribute("current").getIntValue());
            this.hitPoints.setSubdual(combatant.getChild("HitPoints").getAttribute("subdual").getIntValue());
            this.hitPoints.setState(State.getState(combatant.getChild("HitPoints").getAttribute("state").getValue()));
        }
        catch (Exception e) {
            Logging.errorPrint("Initiative", e);
        }
    }

    @Override
    public void setCR(float cr) {
        this.crAdj = cr - (float)this.pc.getDisplay().calcCR().intValue();
    }

    @Override
    public float getCR() {
        return (float)this.pc.getDisplay().calcCR().intValue() + this.crAdj;
    }

    @Override
    public void setName(String name) {
        this.pc.setName(name);
    }

    @Override
    public String getName() {
        return this.display.getName();
    }

    public PlayerCharacter getPC() {
        return this.pc;
    }

    public void setPlayer(String player) {
        this.pc.setPlayersName(player);
    }

    @Override
    public String getPlayer() {
        return this.display.getPlayersName();
    }

    @Override
    public Element getSaveElement() {
        Element retElement = new Element("PcgCombatant");
        Element initiative = new Element("Initiative");
        Element hp = new Element("HitPoints");
        Element pcg = new Element("PCG");
        pcg.setAttribute("file", this.pc.getFileName() + "");
        retElement.addContent((Content)pcg);
        initiative.setAttribute("bonus", this.init.getModifier() + "");
        if (this.init.getCurrentInitiative() > 0) {
            initiative.setAttribute("current", this.init.getCurrentInitiative() + "");
        }
        retElement.addContent((Content)initiative);
        hp.setAttribute("current", this.hitPoints.getCurrent() + "");
        hp.setAttribute("subdual", this.hitPoints.getSubdual() + "");
        hp.setAttribute("max", this.hitPoints.getMax() + "");
        hp.setAttribute("state", (Object)((Object)this.hitPoints.getState()) + "");
        retElement.addContent((Content)hp);
        retElement.setAttribute("name", this.getName());
        retElement.setAttribute("player", this.getPlayer());
        retElement.setAttribute("status", this.getStatus().name());
        retElement.setAttribute("type", this.getCombatantType());
        return retElement;
    }

    @Override
    public void setXP(int experience) {
        this.pc.setXP(experience);
    }

    @Override
    public int getXP() {
        return this.display.getXP();
    }

    @Override
    public void editRow(List<String> columnOrder, int colNumber, Object data) {
        String columnName = columnOrder.get(colNumber);
        String strData = String.valueOf(data);
        if (columnName.equals("Name")) {
            this.setName(strData);
        } else if (columnName.equals("Player")) {
            this.setPlayer(strData);
        } else if (columnName.equals("Status")) {
            this.setStatus(State.getStateLocalised(strData));
        } else if (columnName.equals("+")) {
            Integer intData = Integer.valueOf(strData);
            this.init.setBonus(intData);
        } else if (columnName.equals("Init")) {
            Integer intData = Integer.valueOf(strData);
            this.init.setCurrentInitiative(intData);
        } else if (columnName.equals("#")) {
            Integer intData = Integer.valueOf(strData);
            this.setNumber(intData);
        } else if (columnName.equals("HP")) {
            Integer intData = Integer.valueOf(strData);
            this.hitPoints.setCurrent(intData);
        } else if (columnName.equals("HP Max")) {
            Integer intData = Integer.valueOf(strData);
            this.hitPoints.setMax(intData);
        } else if (columnName.equals("Dur")) {
            Integer intData = Integer.valueOf(strData);
            this.setDuration(intData);
        } else if (columnName.equals("Type")) {
            this.setCombatantType(strData);
        }
    }

    @Override
    public String toHtmlString() {
        if (this.renderer == null) {
            this.renderer = new PcRenderer();
        }
        return this.renderer.getHtmlText();
    }

    protected class PcRenderer {
        protected String htmlString;
        protected int serial = 0;

        public String getHtmlText() {
            if (this.serial < PcgCombatant.this.pc.getSerial() || this.htmlString == null) {
                StringBuilder statBuf = new StringBuilder();
                statBuf.append("<html>");
                statBuf.append(this.getStatBlockHeader());
                statBuf.append("<body class='Normal' lang='EN-US'>");
                statBuf.append(this.getStatBlockTitle());
                statBuf.append(this.getStatBlockCore());
                statBuf.append("<DIV style='MARGIN: 0px 10px'>");
                statBuf.append(this.getStatBlockLineSkills());
                statBuf.append(this.getStatBlockLinePossessions());
                try {
                    statBuf.append(this.getStatBlockLineSpells());
                }
                catch (Exception e) {
                    Logging.errorPrint(e.getMessage(), e);
                }
                statBuf.append("</DIV>");
                statBuf.append("<br>");
                statBuf.append("</html>");
                this.serial = PcgCombatant.this.pc.getSerial();
                this.htmlString = statBuf.toString();
            }
            return this.htmlString;
        }

        protected String getStatBlockCore() {
            StringBuilder statBuf = new StringBuilder();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<font class='type'>CR</font> ");
            statBuf.append(pcOut.getCR());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Size</font> ");
            statBuf.append(pcOut.getSize());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Type</font> ");
            statBuf.append(pcOut.getRaceType());
            statBuf.append("; ");
            statBuf.append("<font class='type'>HD</font> ");
            statBuf.append(pcOut.getHitDice());
            statBuf.append("; ");
            statBuf.append("<font class='type'>hp</font> ");
            statBuf.append(pcOut.getHitPoints());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Init</font> <font class='highlight'>");
            statBuf.append(pcOut.getInitTotal());
            statBuf.append("</font> (");
            statBuf.append(pcOut.getInitStatMod());
            statBuf.append(" Dex, ");
            statBuf.append(pcOut.getInitMiscMod());
            statBuf.append(" Misc); ");
            statBuf.append("<font class='type'>Spd</font> ");
            statBuf.append(pcOut.getSpeed());
            statBuf.append(";<br>");
            statBuf.append("<font class='type'>AC</font> <font class='highlight'>");
            statBuf.append(pcOut.getAC());
            statBuf.append("</font> (flatfooted <font class='highlight'>");
            statBuf.append(pcOut.getACFlatFooted());
            statBuf.append("</font>, touch <font class='highlight'>");
            statBuf.append(pcOut.getACTouch());
            statBuf.append("</font>);<br>");
            statBuf.append("<font class='type'>Melee:</font> <a href='attack:Melee\\");
            statBuf.append(pcOut.getMeleeTotal());
            statBuf.append("' class='highlight'>");
            statBuf.append(pcOut.getMeleeTotal());
            statBuf.append("</a>; ");
            statBuf.append("<font class='type'>Ranged:</font> <a href='attack:Ranged\\");
            statBuf.append(pcOut.getRangedTotal());
            statBuf.append("' class='highlight'>");
            statBuf.append(pcOut.getRangedTotal());
            statBuf.append("</a>; ");
            statBuf.append("<font class='type'>Weapons:</font>");
            List<Equipment> weaponList = PcgCombatant.this.pc.getExpandedWeapons(0);
            for (int i = 0; i < weaponList.size(); ++i) {
                Equipment eq = weaponList.get(i);
                statBuf.append("<a href=\"attack:");
                statBuf.append(pcOut.getWeaponName(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponToHit(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponRange(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponType(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponDamage(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponCritRange(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponCritMult(i));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponHand(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponSize(eq));
                statBuf.append("\\");
                statBuf.append(pcOut.getWeaponSpecialProperties(eq));
                statBuf.append("\" class=\"dialog\"> ");
                statBuf.append(pcOut.getWeaponName(eq));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponToHit(i));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponRange(eq));
                statBuf.append("/");
                statBuf.append(pcOut.getWeaponType(eq));
                statBuf.append(" (");
                statBuf.append(pcOut.getWeaponDamage(i));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponCritRange(i));
                statBuf.append("/x");
                statBuf.append(pcOut.getWeaponCritMult(i));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponHand(eq));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponSize(eq));
                statBuf.append(" ");
                statBuf.append(pcOut.getWeaponSpecialProperties(eq));
                statBuf.append(") </a> or ");
            }
            statBuf.append("<a href=\"attack:Unarmed\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.TOTALHIT"));
            statBuf.append("\\\\B\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append("\" class=\"dialog\"> ");
            statBuf.append("Unarmed ");
            statBuf.append(pcOut.getExportToken("WEAPONH.TOTALHIT"));
            statBuf.append(" (");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append(" ");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("/x");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append(") </a> or ");
            statBuf.append("<a href=\"attack:Grapple\\");
            statBuf.append(pcOut.getExportToken("ATTACK.GRAPPLE.TOTAL"));
            statBuf.append("\\\\B\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("\\");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append("\" class=\"dialog\"> ");
            statBuf.append("Grapple ");
            statBuf.append(pcOut.getExportToken("ATTACK.GRAPPLE.TOTAL"));
            statBuf.append(" (");
            statBuf.append(pcOut.getExportToken("WEAPONH.DAMAGE"));
            statBuf.append(" ");
            statBuf.append(pcOut.getExportToken("WEAPONH.CRIT"));
            statBuf.append("/x");
            statBuf.append(pcOut.getExportToken("WEAPONH.MULT"));
            statBuf.append(")</a>;<br>");
            statBuf.append("<font class='type'>SA:</font> ");
            statBuf.append(pcOut.getSpecialAbilities());
            int turnTimes = PcgCombatant.this.pc.getVariableValue("TurnTimesUndead", "").intValue();
            if (turnTimes > 0) {
                int turnDieNumber = PcgCombatant.this.pc.getVariableValue("TurnDiceUndead", "").intValue();
                int turnDieSize = PcgCombatant.this.pc.getVariableValue("TurnDieSizeUndead", "").intValue();
                int turnDamage = PcgCombatant.this.pc.getVariableValue("TurnDamagePlusUndead", "").intValue();
                int turnLevel = PcgCombatant.this.pc.getVariableValue("TurnLevelUndead", "").intValue();
                int turnCheck = PcgCombatant.this.pc.getVariableValue("TurnCheckUndead", "").intValue();
                statBuf.append("; <font class='type'>Turn/Rebuke Undead:</font> Turning level <a href=\"dice:Turn Undead (Max HD Affected)\\max(min(max((ceil((1d20" + (turnCheck > 0 ? "+" : "") + turnCheck + ")/3)-4),-4),4)+" + turnLevel + ",0)" + '\"' + " class=" + '\"' + "dialog" + '\"' + "> " + turnLevel + "</a>, Turn Damage: " + "<a href=" + '\"' + "dice:Turn Damage (Total HD Affected)\\" + "max(" + turnDieNumber + "d" + turnDieSize + (turnDamage > 0 ? "+" : "") + turnDamage + ",0)" + '\"' + " class=" + '\"' + "dialog" + '\"' + "> " + turnDieNumber + "d" + turnDieSize + (turnDamage > 0 ? "+" : "") + turnDamage + "</a>, " + turnTimes + "/day");
            }
            statBuf.append("; ");
            statBuf.append("<font class='type'>Vision:</font> ");
            statBuf.append(pcOut.getVision());
            statBuf.append(" ");
            statBuf.append("<font class='type'>AL:</font> ");
            statBuf.append(pcOut.getAlignmentShort());
            statBuf.append("; ");
            statBuf.append("<font class='type'>Sv:</font> ");
            boolean firstChk = true;
            for (PCCheck chk : Globals.getContext().getReferenceContext().getOrderSortedCDOMObjects(PCCheck.class)) {
                if (!firstChk) {
                    statBuf.append(", ");
                }
                firstChk = false;
                statBuf.append(chk.getDisplayName());
                statBuf.append(" <font class='highlight'>");
                statBuf.append("<a href='save:").append(chk.getDisplayName()).append("\\");
                statBuf.append(PcgCombatant.this.pc.calculateSaveBonus(chk, "TOTAL"));
                statBuf.append("' class='highlight'> ");
                statBuf.append(PcgCombatant.this.pc.calculateSaveBonus(chk, "TOTAL"));
                statBuf.append("</a></font>");
            }
            statBuf.append(";<br>");
            for (PCStat stat : pcOut.getUnmodifiableStatList()) {
                String statAbb = stat.getKeyName();
                if (PcgCombatant.this.display.isNonAbility(stat)) {
                    statBuf.append("<font class='type'>");
                    statBuf.append(statAbb);
                    statBuf.append("</font>");
                    statBuf.append("*");
                    statBuf.append("&nbsp;(");
                    statBuf.append("0");
                    statBuf.append(") ");
                    continue;
                }
                statBuf.append("<font class='type'>");
                statBuf.append(statAbb);
                statBuf.append("</font> ");
                statBuf.append(pcOut.getStat(stat));
                statBuf.append("&nbsp;(");
                statBuf.append("<a href='check:");
                statBuf.append(statAbb);
                statBuf.append("\\1d20");
                statBuf.append(pcOut.getStatMod(stat));
                statBuf.append("' class='dialog'>");
                statBuf.append(pcOut.getStatMod(stat));
                statBuf.append("</a>) ");
            }
            statBuf.append("</p>");
            return statBuf.toString();
        }

        protected String getStatBlockHeader() {
            StringBuilder statBuf = new StringBuilder();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<head><title>");
            statBuf.append(pcOut.getName());
            statBuf.append(" - ");
            statBuf.append(PcgCombatant.this.display.getPlayersName());
            statBuf.append("(");
            statBuf.append(PcgCombatant.this.pc.getCostPool());
            statBuf.append(" Points) in GMGEN Statblock Format");
            statBuf.append("</title>");
            statBuf.append("<style type='text/css'>");
            statBuf.append("a:link {color: #006699}");
            statBuf.append("a:visited {color: #006699}");
            statBuf.append("a:hover {color: #006699}");
            statBuf.append("a:active {color: #006699}");
            statBuf.append(".type {color:#555555;font-weight:bold}");
            statBuf.append(".highlight {color:#FF0000}");
            statBuf.append(".dialog {color:#006699}");
            statBuf.append("</style></head>");
            return statBuf.toString();
        }

        protected String getStatBlockLinePossessions() {
            StringBuilder statBuf = new StringBuilder();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<p><font class='type'>Possessions:</font>&nbsp;");
            statBuf.append(pcOut.getEquipmentList());
            statBuf.append("</p>");
            return statBuf.toString();
        }

        protected String getStatBlockLineSkills() {
            StringBuilder statBuf = new StringBuilder();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<p><font class='type'>Skills and Feats:</font>&nbsp;");
            List<Skill> skillList = SkillDisplay.getSkillListInOutputOrder(PcgCombatant.this.pc, PcgCombatant.this.display.getPartialSkillList(View.VISIBLE_EXPORT));
            boolean firstLine = true;
            for (Skill skill : skillList) {
                if (!firstLine) {
                    statBuf.append(", ");
                }
                firstLine = false;
                CDOMSingleRef<PCStat> keyStat = skill.get(ObjectKey.KEY_STAT);
                if (keyStat != null) {
                    int modSkill = SkillModifier.modifier(skill, PcgCombatant.this.pc) - PcgCombatant.this.pc.getStatModFor(keyStat.resolvesTo());
                    Logging.debugPrint("modSkill: " + modSkill);
                }
                int temp = SkillModifier.modifier(skill, PcgCombatant.this.pc) + SkillRankControl.getTotalRank(PcgCombatant.this.pc, skill).intValue();
                statBuf.append("<a href='skill:");
                statBuf.append(skill.getOutputName());
                statBuf.append("\\1d20");
                statBuf.append(temp < 0 ? Integer.toString(temp) : "+" + temp);
                statBuf.append("' class='dialog'> ");
                statBuf.append(skill.getOutputName());
                statBuf.append(" (");
                statBuf.append(temp);
                statBuf.append(")</a>");
            }
            statBuf.append("; ");
            statBuf.append(pcOut.getFeatList());
            statBuf.append("</p>");
            return statBuf.toString();
        }

        protected String getStatBlockLineSpells() {
            StringBuilder statBuf = new StringBuilder();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            if (PcgCombatant.this.display.hasDomains()) {
                statBuf.append("<p>");
                statBuf.append("<font class='type'>Deity:</font>");
                statBuf.append(pcOut.getDeity());
                statBuf.append("<br>");
                statBuf.append("<font class='type'>Domains:</font>&nbsp;");
                boolean firstLine = true;
                for (Domain dom : PcgCombatant.this.display.getSortedDomainSet()) {
                    if (!firstLine) {
                        statBuf.append(", ");
                    }
                    firstLine = false;
                    statBuf.append(pcOut.getDomainName(dom));
                    statBuf.append(" (");
                    statBuf.append(DescriptionFormatting.piWrapDesc(dom, PcgCombatant.this.pc.getDescription(dom), true));
                    statBuf.append(")");
                }
                statBuf.append("</p>");
            }
            statBuf.append("<p>");
            ArrayList<PObject> classList = new ArrayList<PObject>(PcgCombatant.this.display.getClassSet());
            classList.add((PCClass)((Object)PcgCombatant.this.display.getRace()));
            HashSet<String> bookList = new HashSet<String>(PcgCombatant.this.pc.getDisplay().getSpellBookNames());
            bookList.add(Globals.getDefaultSpellBook());
            for (String book : bookList) {
                this.statBlockLineSpellBook(PcgCombatant.this.pc, statBuf, classList, book);
            }
            return statBuf.toString();
        }

        protected void statBlockLineSpellBook(PlayerCharacter aPC, StringBuilder statBuf, ArrayList<PObject> classList, String spellBookName) {
            HashSet<PObject> classes = new HashSet<PObject>();
            classes.addAll(classList);
            for (PObject pObj : classes) {
                if (pObj == null) continue;
                int maxLevel = 100;
                if (pObj instanceof PCClass) {
                    PCClass theClass = (PCClass)pObj;
                    maxLevel = aPC.getDisplay().getLevel(theClass) == 0 ? maxLevel : aPC.getSpellSupport(theClass).getMaxCastLevel(aPC);
                }
                StringBuilder spellBuff = new StringBuilder();
                for (int level = 0; level <= maxLevel; ++level) {
                    List<CharacterSpell> spellList = aPC.getCharacterSpells(pObj, null, spellBookName, level);
                    if (spellList.size() < 1) continue;
                    spellBuff.append("<font class='type'>Level " + level + ":</font> ");
                    boolean firstLine = true;
                    for (CharacterSpell cs : spellList) {
                        if (!firstLine) {
                            spellBuff.append(", ");
                        }
                        firstLine = false;
                        Spell spell = cs.getSpell();
                        spellBuff.append("<a href=\"spell:");
                        spellBuff.append(spell.getDisplayName());
                        spellBuff.append("\\");
                        spellBuff.append(aPC.parseSpellString(cs, aPC.getDescription(spell)));
                        spellBuff.append("\\");
                        spellBuff.append((CharSequence)StringUtil.joinToStringBuilder(spell.getListFor(ListKey.RANGE), (String)", "));
                        spellBuff.append("\\");
                        spellBuff.append(spell.getListAsString(ListKey.CASTTIME));
                        spellBuff.append("\\");
                        spellBuff.append((CharSequence)StringUtil.joinToStringBuilder(spell.getListFor(ListKey.SAVE_INFO), (String)", "));
                        spellBuff.append("\\");
                        spellBuff.append(aPC.parseSpellString(cs, spell.getListAsString(ListKey.DURATION)));
                        spellBuff.append("\\");
                        spellBuff.append(aPC.parseSpellString(cs, spell.getSafe(StringKey.TARGET_AREA)));
                        spellBuff.append("\" class=\"dialog\">");
                        spellBuff.append(spell.getDisplayName());
                        spellBuff.append("</a>");
                    }
                    spellBuff.append("<br>");
                }
                if (spellBuff.length() <= 0) continue;
                statBuf.append("<br><font class='type'>" + spellBookName + ":</font><br> ");
                statBuf.append("<font class='type'>" + pObj.getDisplayName() + ":</font><br> ");
                statBuf.append((CharSequence)spellBuff);
            }
        }

        protected String getStatBlockTitle() {
            StringBuilder statBuf = new StringBuilder();
            PlayerCharacterOutput pcOut = new PlayerCharacterOutput(PcgCombatant.this.pc);
            statBuf.append("<p class='gork'><font size='+1'><b>");
            statBuf.append(pcOut.getName());
            statBuf.append(", ");
            statBuf.append(pcOut.getGender());
            statBuf.append(" ");
            statBuf.append(pcOut.getRaceName());
            statBuf.append(" ");
            String region = pcOut.getRegion();
            if (!"".equals(region) && region != null && !"None".equals(region)) {
                statBuf.append(" From " + region + " ");
            }
            statBuf.append(pcOut.getClasses() + " ");
            statBuf.append("</b></font></p>");
            return statBuf.toString();
        }
    }
}

