/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit;

import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PCAlignment;
import pcgen.core.kit.KitAlignment;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class AlignToken
extends AbstractTokenWithSeparator<KitAlignment>
implements CDOMPrimaryToken<KitAlignment> {
    private static final Class<PCAlignment> ALIGNMENT_CLASS = PCAlignment.class;

    public String getTokenName() {
        return "ALIGN";
    }

    public Class<KitAlignment> getTokenClass() {
        return KitAlignment.class;
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, KitAlignment kitAlignment, String value) {
        StringTokenizer tok = new StringTokenizer(value, "|");
        while (tok.hasMoreTokens()) {
            String tokText = tok.nextToken();
            CDOMSingleRef ref = context.getReferenceContext().getCDOMReference(ALIGNMENT_CLASS, tokText);
            kitAlignment.addAlignment(ref);
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, KitAlignment kitAlignment) {
        List alignments = kitAlignment.getAlignments();
        if (alignments == null) {
            return null;
        }
        return new String[]{ReferenceUtilities.joinLstFormat((Collection)alignments, (String)"|")};
    }
}

