/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.skill;

import java.util.ArrayList;
import java.util.StringTokenizer;
import pcgen.base.util.ObjectContainer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.list.ClassSkillList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.FilteredReference;
import pcgen.core.Skill;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class ClassesToken
extends AbstractTokenWithSeparator<Skill>
implements CDOMPrimaryToken<Skill> {
    private static final Class<ClassSkillList> SKILLLIST_CLASS = ClassSkillList.class;

    public String getTokenName() {
        return "CLASSES";
    }

    protected char separator() {
        return '|';
    }

    protected ParseResult parseTokenWithSeparator(LoadContext context, Skill skill, String value) {
        StringTokenizer pipeTok = new StringTokenizer(value, "|");
        boolean added = false;
        ArrayList<CDOMSingleRef> allow = new ArrayList<CDOMSingleRef>();
        while (pipeTok.hasMoreTokens()) {
            String className = pipeTok.nextToken();
            if ("ALL".equals(className)) {
                if (!added) break;
                return new ParseResult.Fail("Non-sensical Skill " + this.getTokenName() + ": Contains ALL after a specific reference: " + value, context);
            }
            if (className.startsWith("!")) {
                return new ParseResult.Fail("Non-sensical Skill " + this.getTokenName() + ": Contains ! without (or before) ALL: " + value, context);
            }
            allow.add(context.getReferenceContext().getCDOMReference(SKILLLIST_CLASS, className));
            added = true;
        }
        if (pipeTok.hasMoreTokens()) {
            FilteredReference filtered = new FilteredReference(SKILLLIST_CLASS, (ObjectContainer)context.getReferenceContext().getCDOMAllReference(SKILLLIST_CLASS));
            while (pipeTok.hasMoreTokens()) {
                String string = pipeTok.nextToken();
                if (string.startsWith("!")) {
                    String clString = string.substring(1);
                    if ("ALL".equals(clString) || "ANY".equals(clString)) {
                        return new ParseResult.Fail("Invalid " + this.getTokenName() + " cannot use !ALL", context);
                    }
                    CDOMSingleRef ref = context.getReferenceContext().getCDOMReference(SKILLLIST_CLASS, clString);
                    filtered.addProhibitedItem(ref);
                    continue;
                }
                return new ParseResult.Fail("Non-sensical Skill " + this.getTokenName() + ": Contains ALL and a specific reference: " + value, context);
            }
            context.getListContext().addToMasterList(this.getTokenName(), (CDOMObject)skill, (CDOMReference)filtered, (CDOMObject)skill);
        } else if (allow.isEmpty()) {
            context.getListContext().addToMasterList(this.getTokenName(), (CDOMObject)skill, (CDOMReference)context.getReferenceContext().getCDOMAllReference(SKILLLIST_CLASS), (CDOMObject)skill);
        } else {
            for (CDOMReference cDOMReference : allow) {
                context.getListContext().addToMasterList(this.getTokenName(), (CDOMObject)skill, cDOMReference, (CDOMObject)skill);
            }
        }
        return ParseResult.SUCCESS;
    }

    public String[] unparse(LoadContext context, Skill skill) {
        Changes masterChanges = context.getListContext().getMasterListChanges(this.getTokenName(), (CDOMObject)skill, SKILLLIST_CLASS);
        if (masterChanges.includesGlobalClear()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR");
            return null;
        }
        if (masterChanges.hasRemovedItems()) {
            context.addWriteMessage(this.getTokenName() + " does not support .CLEAR.");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!masterChanges.hasAddedItems()) {
            return null;
        }
        boolean needBar = false;
        for (CDOMReference ref : masterChanges.getAdded()) {
            if (needBar) {
                sb.append("|");
            }
            sb.append(ref.getLSTformat(false));
            needBar = true;
        }
        return new String[]{sb.toString()};
    }

    public Class<Skill> getTokenClass() {
        return Skill.class;
    }
}

