/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.extension.builtin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.spockframework.runtime.GroovyRuntimeUtil;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.NameProvider;

public class UnrollNameProvider
implements NameProvider<IterationInfo> {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("#([a-zA-Z_\\$]([\\w\\$\\.]|\\(\\))*)");
    private final FeatureInfo feature;
    private final Matcher expressionMatcher;
    private int iterationCount;

    public UnrollNameProvider(FeatureInfo feature, String namePattern) {
        this.feature = feature;
        this.expressionMatcher = EXPRESSION_PATTERN.matcher(namePattern);
    }

    @Override
    public String getName(IterationInfo iterationInfo) {
        return this.nameFor(iterationInfo.getDataValues());
    }

    String nameFor(Object ... dataValues) {
        StringBuffer result = new StringBuffer();
        this.expressionMatcher.reset();
        while (this.expressionMatcher.find()) {
            String expr = this.expressionMatcher.group(1);
            String value = this.evaluateExpression(expr, dataValues);
            this.expressionMatcher.appendReplacement(result, Matcher.quoteReplacement(value));
        }
        this.expressionMatcher.appendTail(result);
        ++this.iterationCount;
        return result.toString();
    }

    private String evaluateExpression(String expr, Object[] dataValues) {
        Object result;
        String[] exprParts = expr.split("\\.");
        String firstPart = exprParts[0];
        if (firstPart.equals("featureName")) {
            result = this.feature.getName();
        } else if (firstPart.equals("iterationCount")) {
            result = String.valueOf(this.iterationCount);
        } else {
            int index = this.feature.getDataVariables().indexOf(firstPart);
            if (index < 0) {
                return "#Error:" + expr;
            }
            result = dataValues[index];
        }
        try {
            for (int i = 1; i < exprParts.length; ++i) {
                String currPart = exprParts[i];
                result = currPart.endsWith("()") ? GroovyRuntimeUtil.invokeMethod(result, currPart.substring(0, currPart.length() - 2), new Object[0]) : GroovyRuntimeUtil.getProperty(result, currPart);
            }
            return GroovyRuntimeUtil.toString(result);
        }
        catch (Exception e) {
            return "#Error:" + expr;
        }
    }
}

