/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime.condition;

import java.util.LinkedList;
import java.util.List;
import org.spockframework.runtime.condition.EditOperation;

public class EditDistance {
    private final CharSequence seq1;
    private final CharSequence seq2;
    private final int[][] matrix;

    public EditDistance(CharSequence seq1, CharSequence seq2) {
        this.seq1 = seq1;
        this.seq2 = seq2;
        this.matrix = new int[seq1.length() + 1][];
        this.calculateMatrix();
    }

    private void calculateMatrix() {
        for (int i = 0; i < this.seq1.length() + 1; ++i) {
            this.matrix[i] = new int[this.seq2.length() + 1];
            for (int j = 0; j < this.seq2.length() + 1; ++j) {
                this.matrix[i][j] = i == 0 ? j : (j == 0 ? i : EditDistance.min(this.matrix[i][j - 1] + 1, this.matrix[i - 1][j] + 1, this.matrix[i - 1][j - 1] + (this.seq1.charAt(i - 1) == this.seq2.charAt(j - 1) ? 0 : 1)));
            }
        }
    }

    public int[][] getMatrix() {
        return this.matrix;
    }

    public int getDistance() {
        return this.matrix[this.seq1.length()][this.seq2.length()];
    }

    public int getSimilarityInPercent() {
        int maxDistance = Math.max(this.seq1.length(), this.seq2.length());
        return (maxDistance - this.getDistance()) * 100 / maxDistance;
    }

    public List<EditOperation> calculatePath() {
        LinkedList<EditOperation> ops = new LinkedList<EditOperation>();
        int i = this.seq1.length();
        int j = this.seq2.length();
        int dist = this.matrix[i][j];
        while (i > 0 && j > 0 && dist > 0) {
            int ins = this.matrix[i][j - 1];
            int del = this.matrix[i - 1][j];
            int sub = this.matrix[i - 1][j - 1];
            if (dist == ins + 1) {
                this.addOrUpdate(ops, EditOperation.Kind.INSERT, 1);
                --j;
            } else if (dist == del + 1) {
                this.addOrUpdate(ops, EditOperation.Kind.DELETE, 1);
                --i;
            } else {
                if (dist == sub) {
                    this.addOrUpdate(ops, EditOperation.Kind.SKIP, 1);
                } else {
                    this.addOrUpdate(ops, EditOperation.Kind.SUBSTITUTE, 1);
                }
                --i;
                --j;
            }
            dist = this.matrix[i][j];
        }
        if (i == 0) {
            this.addOrUpdate(ops, EditOperation.Kind.INSERT, j);
        } else if (j == 0) {
            this.addOrUpdate(ops, EditOperation.Kind.DELETE, i);
        } else {
            this.addOrUpdate(ops, EditOperation.Kind.SKIP, i);
        }
        return ops;
    }

    private void addOrUpdate(LinkedList<EditOperation> ops, EditOperation.Kind kind, int length) {
        if (length == 0) {
            return;
        }
        if (!ops.isEmpty() && ops.getFirst().getKind() == kind) {
            ops.getFirst().incLength(length);
        } else {
            ops.addFirst(new EditOperation(kind, length));
        }
    }

    private static int min(int a, int b, int c) {
        return Math.min(a, Math.min(b, c));
    }
}

