/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.fix.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import jrm.compressors.SevenZipArchive;
import jrm.compressors.ZipArchive;
import jrm.compressors.zipfs.ZipFileSystemProvider;
import jrm.compressors.zipfs.ZipLevel;
import jrm.compressors.zipfs.ZipTempThreshold;
import jrm.locale.Messages;
import jrm.misc.Settings;
import jrm.profile.data.Container;
import jrm.profile.fix.actions.ContainerAction;
import jrm.profile.fix.actions.EntryAction;
import jrm.profile.scan.options.FormatOptions;
import jrm.ui.progress.ProgressHandler;
import org.apache.commons.text.StringEscapeUtils;

public class OpenContainer
extends ContainerAction {
    private final long dataSize;

    public OpenContainer(Container container, FormatOptions format, long dataSize) {
        super(container, format);
        this.dataSize = dataSize;
    }

    public static OpenContainer getInstance(OpenContainer action, Container container, FormatOptions format, long dataSize) {
        if (action == null) {
            action = new OpenContainer(container, format, dataSize);
        }
        return action;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean doAction(ProgressHandler handler) {
        EntryAction action;
        handler.setProgress(this.toHTML(this.toNoBR(String.format(StringEscapeUtils.escapeHtml4((String)Messages.getString("OpenContainer.Fixing")), this.toBlue(this.container.m.getFullName(this.container.file.getName())), this.toPurple(this.container.m.getDescription())))));
        if (this.container.getType() == Container.Type.ZIP) {
            if (this.format == FormatOptions.ZIP || this.format == FormatOptions.TZIP) {
                HashMap<String, Comparable<Boolean>> env = new HashMap<String, Comparable<Boolean>>();
                env.put("useTempFile", Boolean.valueOf(this.dataSize > ZipTempThreshold.valueOf(Settings.getProperty("zip_temp_threshold", ZipTempThreshold._10MB.toString())).getThreshold()));
                env.put("compressionLevel", Integer.valueOf(this.format == FormatOptions.TZIP ? 1 : ZipLevel.valueOf(Settings.getProperty("zip_compression_level", ZipLevel.DEFAULT.toString())).getLevel()));
                try (FileSystem fs = new ZipFileSystemProvider().newFileSystem(URI.create("zip:" + this.container.file.toURI()), env);){
                    int i2 = 0;
                    for (EntryAction action2 : this.entry_actions) {
                        if (action2.doAction(fs, handler, ++i2, this.entry_actions.size())) continue;
                        System.err.println("action to " + this.container.file.getName() + "@" + action2.entry.file + " failed");
                        boolean bl = false;
                        return bl;
                    }
                    this.deleteEmptyFolders(fs.getPath("/", new String[0]));
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    return false;
                }
            }
            if (this.format != FormatOptions.ZIPE) return false;
            try (ZipArchive archive = new ZipArchive(this.container.file);){
                int i = 0;
                for (EntryAction action3 : this.entry_actions) {
                    if (action3.doAction(archive, handler, ++i, this.entry_actions.size())) continue;
                    System.err.println("action to " + this.container.file.getName() + "@" + action3.entry.file + " failed");
                    boolean bl = false;
                    return bl;
                }
                boolean i2 = true;
                return i2;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.container.getType() == Container.Type.SEVENZIP) {
            try (SevenZipArchive archive = new SevenZipArchive(this.container.file);){
                int i = 0;
                for (EntryAction action4 : this.entry_actions) {
                    if (action4.doAction(archive, handler, ++i, this.entry_actions.size())) continue;
                    System.err.println("action to " + this.container.file.getName() + "@" + action4.entry.file + " failed");
                    boolean bl = false;
                    return bl;
                }
                boolean i2 = true;
                return i2;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return false;
            }
        }
        if (this.container.getType() != Container.Type.DIR) return false;
        Path target = this.container.file.toPath();
        int i = 0;
        Iterator iterator = this.entry_actions.iterator();
        do {
            if (iterator.hasNext()) continue;
            this.deleteEmptyFolders(this.container.file);
            return true;
        } while ((action = (EntryAction)iterator.next()).doAction(target, handler, ++i, this.entry_actions.size()));
        System.err.println("action to " + this.container.file.getName() + "@" + action.entry.file + " failed");
        return false;
    }

    public long deleteEmptyFolders(File baseFolder) {
        long totalSize = 0L;
        for (File folder : baseFolder.listFiles()) {
            if (folder.isDirectory()) {
                totalSize += this.deleteEmptyFolders(folder);
                continue;
            }
            totalSize += folder.length();
        }
        if (totalSize == 0L) {
            baseFolder.delete();
        }
        return totalSize;
    }

    public long deleteEmptyFolders(Path baseFolder) {
        long totalSize = 0L;
        try {
            for (Path folder : Files.list(baseFolder).collect(Collectors.toList())) {
                if (Files.isDirectory(folder, new LinkOption[0])) {
                    totalSize += this.deleteEmptyFolders(folder);
                    continue;
                }
                totalSize += Files.size(folder);
            }
            if (totalSize == 0L) {
                Files.delete(baseFolder);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return totalSize;
    }

    public String toString() {
        String str = Messages.getString("OpenContainer.Open") + this.container;
        for (EntryAction action : this.entry_actions) {
            str = str + "\n\t" + action;
        }
        return str;
    }
}

