/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.truth.J2ktIncompatible;
import com.google.common.truth.Platform;
import com.google.common.truth.StandardSubjectBuilder;
import com.google.common.truth.Subject;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@GwtIncompatible
@J2ktIncompatible
final class StackTraceCleaner {
    static final String CLEANER_LINK = "https://goo.gl/aH3UyP";
    private final Throwable throwable;
    private final List<StackTraceElementWrapper> cleanedStackTrace = new ArrayList<StackTraceElementWrapper>();
    private @Nullable StackTraceElementWrapper lastStackFrameElementWrapper = null;
    private @Nullable StackFrameType currentStreakType = null;
    private int currentStreakLength = 0;
    private static final ImmutableSet<String> SUBJECT_CLASS = ImmutableSet.of((Object)Subject.class.getCanonicalName());
    private static final ImmutableSet<String> STANDARD_SUBJECT_BUILDER_CLASS = ImmutableSet.of((Object)StandardSubjectBuilder.class.getCanonicalName());
    private static final ImmutableSet<String> JUNIT_INFRASTRUCTURE_CLASSES = ImmutableSet.of((Object)"org.junit.runner.Runner", (Object)"org.junit.runners.model.Statement");

    static void cleanStackTrace(Throwable throwable) {
        new StackTraceCleaner(throwable).clean(Sets.newIdentityHashSet());
    }

    private StackTraceCleaner(Throwable throwable) {
        this.throwable = throwable;
    }

    private void clean(Set<Throwable> seenThrowables) {
        StackTraceElementWrapper stackTraceElementWrapper;
        int endIndex;
        int stackIndex;
        if (StackTraceCleaner.isStackTraceCleaningDisabled()) {
            return;
        }
        if (seenThrowables.contains(this.throwable)) {
            return;
        }
        seenThrowables.add(this.throwable);
        StackTraceElement[] stackFrames = this.throwable.getStackTrace();
        for (stackIndex = stackFrames.length - 1; stackIndex >= 0 && !StackTraceCleaner.isTruthEntrance(stackFrames[stackIndex]); --stackIndex) {
        }
        ++stackIndex;
        for (endIndex = 0; endIndex < stackFrames.length && !StackTraceCleaner.isJUnitIntrastructure(stackFrames[endIndex]); ++endIndex) {
        }
        if (stackIndex >= endIndex) {
            endIndex = stackFrames.length;
        }
        while (stackIndex < endIndex) {
            StackTraceElementWrapper stackTraceElementWrapper2 = new StackTraceElementWrapper(stackFrames[stackIndex]);
            if (stackTraceElementWrapper2.getStackFrameType() == StackFrameType.NEVER_REMOVE) {
                this.endStreak();
                this.cleanedStackTrace.add(stackTraceElementWrapper2);
            } else {
                this.addToStreak(stackTraceElementWrapper2);
                this.lastStackFrameElementWrapper = stackTraceElementWrapper2;
            }
            ++stackIndex;
        }
        this.endStreak();
        ListIterator<StackTraceElementWrapper> iterator = this.cleanedStackTrace.listIterator(this.cleanedStackTrace.size());
        while (iterator.hasPrevious() && ((stackTraceElementWrapper = iterator.previous()).getStackFrameType() == StackFrameType.TEST_FRAMEWORK || stackTraceElementWrapper.getStackFrameType() == StackFrameType.REFLECTION)) {
            iterator.remove();
        }
        StackTraceElement[] result = new StackTraceElement[this.cleanedStackTrace.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.cleanedStackTrace.get(i).getStackTraceElement();
        }
        this.throwable.setStackTrace(result);
        if (this.throwable.getCause() != null) {
            new StackTraceCleaner(this.throwable.getCause()).clean(seenThrowables);
        }
        for (Throwable suppressed : Platform.getSuppressed(this.throwable)) {
            new StackTraceCleaner(suppressed).clean(seenThrowables);
        }
    }

    private void addToStreak(StackTraceElementWrapper stackTraceElementWrapper) {
        if (stackTraceElementWrapper.getStackFrameType() != this.currentStreakType) {
            this.endStreak();
            this.currentStreakType = stackTraceElementWrapper.getStackFrameType();
            this.currentStreakLength = 1;
        } else {
            ++this.currentStreakLength;
        }
    }

    private void endStreak() {
        if (this.currentStreakLength == 0) {
            return;
        }
        if (this.currentStreakLength == 1) {
            this.cleanedStackTrace.add((StackTraceElementWrapper)Preconditions.checkNotNull((Object)this.lastStackFrameElementWrapper));
        } else {
            this.cleanedStackTrace.add(StackTraceCleaner.createStreakReplacementFrame((StackFrameType)((Object)Preconditions.checkNotNull((Object)((Object)this.currentStreakType))), this.currentStreakLength));
        }
        this.clearStreak();
    }

    private void clearStreak() {
        this.currentStreakType = null;
        this.currentStreakLength = 0;
    }

    private static boolean isTruthEntrance(StackTraceElement stackTraceElement) {
        return StackTraceCleaner.isFromClassOrClassNestedInside(stackTraceElement, SUBJECT_CLASS) || StackTraceCleaner.isFromClassDirectly(stackTraceElement, STANDARD_SUBJECT_BUILDER_CLASS);
    }

    private static boolean isJUnitIntrastructure(StackTraceElement stackTraceElement) {
        return StackTraceCleaner.isFromClassOrClassNestedInside(stackTraceElement, JUNIT_INFRASTRUCTURE_CLASSES);
    }

    private static boolean isFromClassOrClassNestedInside(StackTraceElement stackTraceElement, ImmutableSet<String> recognizedClasses) {
        try {
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        try {
            for (Class<?> stackClass = StackTraceCleaner.loadClass(stackTraceElement.getClassName()); stackClass != null; stackClass = stackClass.getEnclosingClass()) {
                for (String recognizedClass : recognizedClasses) {
                    if (!StackTraceCleaner.isSubtypeOf(stackClass, recognizedClass)) continue;
                    return true;
                }
            }
        }
        catch (Error e) {
            if (e.getClass().getName().equals("com.google.j2objc.ReflectionStrippedError")) {
                return false;
            }
            if (e instanceof IncompatibleClassChangeError) {
                return false;
            }
            throw e;
        }
        return false;
    }

    private static boolean isSubtypeOf(@Nullable Class<?> subclass, String superclass) {
        while (subclass != null) {
            if (subclass.getCanonicalName() != null && subclass.getCanonicalName().equals(superclass)) {
                return true;
            }
            subclass = ((Class)Preconditions.checkNotNull(subclass)).getSuperclass();
        }
        return false;
    }

    private static boolean isFromClassDirectly(StackTraceElement stackTraceElement, ImmutableSet<String> recognizedClasses) {
        Class<?> stackClass;
        try {
            stackClass = StackTraceCleaner.loadClass(stackTraceElement.getClassName());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        for (String recognizedClass : recognizedClasses) {
            if (!StackTraceCleaner.isSubtypeOf(stackClass, recognizedClass)) continue;
            return true;
        }
        return false;
    }

    private static Class<?> loadClass(String name) throws ClassNotFoundException {
        ClassLoader loader = (ClassLoader)MoreObjects.firstNonNull((Object)Thread.currentThread().getContextClassLoader(), (Object)StackTraceCleaner.class.getClassLoader());
        return loader.loadClass(name);
    }

    private static StackTraceElementWrapper createStreakReplacementFrame(StackFrameType stackFrameType, int length) {
        return new StackTraceElementWrapper(new StackTraceElement("[[" + stackFrameType.getName() + ": " + length + " frames collapsed (" + CLEANER_LINK + ")]]", "", "", 0), stackFrameType);
    }

    private static boolean isStackTraceCleaningDisabled() {
        try {
            return Boolean.parseBoolean(System.getProperty("com.google.common.truth.disable_stack_trace_cleaning"));
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static enum StackFrameType {
        NEVER_REMOVE("N/A", new String[0]),
        TEST_FRAMEWORK("Testing framework", "junit", "org.junit", "androidx.test.internal.runner", "com.github.bazel_contrib.contrib_rules_jvm.junit5", "com.google.testing.junit", "com.google.testing.testsize", "com.google.testing.util"),
        REFLECTION("Reflective call", "java.lang.reflect", "jdk.internal.reflect", "sun.reflect"),
        CONCURRENT_FRAMEWORK("Concurrent framework", "com.google.tracing.CurrentContext", "com.google.common.util.concurrent", "java.util.concurrent.ForkJoin");

        private final String name;
        private final ImmutableList<String> prefixes;

        private static StackFrameType forClassName(String fullyQualifiedClassName) {
            if (fullyQualifiedClassName.endsWith("Test") && !fullyQualifiedClassName.equals("androidx.test.internal.runner.junit3.NonLeakyTestSuite$NonLeakyTest")) {
                return NEVER_REMOVE;
            }
            for (StackFrameType stackFrameType : StackFrameType.values()) {
                if (!stackFrameType.belongsToType(fullyQualifiedClassName)) continue;
                return stackFrameType;
            }
            return NEVER_REMOVE;
        }

        private StackFrameType(String name, String ... prefixes) {
            this.name = name;
            this.prefixes = ImmutableList.copyOf((Object[])prefixes);
        }

        String getName() {
            return this.name;
        }

        boolean belongsToType(String fullyQualifiedClassName) {
            for (String prefix : this.prefixes) {
                if (!fullyQualifiedClassName.equals(prefix) && !fullyQualifiedClassName.startsWith(prefix + ".")) continue;
                return true;
            }
            return false;
        }
    }

    private static class StackTraceElementWrapper {
        private final StackTraceElement stackTraceElement;
        private final StackFrameType stackFrameType;

        StackTraceElementWrapper(StackTraceElement stackTraceElement) {
            this(stackTraceElement, StackFrameType.forClassName(stackTraceElement.getClassName()));
        }

        StackTraceElementWrapper(StackTraceElement stackTraceElement, StackFrameType stackFrameType) {
            this.stackTraceElement = stackTraceElement;
            this.stackFrameType = stackFrameType;
        }

        StackFrameType getStackFrameType() {
            return this.stackFrameType;
        }

        StackTraceElement getStackTraceElement() {
            return this.stackTraceElement;
        }
    }
}

