/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Multimap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;

final class GraphMatching {
    static <U, V> ImmutableBiMap<U, V> maximumCardinalityBipartiteMatching(Multimap<U, V> graph) {
        return HopcroftKarp.overBipartiteGraph(graph).perform();
    }

    private GraphMatching() {
    }

    private static class HopcroftKarp<U, V> {
        private final Multimap<U, V> graph;

        static <U, V> HopcroftKarp<U, V> overBipartiteGraph(Multimap<U, V> graph) {
            return new HopcroftKarp<U, V>(graph);
        }

        private HopcroftKarp(Multimap<U, V> graph) {
            this.graph = graph;
        }

        ImmutableBiMap<U, V> perform() {
            HashMap layers;
            Optional<Integer> freeRhsVertexLayer;
            HashBiMap matching = HashBiMap.create();
            while ((freeRhsVertexLayer = this.breadthFirstSearch((BiMap<U, V>)matching, layers = new HashMap())).isPresent()) {
                for (Object lhs : this.graph.keySet()) {
                    if (matching.containsKey(lhs)) continue;
                    this.depthFirstSearch((BiMap<U, V>)matching, layers, (Integer)freeRhsVertexLayer.get(), (U)lhs);
                }
            }
            return ImmutableBiMap.copyOf((Map)matching);
        }

        private Optional<Integer> breadthFirstSearch(BiMap<U, V> matching, Map<U, Integer> layers) {
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            Optional freeRhsVertexLayer = Optional.absent();
            for (Object lhs : this.graph.keySet()) {
                if (matching.containsKey(lhs)) continue;
                layers.put(lhs, 1);
                queue.add(lhs);
            }
            while (!queue.isEmpty()) {
                Object lhs = queue.remove();
                int layer = (Integer)Preconditions.checkNotNull((Object)layers.get(lhs));
                if (freeRhsVertexLayer.isPresent() && layer > (Integer)freeRhsVertexLayer.get()) break;
                for (Object rhs : this.graph.get(lhs)) {
                    if (!matching.containsValue(rhs)) {
                        if (freeRhsVertexLayer.isPresent()) continue;
                        freeRhsVertexLayer = Optional.of((Object)layer);
                        continue;
                    }
                    Object nextLhs = Preconditions.checkNotNull((Object)matching.inverse().get(rhs));
                    if (layers.containsKey(nextLhs)) continue;
                    layers.put(nextLhs, layer + 1);
                    queue.add(nextLhs);
                }
            }
            return freeRhsVertexLayer;
        }

        @CanIgnoreReturnValue
        private boolean depthFirstSearch(BiMap<U, V> matching, Map<U, Integer> layers, int freeRhsVertexLayer, U lhs) {
            int layer = (Integer)Preconditions.checkNotNull((Object)layers.get(lhs));
            if (layer > freeRhsVertexLayer) {
                return false;
            }
            for (Object rhs : this.graph.get(lhs)) {
                if (!matching.containsValue(rhs)) {
                    matching.forcePut(lhs, rhs);
                    return true;
                }
                Object nextLhs = Preconditions.checkNotNull((Object)matching.inverse().get(rhs));
                if (!layers.containsKey(nextLhs) || layers.get(nextLhs) != layer + 1 || !this.depthFirstSearch(matching, layers, freeRhsVertexLayer, nextLhs)) continue;
                matching.forcePut(lhs, rhs);
                return true;
            }
            return false;
        }
    }
}

