/*
 * Decompiled with CFR 0.152.
 */
package com.declarativa.interprolog;

import com.declarativa.interprolog.ObjectExamplePair;
import com.declarativa.interprolog.PrologEngine;
import com.declarativa.interprolog.PrologImplementationPeer;
import com.declarativa.interprolog.TermModel;
import com.declarativa.interprolog.util.BasicTypeWrapper;
import com.declarativa.interprolog.util.GoalFromJava;
import com.declarativa.interprolog.util.GoalToExecute;
import com.declarativa.interprolog.util.IPAbortedException;
import com.declarativa.interprolog.util.IPClassObject;
import com.declarativa.interprolog.util.IPClassVariable;
import com.declarativa.interprolog.util.IPException;
import com.declarativa.interprolog.util.IPInterruptedException;
import com.declarativa.interprolog.util.IPPrologError;
import com.declarativa.interprolog.util.InvisibleObject;
import com.declarativa.interprolog.util.MessageExecuting;
import com.declarativa.interprolog.util.MessageFromProlog;
import com.declarativa.interprolog.util.ObjectRegistry;
import com.declarativa.interprolog.util.ResultFromJava;
import com.declarativa.interprolog.util.ResultFromProlog;
import com.declarativa.interprolog.util.VariableNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;

public abstract class AbstractPrologEngine
implements PrologEngine {
    protected PrologImplementationPeer peer;
    public String prologBinDirectoryOrCommand;
    protected long startTime;
    public static final String nl = System.getProperty("line.separator");
    protected File tempDirectory;
    protected ObjectRegistry knownObjects;
    protected boolean shutingDown = false;
    public boolean interrupting = false;
    protected boolean debug = false;
    protected boolean loadFromJar;
    protected boolean topGoalHasStarted = false;
    protected int goalTimestamp;
    protected boolean threadedCallbacks = true;
    protected Stack dgThreads = new Stack();
    Vector goalsToExecute;
    Vector messagesExecuting;
    protected Thread prologHandler = null;
    final Method getRealJavaObjectMethod;
    public final String firstJavaMessageName = "firstJavaMessage";
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$declarativa$interprolog$AbstractPrologEngine;
    static /* synthetic */ Class class$java$net$URLDecoder;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Class;

    public AbstractPrologEngine(String string, boolean bl, boolean bl2) {
        this.startTime = System.currentTimeMillis();
        this.peer = this.makeImplementationPeer();
        this.loadFromJar = bl2;
        if (string == null) {
            File file = new File(this.getJarDirectory(), "interprolog.defs");
            if (file.exists()) {
                System.out.println("Using " + file);
                try {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    string = this.getBinDirectoryProperty(properties);
                    fileInputStream.close();
                    if (string == null) {
                        throw new IPException("Bad ..._BIN_DIRECTORY in interprolog.defs file:" + string);
                    }
                    string = this.executablePath(string);
                }
                catch (IOException iOException) {
                    throw new IPException("Could not read interprolog.defs file");
                }
            } else {
                string = this.executablePath(this.getBinDirectoryProperty(System.getProperties()));
            }
        }
        if (string == null) {
            throw new IPException("PrologEngine with null prologBinDirectory");
        }
        this.debug = bl;
        this.prologBinDirectoryOrCommand = string;
        this.makeTempDirectory();
        this.knownObjects = new ObjectRegistry();
        this.goalsToExecute = new Vector();
        this.messagesExecuting = new Vector();
        try {
            this.getRealJavaObjectMethod = AbstractPrologEngine.findMethod(this.getClass(), "getRealJavaObject", new Class[]{class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = AbstractPrologEngine.class$("java.lang.Object"))});
        }
        catch (Exception exception) {
            throw new IPException("could not find special getRealJavaObject method:" + exception);
        }
    }

    protected void loadInitialFile() {
        this.progressMessage("Setting up Prolog library paths...");
        String string = this.peer.unescapedFilePath(this.tempDirectory.getAbsolutePath());
        this.command("assertz(library_directory('" + string + "'))");
        this.progressMessage("Loading initial file...");
        String string2 = this.peer.interprologFilename();
        if (this.loadFromJar) {
            this.consultFromPackage(string2, class$com$declarativa$interprolog$AbstractPrologEngine != null ? class$com$declarativa$interprolog$AbstractPrologEngine : (class$com$declarativa$interprolog$AbstractPrologEngine = AbstractPrologEngine.class$("com.declarativa.interprolog.AbstractPrologEngine")));
        } else {
            this.consultRelative(string2, class$com$declarativa$interprolog$AbstractPrologEngine != null ? class$com$declarativa$interprolog$AbstractPrologEngine : (class$com$declarativa$interprolog$AbstractPrologEngine = AbstractPrologEngine.class$("com.declarativa.interprolog.AbstractPrologEngine")));
        }
    }

    protected abstract PrologImplementationPeer makeImplementationPeer();

    public PrologImplementationPeer getImplementationPeer() {
        return this.peer;
    }

    protected String getBinDirectoryProperty(Properties properties) {
        return this.peer.getBinDirectoryProperty(properties);
    }

    protected String executablePath(String string) {
        return this.peer.executablePath(string);
    }

    public String getPrologVersion() {
        return this.peer.getPrologVersion();
    }

    public String getPrologNumericVersion() {
        return this.peer.getPrologNumericVersion();
    }

    public String getPrologBaseDirectory() {
        return this.prologBinToBaseDirectory(this.prologBinDirectoryOrCommand);
    }

    public String prologBinToBaseDirectory(String string) {
        return this.peer.prologBinToBaseDirectory(string);
    }

    public static boolean isWindowsOS() {
        return System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
    }

    public static boolean isMacOS() {
        return System.getProperty("os.name").toLowerCase().indexOf("mac os x") != -1;
    }

    public void shutdown() {
        if (this.isShutingDown()) {
            this.progressMessage("Was already shuting down");
        }
        this.shutingDown = true;
        this.abortTasks();
    }

    public boolean isShutingDown() {
        return this.shutingDown;
    }

    void makeTempDirectory() {
        this.makeTempDirectory(2);
    }

    void makeTempDirectory(int n) {
        --n;
        if (this.tempDirectory != null) {
            throw new IPException("Inconsistency in makeTempDirectory");
        }
        try {
            File file = File.createTempFile("IP_", "");
            if (!file.delete()) {
                throw new IPException("Could not delete dummy file");
            }
            this.tempDirectory = new File(file.getAbsolutePath());
            if (!this.tempDirectory.mkdir()) {
                throw new IPException("Could not create temporary directory");
            }
            this.tempDirectory.deleteOnExit();
        }
        catch (IOException iOException) {
            if (n > 0) {
                this.progressMessage("Failed makeTempDirectory:" + iOException + "\nTrying again");
                this.makeTempDirectory(n);
            }
            throw new IPException("Problems creating temporary directory:" + iOException);
        }
    }

    public File getJarDirectory() {
        return AbstractPrologEngine.getJarDirectory(this.getClass());
    }

    public static File getJarDirectory(Class clazz) {
        String string = String.valueOf(clazz.getName().replace('.', '/')) + ".class";
        URL uRL = clazz.getClassLoader().getResource(string);
        if (!uRL.getProtocol().equals("jar")) {
            return null;
        }
        String string2 = uRL.getFile();
        if (!string2.startsWith("file:/")) {
            throw new IPException("Jar file is not in the local file system");
        }
        int n = string2.indexOf("!");
        if (n == -1) {
            throw new IPException("Bad jar URL");
        }
        String string3 = string2.substring(5, n);
        if (!string3.endsWith(".jar")) {
            throw new IPException("Jar file name does not end with .jar");
        }
        string3 = string3.replace('/', File.separatorChar);
        return new File(string3).getParentFile();
    }

    File copyToTemp(String string, Object object) {
        this.progressMessage("copyToTemp:" + string + ",requester==" + object);
        File file = null;
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        String string2 = clazz.getName();
        String string3 = string2.substring(0, string2.lastIndexOf(46));
        String string4 = string3.replace('.', '/');
        this.progressMessage("path==" + string4 + ",packageName==" + string3);
        String string5 = null;
        try {
            int n;
            Object object2;
            String string6 = String.valueOf(string4) + '/';
            InputStream inputStream = null;
            if (string.indexOf(46) != -1) {
                string5 = string;
                inputStream = classLoader.getResourceAsStream(String.valueOf(string6) + string);
            } else {
                object2 = this.alternativePrologExtensions(string);
                int n2 = 0;
                while (n2 < ((String[])object2).length) {
                    string5 = object2[n2];
                    inputStream = classLoader.getResourceAsStream(String.valueOf(string6) + string5);
                    if (inputStream != null) break;
                    ++n2;
                }
            }
            if (inputStream == null) {
                throw new IPException("Resource not found:" + string6 + string5);
            }
            file = new File(this.tempDirectory, string5);
            object2 = file.getParentFile();
            if (object2 != null && !((File)object2).exists()) {
                if (!((File)object2).mkdirs()) {
                    throw new IPException("Could not create parent directories for " + file);
                }
                this.progressMessage("About to check for parent directories...");
                this.setTempDirectoriesToDelete((File)object2);
            }
            this.progressMessage("Created file object for tempDirectory:" + file);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.progressMessage("Created file output stream in tempDirectory:" + fileOutputStream);
            byte[] byArray = new byte[512];
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
            fileOutputStream.close();
            inputStream.close();
        }
        catch (IOException iOException) {
            throw new IPException("I/O problem obtaining " + string5 + ": " + iOException);
        }
        this.progressMessage("exiting copyToTemp:" + file);
        return file;
    }

    private void setTempDirectoriesToDelete(File file) {
        if (file != null && !file.getAbsolutePath().equals(this.tempDirectory.getAbsolutePath())) {
            this.setTempDirectoriesToDelete(file.getParentFile());
            this.progressMessage("Temp parent directory detected! Path: " + file.getAbsolutePath() + " \nSetting it to delete on exit.");
            file.deleteOnExit();
        }
    }

    public String unescapedFilePath(String string) {
        return this.peer.unescapedFilePath(string);
    }

    protected static String currentOSpath(String string) {
        if (File.separatorChar == '/') {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        while (n < stringBuffer.length()) {
            if (stringBuffer.charAt(n) == '/') {
                stringBuffer.setCharAt(n, File.separatorChar);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected String[] alternativePrologExtensions(String string) {
        return this.peer.alternativePrologExtensions(string);
    }

    public void consultFromPackage(String string, Object object) {
        String string2 = this.cleanPath(this.copyToTemp(string, object).getPath());
        string2 = this.unescapedFilePath(string2);
        this.progressMessage("consultFromPackage:" + string2);
        if (!this.command("consult('" + string2 + "')")) {
            throw new IPException("Problem consulting from package archive:" + string2);
        }
    }

    public boolean consultAbsolute(File file) {
        return this.command("consult('" + this.unescapedFilePath(file.getAbsolutePath()) + "')");
    }

    public void consultRelative(String string, Object object) {
        this.operationRelative("consult", AbstractPrologEngine.currentOSpath(string), object);
    }

    public void load_dynRelative(String string, Object object) {
        this.operationRelative("load_dyn", string, object);
    }

    protected void operationRelative(String string, String string2, Object object) {
        Class<?> clazz = object instanceof Class ? (Class<?>)object : object.getClass();
        String string3 = clazz.getPackage().getName().replace('.', File.separatorChar);
        string3 = String.valueOf(this.cleanPath(this.getJarDirectory().getPath())) + File.separatorChar + string3;
        string2 = String.valueOf(string3) + File.separatorChar + string2;
        string3 = this.unescapedFilePath(string3);
        string2 = this.unescapedFilePath(string2);
        String string4 = "((library_directory('" + string3 + "')->true;assert(library_directory('" + string3 + "'))), " + string + "('" + string2 + "'))";
        if (!this.command(string4)) {
            throw new IPException("Problem in operationRelative");
        }
    }

    private String cleanPath(String string) {
        this.progressMessage("Cleaning path " + string);
        if (System.getProperty("java.version").compareTo("1.4") >= 0) {
            try {
                Method method = (class$java$net$URLDecoder != null ? class$java$net$URLDecoder : (class$java$net$URLDecoder = AbstractPrologEngine.class$("java.net.URLDecoder"))).getMethod("decode", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AbstractPrologEngine.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = AbstractPrologEngine.class$("java.lang.String")));
                return (String)method.invoke((Object)new URLDecoder(), string, "UTF-8");
            }
            catch (Exception exception) {
                throw new IPException("Inconsistency in PrologEngine.cleanPath" + exception);
            }
        }
        return string;
    }

    public void interrupt() {
        this.interrupting = true;
        this.doInterrupt();
        this.waitUntilIdle();
        this.interrupting = false;
    }

    protected abstract void doInterrupt();

    public boolean command(String string) {
        if (this.topGoalHasStarted) {
            return this.deterministicGoal(string);
        }
        return this.realCommand(string);
    }

    public abstract boolean realCommand(String var1);

    public void progressMessage(String string) {
        if (this.debug) {
            System.out.println(String.valueOf(System.currentTimeMillis() - this.startTime) + "ms: " + string + "(" + Thread.currentThread() + ")");
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        if (bl) {
            System.out.println(String.valueOf(System.currentTimeMillis() - this.startTime) + "ms: " + "now showing debugging information");
        }
        if (bl && !this.debug && !this.command("assert(ipIsDebugging)")) {
            throw new IPException("Could not clear ipIsDebugging");
        }
        if (!bl && this.debug && !this.command("retractall(ipIsDebugging)")) {
            throw new IPException("Could not set ipIsDebugging");
        }
        this.debug = bl;
    }

    public boolean getLoadFromJar() {
        return this.loadFromJar;
    }

    public static void printBindings(Object[] objectArray) {
        if (objectArray == null) {
            System.out.println("Empty bindings");
        } else {
            int n = 0;
            while (n < objectArray.length) {
                System.out.println("Binding " + n + ":" + objectArray[n]);
                ++n;
            }
        }
    }

    protected final void teachIPobjects(ObjectOutputStream objectOutputStream) throws IOException {
        Object[] objectArray = new Object[]{new Integer(13)};
        objectOutputStream.writeObject(new ObjectExamplePair("GoalFromJava", new GoalFromJava(1, "a", "aa", new Object[0], "A"), new GoalFromJava(2, "b", "bb", objectArray, "B")));
        objectOutputStream.writeObject(new ObjectExamplePair("ResultFromProlog", new ResultFromProlog(1, true, 0, null), new ResultFromProlog(2, false, 1, "some error")));
        MessageFromProlog messageFromProlog = new MessageFromProlog();
        messageFromProlog.methodName = "methodA";
        messageFromProlog.arguments = new Object[0];
        messageFromProlog.returnArguments = true;
        MessageFromProlog messageFromProlog2 = new MessageFromProlog();
        messageFromProlog2.timestamp = 2;
        messageFromProlog2.target = "target";
        messageFromProlog2.methodName = "methodB";
        messageFromProlog2.arguments = new Object[1];
        messageFromProlog2.returnArguments = false;
        objectOutputStream.writeObject(new ObjectExamplePair("MessageFromProlog", messageFromProlog, messageFromProlog2));
        objectOutputStream.writeObject(new ObjectExamplePair("ResultFromJava", new ResultFromJava(1, null, null, new Object[0]), new ResultFromJava(2, "result here", "new Exception()...", new Object[1])));
        objectOutputStream.writeObject(new ObjectExamplePair("InvisibleObject", new InvisibleObject(1), new InvisibleObject(2)));
        objectOutputStream.writeObject(new ObjectExamplePair("IPClassObject", new IPClassObject("A"), new IPClassObject("B")));
        objectOutputStream.writeObject(new ObjectExamplePair("IPClassVariable", new IPClassVariable("ClassA", "VariableA"), new IPClassVariable("ClassB", "VariableB")));
    }

    protected void teachBasicObjects(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new ObjectExamplePair("boolean", new BasicTypeWrapper(new Boolean(true)), new BasicTypeWrapper(new Boolean(false))));
        objectOutputStream.writeObject(new ObjectExamplePair("byte", new BasicTypeWrapper(new Byte(new Integer(1).byteValue())), new BasicTypeWrapper(new Byte(new Integer(2).byteValue()))));
        objectOutputStream.writeObject(new ObjectExamplePair("char", new BasicTypeWrapper(new Character('A')), new BasicTypeWrapper(new Character('B'))));
        objectOutputStream.writeObject(new ObjectExamplePair("double", new BasicTypeWrapper(new Double(1.0)), new BasicTypeWrapper(new Double(2.0))));
        objectOutputStream.writeObject(new ObjectExamplePair("float", new BasicTypeWrapper(new Float(1.0f)), new BasicTypeWrapper(new Float(2.0f))));
        objectOutputStream.writeObject(new ObjectExamplePair("int", new BasicTypeWrapper(new Integer(1)), new BasicTypeWrapper(new Integer(2))));
        objectOutputStream.writeObject(new ObjectExamplePair("long", new BasicTypeWrapper(new Long(1L)), new BasicTypeWrapper(new Long(2L))));
        objectOutputStream.writeObject(new ObjectExamplePair("short", new BasicTypeWrapper(new Short(new Integer(1).shortValue())), new BasicTypeWrapper(new Short(new Integer(2).shortValue()))));
        objectOutputStream.writeObject(new ObjectExamplePair(new Boolean(true), (Object)new Boolean(false)));
        objectOutputStream.writeObject(new ObjectExamplePair(new Integer(1), (Object)new Integer(2)));
        objectOutputStream.writeObject(new ObjectExamplePair(new Float(20.59375), (Object)new Float(2.0f)));
        objectOutputStream.writeObject(TermModel.example());
        objectOutputStream.writeObject(VariableNode.example());
        objectOutputStream.writeObject(new ObjectExamplePair("ArrayOfTermModel", new TermModel[0], new TermModel[1]));
        objectOutputStream.writeObject(new ObjectExamplePair("ArrayOfString", (Object)new String[0]));
        objectOutputStream.writeObject(new ObjectExamplePair("ArrayOfObject", (Object)new Object[0]));
    }

    public boolean teachOneObject(Object object) {
        return this.teachMoreObjects(new Object[]{object});
    }

    public boolean teachMoreObjects(Object[] objectArray) {
        if (objectArray[0] instanceof ObjectExamplePair) {
            throw new IPException("Bad method invocation in teachMoreObjects");
        }
        ObjectExamplePair[] objectExamplePairArray = new ObjectExamplePair[objectArray.length];
        int n = 0;
        while (n < objectExamplePairArray.length) {
            objectExamplePairArray[n] = new ObjectExamplePair(objectArray[n]);
            ++n;
        }
        return this.teachMoreObjects(objectExamplePairArray);
    }

    public boolean teachMoreObjects(ObjectExamplePair[] objectExamplePairArray) {
        Object[] objectArray = new Object[objectExamplePairArray.length];
        int n = 0;
        while (n < objectExamplePairArray.length) {
            objectArray[n] = objectExamplePairArray[n];
            ++n;
        }
        return this.deterministicGoal("ipProcessExamples(Examples)", "Examples", objectArray);
    }

    public boolean teachMoreObjects(ObjectExamplePair objectExamplePair) {
        return this.teachMoreObjects(new ObjectExamplePair[]{objectExamplePair});
    }

    protected GoalFromJava makeDGoalObject(String string, String string2, Object[] objectArray, String string3, int n) {
        if (string == null) {
            throw new IPException("Null Goal in deterministicGoal");
        }
        if (string2 == null) {
            string2 = "_";
        }
        if (objectArray == null) {
            objectArray = new Object[]{};
        } else if (!objectArray.getClass().getName().equals("[Ljava.lang.Object;")) {
            throw new IPException("objectsP argument must be an array of Object");
        }
        if (string.trim().endsWith(".")) {
            throw new IPException("Goal argument should have no trailing '.', in deterministicGoal");
        }
        return new GoalFromJava(n, string, string2, objectArray, string3);
    }

    public Object[] deterministicGoal(String string, String string2, Object[] objectArray, String string3) {
        int n = this.incGoalTimestamp();
        GoalFromJava goalFromJava = this.makeDGoalObject(string, string2, objectArray, string3, n);
        this.progressMessage("Prepared GoalFromJava:" + goalFromJava);
        Object[] objectArray2 = null;
        try {
            this.progressMessage("Schedulling (in PrologEngine) goal " + string + ", timestamp " + n + " in thread " + Thread.currentThread().getName());
            GoalToExecute goalToExecute = new GoalToExecute(goalFromJava, Thread.currentThread());
            this.scheduleGoal(goalToExecute);
            this.progressMessage("Schedulled " + goalToExecute);
            ResultFromProlog resultFromProlog = goalToExecute.waitForResult();
            this.progressMessage("Got result for " + goalToExecute);
            if (resultFromProlog == null) {
                throw new IPException("Problems in goal result");
            }
            if (goalToExecute.wasAborted()) {
                throw new IPAbortedException(String.valueOf(string) + " was aborted by Java-side cascading");
            }
            if (goalToExecute.wasInterrupted()) {
                throw new IPInterruptedException(String.valueOf(string) + " was interrupted by Java-side cascading");
            }
            if (resultFromProlog.wasInterrupted(this)) {
                throw new IPInterruptedException(String.valueOf(string) + " was interrupted, Prolog detected");
            }
            if (resultFromProlog.error != null) {
                throw new IPPrologError(resultFromProlog.error);
            }
            if (resultFromProlog.timestamp != n) {
                throw new IPException("bad timestamp in deterministicGoal, got " + resultFromProlog.timestamp + " instead of " + this.goalTimestamp);
            }
            if (resultFromProlog.succeeded) {
                objectArray2 = resultFromProlog.rVars;
            }
        }
        catch (IPException iPException) {
            throw iPException;
        }
        catch (Exception exception) {
            throw new IPException("Problem in deterministicGoal:" + exception);
        }
        return objectArray2;
    }

    public boolean deterministicGoal(String string) {
        return this.deterministicGoal(string, null, null, "[]") != null;
    }

    public Object[] deterministicGoal(String string, String string2) {
        return this.deterministicGoal(string, null, null, string2);
    }

    public boolean deterministicGoal(String string, String string2, Object[] objectArray) {
        return this.deterministicGoal(string, string2, objectArray, "[]") != null;
    }

    public TermModel deterministicGoal(TermModel termModel) {
        Object[] objectArray = this.deterministicGoal("recoverTermModel(GM,G), call(G), buildTermModel(G,SM)", "[GM]", new Object[]{termModel}, "[SM]");
        if (objectArray == null) {
            return null;
        }
        return (TermModel)objectArray[0];
    }

    protected int incGoalTimestamp() {
        ++this.goalTimestamp;
        if (this.goalTimestamp < 0) {
            throw new IPException("goalTimestamp did wrap around, please improve it...");
        }
        return this.goalTimestamp;
    }

    protected synchronized void scheduleGoal(GoalToExecute goalToExecute) {
        this.goalsToExecute.addElement(goalToExecute);
    }

    protected synchronized GoalToExecute moreRecentToExecute() {
        int n = this.goalsToExecute.size() - 1;
        while (n >= 0) {
            GoalToExecute goalToExecute = (GoalToExecute)this.goalsToExecute.elementAt(n);
            if (!goalToExecute.hasStarted()) {
                return goalToExecute;
            }
            --n;
        }
        return null;
    }

    protected synchronized GoalToExecute findLastGTEWithProperThread() {
        int n = this.goalsToExecute.size() - 1;
        while (n >= 0) {
            GoalToExecute goalToExecute = (GoalToExecute)this.goalsToExecute.elementAt(n);
            if (goalToExecute.hasStarted() && !goalToExecute.hasEnded() && goalToExecute.getCallerThread() == this.currentDGthread()) {
                return goalToExecute;
            }
            --n;
        }
        throw new IPException("Could not find thread for callback; currentDGthread==" + this.currentDGthread() + "; " + this.goalsToExecute.size() + " GTEs");
    }

    void pushDGthread(Thread thread) {
        this.dgThreads.push(thread);
    }

    void popDGthread() {
        this.dgThreads.pop();
    }

    Thread currentDGthread() {
        return (Thread)this.dgThreads.peek();
    }

    protected synchronized GoalToExecute forgetGoal(int n) {
        int n2 = 0;
        while (n2 < this.goalsToExecute.size()) {
            GoalToExecute goalToExecute = (GoalToExecute)this.goalsToExecute.elementAt(n2);
            if (goalToExecute.getTimestamp() == n) {
                this.goalsToExecute.removeElementAt(n2);
                return goalToExecute;
            }
            ++n2;
        }
        return null;
    }

    protected synchronized void addMessage(MessageExecuting messageExecuting) {
        this.messagesExecuting.addElement(messageExecuting);
    }

    protected synchronized void forgetMessage(MessageExecuting messageExecuting) {
        this.messagesExecuting.removeElement(messageExecuting);
    }

    protected synchronized MessageExecuting lastMessageRequest() {
        MessageExecuting messageExecuting = this.messagesExecuting.size() == 0 ? null : (MessageExecuting)this.messagesExecuting.lastElement();
        return messageExecuting;
    }

    public synchronized boolean isIdle() {
        return this.messagesExecuting.size() == 0 && this.goalsToExecute.size() == 0;
    }

    public synchronized void endAllTasks(Exception exception) {
        int n = 0;
        while (n < this.goalsToExecute.size()) {
            GoalToExecute goalToExecute = (GoalToExecute)this.goalsToExecute.elementAt(n);
            goalToExecute.setResult(new ResultFromProlog(goalToExecute.getTimestamp(), false, 0, exception));
            ++n;
        }
        this.cleanupTasks();
    }

    public synchronized void abortTasks() {
        int n = 0;
        while (n < this.goalsToExecute.size()) {
            GoalToExecute goalToExecute = (GoalToExecute)this.goalsToExecute.elementAt(n);
            goalToExecute.abort();
            ++n;
        }
        this.cleanupTasks();
    }

    public synchronized void interruptTasks() {
        int n = 0;
        while (n < this.goalsToExecute.size()) {
            GoalToExecute goalToExecute = (GoalToExecute)this.goalsToExecute.elementAt(n);
            goalToExecute.interrupt();
            ++n;
        }
        this.cleanupTasks();
    }

    protected void cleanupTasks() {
        this.goalsToExecute.removeAllElements();
        this.messagesExecuting.removeAllElements();
        while (!this.dgThreads.empty()) {
            Thread thread = (Thread)this.dgThreads.pop();
            if (!thread.isAlive() || !this.shutingDown) continue;
            thread.interrupt();
        }
    }

    public boolean isAvailable() {
        return true;
    }

    public void waitUntilAvailable() {
        try {
            while (!this.isAvailable()) {
                Thread.sleep(0L, 1);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IPException("Bad interrupt:" + interruptedException);
        }
    }

    public void waitUntilIdle() {
        try {
            while (!this.isIdle()) {
                Thread.sleep(0L, 1);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new IPException("Bad interrupt:" + interruptedException);
        }
    }

    public Object handleCallback(Object object) {
        this.progressMessage("Entering handleCallback");
        if (object instanceof ClassNotFoundException) {
            return new ResultFromJava(0, null, (ClassNotFoundException)object, null);
        }
        if (object instanceof MessageFromProlog) {
            MessageFromProlog messageFromProlog = (MessageFromProlog)object;
            this.progressMessage("handling " + messageFromProlog);
            if (!this.isFirstJavaMessage(messageFromProlog)) {
                MessageExecuting messageExecuting = new MessageExecuting(messageFromProlog, this);
                this.addMessage(messageExecuting);
                if (this.threadedCallbacks) {
                    new Thread(messageExecuting).start();
                } else {
                    GoalToExecute goalToExecute = this.findLastGTEWithProperThread();
                    goalToExecute.executeInThread(messageExecuting);
                }
            } else {
                this.progressMessage("received first (dummy) javaMessage");
            }
        } else if (object instanceof ResultFromProlog) {
            ResultFromProlog resultFromProlog = (ResultFromProlog)object;
            this.popDGthread();
            this.progressMessage("handling " + resultFromProlog);
            GoalToExecute goalToExecute = this.forgetGoal(resultFromProlog.timestamp);
            this.progressMessage("forgot goal " + goalToExecute + "; isIdle()==" + this.isIdle());
            if (goalToExecute == null) {
                throw new IPException("Could not find goal " + resultFromProlog.timestamp);
            }
            goalToExecute.setResult(resultFromProlog);
        } else {
            throw new IPException("bad object in handleCallback:" + object);
        }
        this.progressMessage("About to leave handleCallback");
        return this.doSomething();
    }

    protected Object doSomething() {
        while (!this.shutingDown) {
            Object object;
            if (this.isIdle()) {
                try {
                    Thread.sleep(0L, 100);
                }
                catch (InterruptedException interruptedException) {
                    throw new IPException("Bad interrupt:" + interruptedException);
                }
            }
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                throw new IPException("Bad interrupt:" + interruptedException);
            }
            MessageExecuting messageExecuting = this.lastMessageRequest();
            if (messageExecuting != null && messageExecuting.hasEnded()) {
                this.forgetMessage(messageExecuting);
                object = messageExecuting.getResult();
                return object;
            }
            object = this.moreRecentToExecute();
            if (object == null) continue;
            this.pushDGthread(((GoalToExecute)object).getCallerThread());
            ((GoalToExecute)object).prologWasCalled();
            return ((GoalToExecute)object).getGoal();
        }
        return null;
    }

    private boolean isFirstJavaMessage(MessageFromProlog messageFromProlog) {
        if (!messageFromProlog.methodName.equals("firstJavaMessage")) {
            return false;
        }
        return messageFromProlog.target instanceof InvisibleObject && this.getRealJavaObject((InvisibleObject)messageFromProlog.target) == this;
    }

    public final void firstJavaMessage() {
        throw new IPException("This should never be called, bad javaMessage handling");
    }

    public ResultFromJava doCallback(Object object) {
        this.progressMessage("Starting handling of XSB->Java callback:" + nl + object);
        if (object == null | object instanceof MessageFromProlog ^ true) {
            return new ResultFromJava(0, null, null, null);
        }
        MessageFromProlog messageFromProlog = (MessageFromProlog)object;
        Class[] classArray = new Class[messageFromProlog.arguments.length];
        Object[] objectArray = new Object[messageFromProlog.arguments.length];
        Object object2 = null;
        Object object3 = null;
        Exception exception = null;
        try {
            GenericDeclaration genericDeclaration;
            Object object4;
            if (messageFromProlog.target instanceof InvisibleObject) {
                object2 = this.getRealJavaObject((InvisibleObject)messageFromProlog.target);
            } else if (messageFromProlog.target instanceof IPClassObject) {
                object2 = Class.forName(((IPClassObject)messageFromProlog.target).classname);
            } else if (messageFromProlog.target instanceof IPClassVariable) {
                IPClassVariable iPClassVariable = (IPClassVariable)messageFromProlog.target;
                object4 = Class.forName(iPClassVariable.className);
                object2 = ((Class)object4).getField(iPClassVariable.variableName).get(object4);
            } else {
                object2 = messageFromProlog.target;
            }
            int n = 0;
            while (n < classArray.length) {
                objectArray[n] = messageFromProlog.arguments[n];
                if (objectArray[n] != null) {
                    if (objectArray[n] instanceof BasicTypeWrapper) {
                        object4 = (BasicTypeWrapper)objectArray[n];
                        classArray[n] = ((BasicTypeWrapper)object4).basicTypeClass();
                        objectArray[n] = ((BasicTypeWrapper)object4).wrapper;
                    } else if (objectArray[n] instanceof InvisibleObject) {
                        objectArray[n] = this.getRealJavaObject((InvisibleObject)objectArray[n]);
                        classArray[n] = objectArray[n].getClass();
                    } else if (objectArray[n] instanceof IPClassObject) {
                        objectArray[n] = Class.forName(((IPClassObject)objectArray[n]).classname);
                        classArray[n] = class$java$lang$Class != null ? class$java$lang$Class : AbstractPrologEngine.class$("java.lang.Class");
                    } else if (objectArray[n] instanceof IPClassVariable) {
                        object4 = (IPClassVariable)objectArray[n];
                        genericDeclaration = Class.forName(((IPClassVariable)object4).className);
                        objectArray[n] = ((Class)genericDeclaration).getField(((IPClassVariable)object4).variableName).get(null);
                        classArray[n] = objectArray[n].getClass();
                    } else {
                        classArray[n] = objectArray[n].getClass();
                    }
                }
                ++n;
            }
            object4 = null;
            if (object2 instanceof Class) {
                if (AbstractPrologEngine.shortClassName((Class)object2).equals(messageFromProlog.methodName)) {
                    genericDeclaration = AbstractPrologEngine.findConstructor((Class)object2, classArray);
                    object3 = ((Constructor)genericDeclaration).newInstance(objectArray);
                } else {
                    object4 = AbstractPrologEngine.findMethod((Class)object2, messageFromProlog.methodName, classArray);
                    object3 = ((Method)object4).invoke(object2, objectArray);
                }
            } else {
                object4 = AbstractPrologEngine.findMethod(object2.getClass(), messageFromProlog.methodName, classArray);
                object3 = ((Method)object4).invoke(object2, objectArray);
            }
            if (!(object3 == null || object2 == this && ((Method)object4).equals(this.getRealJavaObjectMethod) || object3 instanceof InvisibleObject || object3 instanceof String || object3 instanceof TermModel || BasicTypeWrapper.instanceOfWrapper(object3))) {
                object3 = this.makeInvisible(object3);
            }
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        if (exception != null) {
            System.out.println("Courtesy of CallbackHandler:");
            exception.printStackTrace();
        }
        if (messageFromProlog.returnArguments) {
            return new ResultFromJava(messageFromProlog.timestamp, object3, exception, messageFromProlog.arguments);
        }
        return new ResultFromJava(messageFromProlog.timestamp, object3, exception, null);
    }

    /*
     * Unable to fully structure code
     */
    public static Method findMethod(Class var0, String var1_1, Class[] var2_2) throws NoSuchMethodException {
        var3_3 = null;
        try {
            var3_3 = var0.getMethod(var1_1, var2_2);
            return var3_3;
        }
        catch (NoSuchMethodException var4_4) {
            var5_5 = var0.getMethods();
            var6_6 = 0;
            ** while (var6_6 < var5_5.length)
        }
lbl-1000:
        // 1 sources

        {
            if (var5_5[var6_6].getName().equals(var1_1) && var5_5[var6_6].getParameterTypes().length == var2_2.length) {
                var7_7 = 1;
                var8_8 = 0;
                while (var8_8 < var2_2.length) {
                    if (!AbstractPrologEngine.assignableType(var5_5[var6_6].getParameterTypes()[var8_8], var2_2[var8_8])) {
                        var7_7 = 0;
                        break;
                    }
                    ++var8_8;
                }
                if (var7_7 != 0) {
                    var3_3 = var5_5[var6_6];
                    break;
                }
            }
            ++var6_6;
            continue;
        }
lbl23:
        // 2 sources

        if (var3_3 == null) {
            System.err.println("Could not find " + var1_1 + " in " + var0);
            System.err.println("Argument types:");
            var7_7 = 0;
            while (var7_7 < var2_2.length) {
                System.out.println(String.valueOf(var7_7) + ":" + var2_2[var7_7]);
                ++var7_7;
            }
            throw var4_4;
        }
        return var3_3;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static Constructor findConstructor(Class var0, Class[] var1_1) throws NoSuchMethodException {
        var2_2 /* !! */  = null;
        try {
            var2_2 /* !! */  = var0.getConstructor(var1_1);
            return var2_2 /* !! */ ;
        }
        catch (NoSuchMethodException var3_3) {
            var4_4 = var0.getConstructors();
            var5_5 = 0;
            ** while (var5_5 < var4_4.length)
        }
lbl-1000:
        // 1 sources

        {
            if (var4_4[var5_5].getParameterTypes().length == var1_1.length) {
                var6_6 = true;
                var7_7 = 0;
                while (var7_7 < var1_1.length) {
                    if (!AbstractPrologEngine.assignableType(var4_4[var5_5].getParameterTypes()[var7_7], var1_1[var7_7])) {
                        var6_6 = false;
                        break;
                    }
                    ++var7_7;
                }
                if (var6_6) {
                    var2_2 /* !! */  = var4_4[var5_5];
                    break;
                }
            }
            ++var5_5;
            continue;
        }
lbl23:
        // 2 sources

        if (var2_2 /* !! */  == null) {
            throw var3_3;
        }
        return var2_2 /* !! */ ;
    }

    public static boolean assignableType(Class clazz, Class clazz2) {
        if (clazz2 == null) {
            return true;
        }
        return clazz.isAssignableFrom(clazz2);
    }

    public static String shortClassName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(".");
        int n2 = string.lastIndexOf("$");
        if (n == -1 && n2 == -1) {
            return string;
        }
        return string.substring(Math.max(n, n2) + 1, string.length());
    }

    public int registerJavaObject(Object object) {
        return this.knownObjects.registerJavaObject(object);
    }

    public Object makeInvisible(Object object) {
        return this.knownObjects.makeInvisible(object);
    }

    public Object getRealJavaObject(InvisibleObject invisibleObject) {
        return this.knownObjects.getRealJavaObject(invisibleObject);
    }

    public Object getRealJavaObject(int n) {
        return this.knownObjects.getRealJavaObject(n);
    }

    public Object getRealJavaObject(Object object) {
        return object;
    }

    public boolean unregisterJavaObject(int n) {
        return this.knownObjects.unregisterJavaObject(n);
    }

    public boolean unregisterJavaObject(Object object) {
        return this.knownObjects.unregisterJavaObject(object);
    }

    public boolean unregisterJavaObjects(Class clazz) {
        return this.knownObjects.unregisterJavaObjects(clazz);
    }

    public void setThreadedCallbacks(boolean bl) {
        this.threadedCallbacks = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

