/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.problems.internal;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.gradle.api.Action;
import org.gradle.api.problems.ProblemSpec;
import org.gradle.api.problems.internal.AdditionalDataBuilderFactory;
import org.gradle.api.problems.internal.DefaultProblemBuilder;
import org.gradle.api.problems.internal.ExceptionProblemRegistry;
import org.gradle.api.problems.internal.InternalProblemReporter;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.Problem;
import org.gradle.api.problems.internal.ProblemSummarizer;
import org.gradle.api.problems.internal.ProblemTaskPathTracker;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.problems.buildtree.ProblemStream;

public class DefaultProblemReporter
implements InternalProblemReporter {
    private final ProblemSummarizer problemSummarizer;
    private final ProblemStream problemStream;
    private final CurrentBuildOperationRef currentBuildOperationRef;
    private final ExceptionProblemRegistry exceptionProblemRegistry;
    private final AdditionalDataBuilderFactory additionalDataBuilderFactory;
    private final ExceptionAnalyser exceptionAnalyser;

    public DefaultProblemReporter(ProblemSummarizer problemSummarizer, ProblemStream problemStream, CurrentBuildOperationRef currentBuildOperationRef, AdditionalDataBuilderFactory additionalDataBuilderFactory, ExceptionProblemRegistry exceptionProblemRegistry, ExceptionAnalyser exceptionAnalyser) {
        this.problemSummarizer = problemSummarizer;
        this.problemStream = problemStream;
        this.currentBuildOperationRef = currentBuildOperationRef;
        this.exceptionProblemRegistry = exceptionProblemRegistry;
        this.additionalDataBuilderFactory = additionalDataBuilderFactory;
        this.exceptionAnalyser = exceptionAnalyser;
    }

    @Override
    public void reporting(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        spec.execute((Object)problemBuilder);
        this.report(problemBuilder.build());
    }

    @Nonnull
    private DefaultProblemBuilder createProblemBuilder() {
        return new DefaultProblemBuilder(this.problemStream, this.additionalDataBuilderFactory);
    }

    @Override
    public RuntimeException throwing(Action<ProblemSpec> spec) {
        DefaultProblemBuilder problemBuilder = this.createProblemBuilder();
        spec.execute((Object)problemBuilder);
        Problem problem = problemBuilder.build();
        Throwable exception = problem.getException();
        if (exception == null) {
            throw new IllegalStateException("Exception must be non-null");
        }
        throw this.throwError(exception, problem);
    }

    @Override
    public RuntimeException throwing(Throwable exception, Collection<? extends Problem> problems) {
        for (Problem problem : problems) {
            this.report(problem.toBuilder(this.additionalDataBuilderFactory).withException(this.transform(exception)).build());
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    private RuntimeException throwError(Throwable exception, Problem problem) {
        this.report(problem);
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        throw new RuntimeException(exception);
    }

    @Override
    public Problem create(Action<InternalProblemSpec> action) {
        DefaultProblemBuilder defaultProblemBuilder = this.createProblemBuilder();
        action.execute((Object)defaultProblemBuilder);
        return defaultProblemBuilder.build();
    }

    @Override
    public void report(Problem problem) {
        OperationIdentifier id = this.currentBuildOperationRef.getId();
        if (id != null) {
            this.report(problem, id);
        }
    }

    @Override
    public void report(Collection<? extends Problem> problems) {
        for (Problem problem : problems) {
            this.report(problem);
        }
    }

    @Override
    public void report(Problem problem, OperationIdentifier id) {
        String taskPath = ProblemTaskPathTracker.getTaskIdentityPath();
        problem = taskPath == null ? problem : problem.toBuilder(this.additionalDataBuilderFactory).taskPathLocation(taskPath).build();
        Throwable exception = problem.getException();
        if (exception != null) {
            this.exceptionProblemRegistry.onProblem(this.transform(exception), problem);
        }
        this.problemSummarizer.emit(problem, id);
    }

    private Throwable transform(Throwable failure) {
        if (this.exceptionAnalyser == null) {
            return failure;
        }
        try {
            return this.exceptionAnalyser.transform(failure).getCause();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

