/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.EnergyWeaponHandler;
import megamek.server.Server;

public class VariableSpeedPulseLaserWeaponHandler
extends EnergyWeaponHandler {
    private static final long serialVersionUID = -5701939682138221449L;

    public VariableSpeedPulseLaserWeaponHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    protected int calcDamagePerHit() {
        int n = this.ae.getPosition().distance(this.target.getPosition());
        int[] nArray = this.wtype.getRanges(this.weapon);
        double d = this.wtype.getDamage(n);
        if (this.game.getOptions().booleanOption("tacops_energy_weapons") && this.wtype.hasModes()) {
            d = Compute.dialDownDamage(this.weapon, this.wtype, n);
        }
        if (this.game.getOptions().booleanOption("tacops_altdmg")) {
            if (n <= 1) {
                d += 1.0;
            } else if (n > this.wtype.getMediumRange() && n <= this.wtype.getLongRange()) {
                d -= 1.0;
            }
        }
        if (this.target instanceof Infantry && !(this.target instanceof BattleArmor)) {
            d = Compute.directBlowInfantryDamage(d, this.bDirect ? this.toHit.getMoS() / 3 : 0, 0, ((Infantry)this.target).isMechanized());
            d = n <= nArray[1] ? (d += 3.0) : (n <= nArray[2] ? (d += 2.0) : (d += 1.0));
        } else if (this.bDirect) {
            d = Math.min(d + (double)(this.toHit.getMoS() / 3), d * 2.0);
        }
        if (this.game.getOptions().booleanOption("tacops_range") && n > nArray[3]) {
            d = (int)Math.floor(d / 2.0);
            d -= 1.0;
        }
        if (this.bGlancing) {
            d = (int)Math.floor(d / 2.0);
        }
        return (int)Math.ceil(d);
    }

    protected void addHeat() {
        if (this.toHit.getValue() != Integer.MAX_VALUE) {
            int n = this.wtype.getHeat();
            if (this.game.getOptions().booleanOption("tacops_energy_weapons")) {
                n = Compute.dialDownHeat(this.weapon, this.wtype, this.ae.getPosition().distance(this.target.getPosition()));
            }
            this.ae.heatBuildup += n;
            if (this.weapon.hasChargedCapacitor()) {
                this.ae.heatBuildup += 5;
            }
        }
    }
}

