/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.actions;

import java.util.Enumeration;
import megamek.common.Building;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.Protomech;
import megamek.common.Targetable;
import megamek.common.ToHitData;
import megamek.common.actions.DisplacementAttackAction;

public class ChargeAttackAction
extends DisplacementAttackAction {
    private static final long serialVersionUID = -3549351664290057785L;

    public ChargeAttackAction(Entity entity, Targetable targetable) {
        this(entity.getId(), targetable.getTargetType(), targetable.getTargetId(), targetable.getPosition());
    }

    public ChargeAttackAction(int n, int n2, int n3, Coords coords) {
        super(n, n2, n3, coords);
    }

    public ToHitData toHit(IGame iGame) {
        return this.toHit(iGame, false);
    }

    public ToHitData toHit(IGame iGame, boolean bl) {
        Entity entity = iGame.getEntity(this.getEntityId());
        return this.toHit(iGame, iGame.getTarget(this.getTargetType(), this.getTargetId()), entity.getPosition(), entity.getElevation(), entity.moved, bl, false);
    }

    public ToHitData toHit(IGame iGame, Targetable targetable, Coords coords, int n, int n2, boolean bl, boolean bl2) {
        Entity entity = this.getEntity(iGame);
        if (entity == null) {
            throw new IllegalStateException("Attacker is null");
        }
        if (targetable == null) {
            return new ToHitData(Integer.MAX_VALUE, "Target is null");
        }
        int n3 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n3 = targetable.getTargetId();
        }
        if (!iGame.getOptions().booleanOption("friendly_fire") && !bl && targetable.getTargetType() == 0 && (((Entity)targetable).getOwnerId() == entity.getOwnerId() || ((Entity)targetable).getOwner().getTeam() != 0 && entity.getOwner().getTeam() != 0 && entity.getOwner().getTeam() == ((Entity)targetable).getOwner().getTeam())) {
            return new ToHitData(Integer.MAX_VALUE, "A friendly unit can never be the target of a direct attack.");
        }
        IHex iHex = iGame.getBoard().getHex(coords);
        IHex iHex2 = iGame.getBoard().getHex(targetable.getPosition());
        int n4 = n + iHex.getElevation();
        int n5 = n4 + entity.height();
        int n6 = targetable.getElevation() + iHex2.getElevation();
        int n7 = n6 + targetable.getHeight();
        Building building = iGame.getBoard().getBuildingAt(this.getTargetPos());
        ToHitData toHitData = null;
        boolean bl3 = this.getTargetType() == 15 || this.getTargetType() == 3;
        boolean bl4 = Compute.isInSameBuilding(iGame, entity, entity2);
        if (entity.equals(entity2)) {
            return new ToHitData(Integer.MAX_VALUE, "You can't target yourself");
        }
        if (entity2 != null && -1 != entity2.getTransportId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is a passenger.");
        }
        if (entity2 != null && -1 != entity2.getSwarmTargetId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is swarming a Mek.");
        }
        if (coords.distance(targetable.getPosition()) > 1) {
            return new ToHitData(Integer.MAX_VALUE, "Target not in range");
        }
        if (entity instanceof Mech && !bl) {
            if (entity2 != null && !(entity2 instanceof Mech)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is not a mech");
            }
            if (entity2 != null && entity2.isProne()) {
                return new ToHitData(Integer.MAX_VALUE, "Target is prone");
            }
        } else {
            if (entity2 instanceof Infantry) {
                return new ToHitData(Integer.MAX_VALUE, "Target is infantry");
            }
            if (entity2 instanceof Protomech) {
                return new ToHitData(Integer.MAX_VALUE, "Target is protomech");
            }
        }
        if (n4 > n7 || n5 < n6) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be within 1 elevation level");
        }
        if (entity2 != null && entity2.hasDisplacementAttack()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is already making a charge/DFA attack");
        }
        if (entity2 != null && !entity2.isDone() && !bl) {
            return new ToHitData(Integer.MAX_VALUE, "Target must be done with movement");
        }
        if (entity2 != null && entity2.isTargetOfDisplacementAttack() && entity2.findTargetedDisplacement().getEntityId() != entity.getId()) {
            return new ToHitData(Integer.MAX_VALUE, "Target is the target of another charge/DFA");
        }
        if (null != building && !bl3 && entity2 != null && Compute.isInBuilding(iGame, entity2)) {
            if (!Compute.isInBuilding(iGame, entity)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside building");
            }
            if (!iGame.getBoard().getBuildingAt(entity.getPosition()).equals(building)) {
                return new ToHitData(Integer.MAX_VALUE, "Target is inside differnt building");
            }
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15 || targetable instanceof GunEmplacement) {
            return new ToHitData(Integer.MIN_VALUE, "Targeting adjacent building.");
        }
        if (targetable.getTargetType() == 4 || targetable.getTargetType() == 1 || targetable.getTargetType() == 2) {
            return new ToHitData(Integer.MAX_VALUE, "Invalid attack");
        }
        int n8 = entity.getCrew().getPiloting();
        toHitData = new ToHitData(n8, "base");
        toHitData.append(Compute.getAttackerMovementModifier(iGame, entity.getId(), n2));
        toHitData.append(Compute.getTargetMovementModifier(iGame, n3));
        toHitData.append(Compute.getAttackerTerrainModifier(iGame, entity.getId()));
        toHitData.append(Compute.getTargetTerrainModifier(iGame, entity2, 0, bl4));
        if (entity.isSpotting()) {
            toHitData.addModifier(1, "attacker is spotting");
        }
        if (entity2 != null) {
            if (entity.getCrew().getPiloting() != entity2.getCrew().getPiloting()) {
                toHitData.addModifier(entity.getCrew().getPiloting() - entity2.getCrew().getPiloting(), "piloting skill differential");
            }
            if (entity2.isProne()) {
                toHitData.addModifier(-2, "target prone and adjacent");
            }
            if (entity2.height() > 0 && entity2.getElevation() == -1 && iHex2.terrainLevel(2) == entity2.height()) {
                toHitData.addModifier(1, "target has partial cover");
            }
        }
        if (entity instanceof Mech && ((Mech)entity).getCockpitType() == 1) {
            int n9;
            int n10 = entity.getBadCriticals(0, 1, 0);
            if (n10 + (n9 = entity.getBadCriticals(0, 1, 1)) == 3) {
                return new ToHitData(Integer.MAX_VALUE, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
            }
            if (n10 == 2) {
                toHitData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        toHitData.append(Compute.getImmobileMod(entity2));
        if (bl) {
            toHitData.addModifier(3, "unintentional charge");
        }
        Compute.modifyPhysicalBTHForAdvantages(entity, entity2, toHitData, iGame);
        if (entity2.isEvading()) {
            toHitData.addModifier(entity2.getEvasionBonus(), "target is evading");
        }
        toHitData.setSideTable(entity2.sideTable(coords));
        if (iHex2.terrainLevel(2) == entity2.height() && entity2.getElevation() == -1 && entity2.height() > 0) {
            toHitData.setHitTable(1);
        } else if (entity.getHeight() < targetable.getHeight()) {
            toHitData.setHitTable(2);
        } else {
            toHitData.setHitTable(0);
        }
        if (iGame.getOptions().booleanOption("tacops_attack_physical_psr")) {
            if (entity.getWeightClass() == 0) {
                toHitData.addModifier(-2, "Weight Class Attack Modifier");
            } else if (entity.getWeightClass() == 1) {
                toHitData.addModifier(-1, "Weight Class Attack Modifier");
            }
        }
        if (entity instanceof Mech && ((Mech)entity).hasIndustrialTSM()) {
            toHitData.addModifier(2, "industrial TSM");
        }
        return toHitData;
    }

    public ToHitData toHit(IGame iGame, MovePath movePath) {
        MoveStep moveStep;
        Entity entity = iGame.getEntity(this.getEntityId());
        Targetable targetable = this.getTarget(iGame);
        Coords coords = entity.getPosition();
        int n = entity.getElevation();
        MoveStep moveStep2 = null;
        if (!movePath.contains(8)) {
            return new ToHitData(Integer.MAX_VALUE, "Charge action not found in movment path");
        }
        if (movePath.contains(7)) {
            return new ToHitData(Integer.MAX_VALUE, "No jumping allowed while charging");
        }
        if (movePath.contains(2) || movePath.contains(13) || movePath.contains(14)) {
            return new ToHitData(Integer.MAX_VALUE, "No backwards movement allowed while charging");
        }
        if (movePath.contains(35)) {
            return new ToHitData(Integer.MAX_VALUE, "No evading while charging");
        }
        movePath.compile(iGame, entity);
        Enumeration<MoveStep> enumeration = movePath.getSteps();
        while (enumeration.hasMoreElements() && (moveStep = enumeration.nextElement()).getMovementType() != -1) {
            if (moveStep.getType() == 8) {
                moveStep2 = moveStep;
                continue;
            }
            coords = moveStep.getPosition();
            n = moveStep.getElevation();
        }
        if (moveStep2 == null || !targetable.getPosition().equals(moveStep2.getPosition())) {
            return new ToHitData(Integer.MAX_VALUE, "Could not reach target with movement");
        }
        if (!movePath.getSecondLastStep().isLegalEndPos()) {
            return new ToHitData(Integer.MAX_VALUE, "Violation of stacking limit in second last step");
        }
        return this.toHit(iGame, targetable, coords, n, moveStep2.getMovementType(), false, movePath.contains(5) || movePath.contains(50));
    }

    public static int getDamageFor(Entity entity) {
        return ChargeAttackAction.getDamageFor(entity, entity, false, 0, entity.delta_distance);
    }

    public static int getDamageFor(Entity entity, boolean bl, int n) {
        return ChargeAttackAction.getDamageFor(entity, entity, bl, 0, n);
    }

    public static int getDamageFor(Entity entity, Entity entity2, boolean bl, int n) {
        return ChargeAttackAction.getDamageFor(entity, entity2, bl, n, entity.delta_distance);
    }

    public static int getDamageFor(Entity entity, Entity entity2, boolean bl, int n, int n2) {
        if (!bl) {
            if (n2 == 0) {
                n2 = 1;
            }
            return (int)Math.ceil((double)entity.getWeight() / 10.0 * (double)(n2 - 1) * (entity.getLocationStatus(1) == 2 ? 0.5 : 1.0));
        }
        return (int)Math.floor(entity2.getWeight() * entity.getWeight() * (float)n2 / (entity2.getWeight() + entity.getWeight()) / 10.0f + (float)n);
    }

    public static int getDamageTakenBy(Entity entity, Building building, Coords coords) {
        return (int)Math.ceil((double)building.getPhaseCF(coords) / 10.0);
    }

    public static int getDamageTakenBy(Entity entity, Entity entity2) {
        return ChargeAttackAction.getDamageTakenBy(entity, entity2, false, 0);
    }

    public static int getDamageTakenBy(Entity entity, Entity entity2, boolean bl) {
        return ChargeAttackAction.getDamageTakenBy(entity, entity2, bl, entity.delta_distance);
    }

    public static int getDamageTakenBy(Entity entity, Entity entity2, boolean bl, int n) {
        if (!bl) {
            return (int)Math.ceil((double)entity2.getWeight() / 10.0 * (entity.getLocationStatus(1) == 2 ? 0.5 : 1.0));
        }
        return (int)Math.floor(entity2.getWeight() * entity.getWeight() * (float)n / (entity2.getWeight() + entity.getWeight()) / 10.0f);
    }
}

