/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BattleArmorHandles;
import megamek.common.BipedMech;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentMessages;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.TargetRoll;
import megamek.common.Team;
import megamek.common.TechConstants;
import megamek.common.WeaponType;
import megamek.common.loaders.MtfFile;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.StringUtil;
import megamek.common.weapons.EnergyWeapon;
import megamek.common.weapons.GaussWeapon;
import megamek.common.weapons.ISMekTaser;
import megamek.common.weapons.PPCWeapon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Mech
extends Entity
implements Serializable {
    private static final long serialVersionUID = -1929593228891136561L;
    public static final int NUM_MECH_LOCATIONS = 8;
    public static final int SYSTEM_LIFE_SUPPORT = 0;
    public static final int SYSTEM_SENSORS = 1;
    public static final int SYSTEM_COCKPIT = 2;
    public static final int SYSTEM_ENGINE = 3;
    public static final int SYSTEM_GYRO = 4;
    public static final int ACTUATOR_SHOULDER = 7;
    public static final int ACTUATOR_UPPER_ARM = 8;
    public static final int ACTUATOR_LOWER_ARM = 9;
    public static final int ACTUATOR_HAND = 10;
    public static final int ACTUATOR_HIP = 11;
    public static final int ACTUATOR_UPPER_LEG = 12;
    public static final int ACTUATOR_LOWER_LEG = 13;
    public static final int ACTUATOR_FOOT = 14;
    public static final String[] systemNames = new String[]{"Life Support", "Sensors", "Cockpit", "Engine", "Gyro", null, null, "Shoulder", "Upper Arm", "Lower Arm", "Hand", "Hip", "Upper Leg", "Lower Leg", "Foot"};
    public static final int LOC_HEAD = 0;
    public static final int LOC_CT = 1;
    public static final int LOC_RT = 2;
    public static final int LOC_LT = 3;
    public static final int LOC_RARM = 4;
    public static final int LOC_LARM = 5;
    public static final int LOC_RLEG = 6;
    public static final int LOC_LLEG = 7;
    public static final int COCKPIT_OFF = 0;
    public static final int COCKPIT_ON = 1;
    public static final int COCKPIT_AIMED_SHOT = 2;
    public static final int GYRO_UNKNOWN = -1;
    public static final int GYRO_STANDARD = 0;
    public static final int GYRO_XL = 1;
    public static final int GYRO_COMPACT = 2;
    public static final int GYRO_HEAVY_DUTY = 3;
    public static final String[] GYRO_STRING = new String[]{"Standard Gyro", "XL Gyro", "Compact Gyro", "Heavy Duty Gyro"};
    public static final String[] GYRO_SHORT_STRING = new String[]{"Standard", "XL", "Compact", "Heavy Duty"};
    public static final int COCKPIT_UNKNOWN = -1;
    public static final int COCKPIT_STANDARD = 0;
    public static final int COCKPIT_TORSO_MOUNTED = 1;
    public static final int COCKPIT_SMALL = 2;
    public static final int COCKPIT_COMMAND_CONSOLE = 3;
    public static final int COCKPIT_DUAL = 4;
    public static final int COCKPIT_INDUSTRIAL = 5;
    public static final int COCKPIT_PRIMITIVE = 6;
    public static final int COCKPIT_PRIMITIVE_INDUSTRIAL = 7;
    public static final String[] COCKPIT_STRING = new String[]{"Standard Cockpit", "Torso-Mounted Cockpit", "Small Cockpit", "Command Console", "Dual Cockpit", "Industrial Cockpit", "Primitive Cockpit", "Primitive Industrial Cockpit"};
    public static final String[] COCKPIT_SHORT_STRING = new String[]{"Standard", "Torso Mounted", "Small", "Command Console", "Dual", "Industrial", "Primitive", "Primitive Industrial"};
    public static final int JUMP_UNKNOWN = -1;
    public static final int JUMP_NONE = 0;
    public static final int JUMP_STANDARD = 1;
    public static final int JUMP_IMPROVED = 2;
    public static final int JUMP_BOOSTER = 3;
    public static final int JUMP_DISPOSABLE = 4;
    public static final int HAS_FALSE = -1;
    public static final int HAS_UNKNOWN = 0;
    public static final int HAS_TRUE = 1;
    private int[] rearArmor;
    private int[] orig_rearArmor;
    private static int[] MASC_FAILURE = new int[]{2, 4, 6, 10, 12, 12, 12};
    private int nMASCLevel = 0;
    private boolean bMASCWentUp = false;
    private boolean usedMASC = false;
    private int sinksOn = -1;
    private int sinksOnNextRound = -1;
    private boolean autoEject = true;
    private int cockpitStatus = 1;
    private int cockpitStatusNextRound = 1;
    private int jumpType = -1;
    private int gyroType = 0;
    private int cockpitType = 0;
    private boolean hasCowl = false;
    private int cowlArmor = 0;
    private int hasLaserHeatSinks = 0;
    private int grappled_id = -1;
    private boolean isGrappleAttacker = false;
    private static final NumberFormat commafy = NumberFormat.getInstance();
    private int grappledSide = 0;
    private boolean shouldDieAtEndOfTurnBecauseOfWater = false;
    private boolean justMovedIntoIndustrialKillingWater = false;
    private boolean stalled = false;
    private boolean stalledThisTurn = false;
    private boolean checkForCrit = false;
    private int levelsFallen = 0;

    public Mech() {
        this(0, 0);
    }

    public Mech(int n, int n2) {
        this.gyroType = n;
        this.cockpitType = n2;
        this.rearArmor = new int[this.locations()];
        this.orig_rearArmor = new int[this.locations()];
        for (int i = 0; i < this.locations(); ++i) {
            if (this.hasRearArmor(i)) continue;
            this.initializeRearArmor(-1, i);
        }
        this.setCritical(6, 0, new CriticalSlot(0, 11));
        this.setCritical(6, 1, new CriticalSlot(0, 12));
        this.setCritical(6, 2, new CriticalSlot(0, 13));
        this.setCritical(6, 3, new CriticalSlot(0, 14));
        this.setCritical(7, 0, new CriticalSlot(0, 11));
        this.setCritical(7, 1, new CriticalSlot(0, 12));
        this.setCritical(7, 2, new CriticalSlot(0, 13));
        this.setCritical(7, 3, new CriticalSlot(0, 14));
        this.autoEject = !PreferenceManager.getClientPreferences().defaultAutoejectDisabled();
    }

    public abstract boolean cannotStandUpFromHullDown();

    public void setCowl(int n) {
        this.hasCowl = true;
        this.cowlArmor = n;
    }

    public int getCowlArmor() {
        if (this.hasCowl) {
            return this.cowlArmor;
        }
        return 0;
    }

    public boolean hasCowl() {
        return this.hasCowl;
    }

    public int damageCowl(int n) {
        if (this.hasCowl) {
            if (n < this.cowlArmor) {
                this.cowlArmor -= n;
                return 0;
            }
            this.cowlArmor = 0;
            return n -= this.cowlArmor;
        }
        return n;
    }

    public static int getInnerLocation(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 1;
            }
            case 5: 
            case 7: {
                return 3;
            }
            case 4: 
            case 6: {
                return 2;
            }
        }
        return n;
    }

    public static int mostRestrictiveLoc(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (Mech.restrictScore(n) >= Mech.restrictScore(n2)) {
            return n;
        }
        return n2;
    }

    public static int leastRestrictiveLoc(int n, int n2) {
        if (n == n2) {
            return n2;
        }
        if (Mech.restrictScore(n) >= Mech.restrictScore(n2)) {
            return n2;
        }
        return n;
    }

    public static int restrictScore(int n) {
        switch (n) {
            case 4: 
            case 5: {
                return 0;
            }
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    public int getMASCTurns() {
        return this.nMASCLevel;
    }

    public void setMASCTurns(int n) {
        this.nMASCLevel = n;
    }

    public boolean isMASCUsed() {
        return this.usedMASC;
    }

    public void setMASCUsed(boolean bl) {
        this.usedMASC = bl;
    }

    public int getMASCTarget() {
        return MASC_FAILURE[this.nMASCLevel] + 1;
    }

    public boolean checkForMASCFailure(MovePath movePath, Vector<Report> vector, HashMap<Integer, CriticalSlot> hashMap) {
        if (movePath.hasActiveMASC()) {
            boolean bl = false;
            if (!this.usedMASC) {
                Mounted mounted = this.getMASC();
                Mounted mounted2 = this.getSuperCharger();
                bl = this.doMASCCheckFor(mounted, vector, hashMap);
                boolean bl2 = this.doMASCCheckFor(mounted2, vector, hashMap);
                return bl || bl2;
            }
        }
        return false;
    }

    private boolean doMASCCheckFor(Mounted mounted, Vector<Report> vector, HashMap<Integer, CriticalSlot> hashMap) {
        if (mounted != null) {
            boolean bl = false;
            int n = Compute.d6(2);
            this.usedMASC = true;
            Report report = new Report(2365);
            report.subject = this.getId();
            report.addDesc(this);
            report.add(mounted.getName());
            vector.addElement(report);
            report = new Report(2370);
            report.subject = this.getId();
            report.indent();
            report.add(this.getMASCTarget());
            report.add(n);
            if (n < this.getMASCTarget()) {
                bl = true;
                report.choose(false);
                vector.addElement(report);
                if (((MiscType)mounted.getType()).hasSubType(1L)) {
                    if (mounted.getType().hasFlag(16L)) {
                        mounted.setDestroyed(true);
                        mounted.setMode("Off");
                    }
                    int n2 = 0;
                    int n3 = Compute.d6(2);
                    report = new Report(6310);
                    report.subject = this.getId();
                    report.add(n3);
                    report.newlines = 0;
                    vector.addElement(report);
                    if (n3 <= 7) {
                        report = new Report(6005);
                        report.subject = this.getId();
                        report.newlines = 0;
                        vector.addElement(report);
                    } else if (n3 >= 8 && n3 <= 9) {
                        n2 = 1;
                        report = new Report(6315);
                        report.subject = this.getId();
                        report.newlines = 0;
                        vector.addElement(report);
                    } else if (n3 >= 10 && n3 <= 11) {
                        n2 = 2;
                        report = new Report(6320);
                        report.subject = this.getId();
                        report.newlines = 0;
                        vector.addElement(report);
                    } else if (n3 == 12) {
                        n2 = 3;
                        report = new Report(6325);
                        report.subject = this.getId();
                        report.newlines = 0;
                        vector.addElement(report);
                    }
                    for (int i = 0; i < 12 && n2 > 0; ++i) {
                        CriticalSlot criticalSlot = this.getCritical(1, i);
                        if (criticalSlot.getType() != 0 || criticalSlot.getIndex() != 3) continue;
                        hashMap.put(new Integer(1), criticalSlot);
                        --n2;
                    }
                } else {
                    for (int i = 0; i < this.locations(); ++i) {
                        int n4;
                        if (!this.locationIsLeg(i) || this.getHittableCriticals(i) <= 0) continue;
                        CriticalSlot criticalSlot = null;
                        while ((criticalSlot = this.getCritical(i, n4 = Compute.randomInt(this.getNumberOfCriticals(i)))) == null || !criticalSlot.isHittable()) {
                        }
                        hashMap.put(new Integer(i), criticalSlot);
                    }
                }
                this.doCheckEngineStallRoll(vector);
            } else {
                report.choose(true);
                vector.addElement(report);
            }
            return bl;
        }
        return false;
    }

    @Override
    public void setOmni(boolean bl) {
        super.setOmni(bl);
        if (bl && !this.hasBattleArmorHandles()) {
            this.addTransporter(new BattleArmorHandles());
        }
    }

    @Override
    public int locations() {
        return 8;
    }

    @Override
    public void newRound(int n) {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(65536L) || !mounted.getLinked().isDestroyed() || !mounted.getLinked().isBreached()) continue;
            mounted.setMode("Off");
        }
        super.newRound(n);
        if (this.usedMASC) {
            ++this.nMASCLevel;
            this.bMASCWentUp = true;
        } else {
            this.nMASCLevel = Math.max(0, this.nMASCLevel - 1);
            if (this.bMASCWentUp) {
                this.nMASCLevel = Math.max(0, this.nMASCLevel - 1);
                this.bMASCWentUp = false;
            }
        }
        this.usedMASC = false;
        this.setSecondaryFacing(this.getFacing());
        this.sinksOn = this.sinksOnNextRound;
        this.cockpitStatus = this.cockpitStatusNextRound;
        this.shouldDieAtEndOfTurnBecauseOfWater = this.isJustMovedIntoIndustrialKillingWater();
        if (this.stalledThisTurn) {
            this.stalledThisTurn = false;
        }
        this.levelsFallen = 0;
        this.checkForCrit = false;
    }

    public boolean locationIsTorso(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    @Override
    public boolean locationIsLeg(int n) {
        return n == 7 || n == 6;
    }

    public int countBadLegs() {
        int n = 0;
        for (int i = 0; i < this.locations(); ++i) {
            n += this.locationIsLeg(i) && this.isLocationBad(i) ? 1 : 0;
        }
        return n;
    }

    @Override
    public boolean hasHipCrit() {
        for (int i = 0; i < 8; ++i) {
            if (!this.legHasHipCrit(i)) continue;
            return true;
        }
        return false;
    }

    public boolean legHasHipCrit(int n) {
        if (this.isLocationBad(n)) {
            return false;
        }
        if (this.locationIsLeg(n)) {
            return this.getGoodCriticals(0, 11, n) == 0;
        }
        return false;
    }

    public boolean isSystemIntact(int n) {
        for (int i = 0; i < this.locations(); ++i) {
            int n2 = this.getNumberOfCriticals(i);
            for (int j = 0; j < n2; ++j) {
                CriticalSlot criticalSlot = this.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != n || !criticalSlot.isDamaged() && !criticalSlot.isBreached()) continue;
                return false;
            }
        }
        return true;
    }

    public int countLegActuatorCrits(int n) {
        if (this.isLocationBad(n)) {
            return 0;
        }
        int n2 = 0;
        if (this.locationIsLeg(n)) {
            if (this.getGoodCriticals(0, 12, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 13, n) == 0) {
                ++n2;
            }
            if (this.getGoodCriticals(0, 14, n) == 0) {
                ++n2;
            }
        }
        return n2;
    }

    public boolean hasCompositeStructure() {
        return this.getStructureType() == 4;
    }

    public boolean hasReinforcedStructure() {
        return this.getStructureType() == 3;
    }

    public boolean hasMASC() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(16L) || mounted.isInoperable()) continue;
            return true;
        }
        return false;
    }

    public boolean hasMASCAndSuperCharger() {
        boolean bl = false;
        boolean bl2 = false;
        for (Mounted mounted : this.getEquipment()) {
            if (!mounted.isInoperable() && mounted.getType() instanceof MiscType && mounted.getType().hasFlag(16L) && mounted.getType().hasSubType(1L)) {
                bl2 = true;
            }
            if (mounted.isInoperable() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(16L) || mounted.getType().hasSubType(1L)) continue;
            bl = true;
        }
        return bl && bl2;
    }

    public boolean hasJumpBoosters() {
        boolean bl = false;
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(0x10000000L)) continue;
            if (mounted.isBreached() || mounted.isDestroyed() || mounted.isMissing()) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public Mounted getMASC() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(16L) || !mounted.isReady() || miscType.hasSubType(1L)) continue;
            return mounted;
        }
        return null;
    }

    public Mounted getSuperCharger() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(16L) || !mounted.isReady() || !miscType.hasSubType(1L)) continue;
            return mounted;
        }
        return null;
    }

    public boolean hasArmedMASC() {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(16L) || !mounted.curMode().equals("Armed")) continue;
            return true;
        }
        return false;
    }

    public boolean hasArmedMASCAndSuperCharger() {
        boolean bl = false;
        boolean bl2 = false;
        for (Mounted mounted : this.getEquipment()) {
            if (!mounted.isDestroyed() && !mounted.isBreached() && mounted.getType() instanceof MiscType && mounted.getType().hasFlag(16L) && mounted.curMode().equals("Armed") && mounted.getType().hasSubType(1L)) {
                bl2 = true;
            }
            if (mounted.isDestroyed() || mounted.isBreached() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(16L) || !mounted.curMode().equals("Armed") || mounted.getType().hasSubType(1L)) continue;
            bl = true;
        }
        return bl && bl2;
    }

    public boolean hasExtendedRetractableBlade() {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isInoperable() || !(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x2000000L) || !mounted.getType().hasSubType(0x800000L) || !mounted.curMode().equals("extended")) continue;
            return true;
        }
        return false;
    }

    public boolean hasRetractedBlade(int n) {
        return false;
    }

    public boolean hasTSM() {
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(32L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndustrialTSM() {
        for (Mounted mounted : this.getEquipment()) {
            if (!(mounted.getType() instanceof MiscType) || !mounted.getType().hasFlag(0x2000000000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasStealth() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(65536L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNullSig() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(0x4000000000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasVoidSig() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(0x8000000000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTracks() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(0x200000000000000L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasChameleonShield() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(0x10000000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getStandingHeat() {
        return this.engine.getStandingHeat();
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
        if (engine.engineValid) {
            this.setOriginalWalkMP(this.calculateWalk());
        }
    }

    protected int calculateWalk() {
        if (this.isPrimitive()) {
            double d = this.getEngine().getRating();
            if ((d /= 1.2) % 5.0 != 0.0) {
                return (int)(d - d % 5.0 + 5.0) / (int)this.weight;
            }
            return (int)(d / (double)((int)this.weight));
        }
        return this.getEngine().getRating() / (int)this.weight;
    }

    @Override
    public int getWalkHeat() {
        return this.engine.getWalkHeat();
    }

    @Override
    public int getRunMP(boolean bl, boolean bl2) {
        if (this.hasArmedMASCAndSuperCharger()) {
            return (int)Math.ceil((double)this.getWalkMP(bl, bl2) * 2.5) - (this.getArmorType() == 4 ? 1 : 0);
        }
        if (this.hasArmedMASC()) {
            return this.getWalkMP(bl, bl2) * 2 - (this.getArmorType() == 4 ? 1 : 0);
        }
        return super.getRunMP(bl, bl2) - (this.getArmorType() == 4 ? 1 : 0);
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl, boolean bl2) {
        return super.getRunMP(bl, bl2) - (this.getArmorType() == 4 ? 1 : 0);
    }

    public int getOriginalRunMPwithoutMASC() {
        return super.getRunMP(false, false) - (this.getArmorType() == 4 ? 1 : 0);
    }

    @Override
    public String getRunMPasString() {
        if (this.hasArmedMASC()) {
            return this.getRunMPwithoutMASC() + "(" + this.getRunMP() + ")";
        }
        return Integer.toString(this.getRunMP());
    }

    @Override
    public int getRunHeat() {
        return this.engine.getRunHeat();
    }

    @Override
    public int getJumpMP() {
        return this.getJumpMP(true);
    }

    @Override
    public int getJumpMP(boolean bl) {
        int n = 0;
        if (this.hasShield() && this.getNumberOfShields(4096L) > 0) {
            return 0;
        }
        if (this.hasModularArmor()) {
            --n;
        }
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getType().hasFlag(4L) && !mounted.isDestroyed() && !mounted.isBreached()) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(0x10000000L) || mounted.isDestroyed() || mounted.isBreached()) continue;
            n = this.getOriginalJumpMP();
            break;
        }
        if (bl) {
            return this.applyGravityEffectsOnMP(n);
        }
        return n;
    }

    @Override
    public int getJumpType() {
        if (this.jumpType == -1) {
            this.jumpType = 0;
            for (Mounted mounted : this.miscList) {
                if (mounted.getType().hasFlag(4L)) {
                    if (mounted.getType().hasSubType(2L)) {
                        this.jumpType = 2;
                        break;
                    }
                    this.jumpType = 1;
                    break;
                }
                if (!mounted.getType().hasFlag(0x10000000L)) continue;
                this.jumpType = 3;
                break;
            }
        }
        return this.jumpType;
    }

    @Override
    public int getJumpHeat(int n) {
        switch (this.getJumpType()) {
            case 2: {
                return this.engine.getJumpHeat(n / 2 + n % 2);
            }
            case 0: 
            case 3: 
            case 4: {
                return 0;
            }
        }
        return this.engine.getJumpHeat(n);
    }

    @Override
    public int getJumpMPWithTerrain() {
        if (this.getPosition() == null || this.getJumpType() == 3) {
            return this.getJumpMP();
        }
        int n = 0;
        if (!this.isOffBoard()) {
            n = this.game.getBoard().getHex(this.getPosition()).terrainLevel(2);
        }
        if (n <= 0 || this.getElevation() >= 0) {
            return this.getJumpMP();
        }
        if (n > 1) {
            return 0;
        }
        return this.applyGravityEffectsOnMP(this.torsoJumpJets());
    }

    public int torsoJumpJets() {
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getType().hasFlag(4L) || mounted.isDestroyed() || mounted.isBreached() || !this.locationIsTorso(mounted.getLocation())) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getElevation() {
        int n = super.getElevation();
        if (!this.isMakingDfa()) {
            return n;
        }
        int n2 = this.game.getBoard().getHex(this.displacementAttack.getTargetPos()).floor();
        return Math.max(n, n2) + 1;
    }

    @Override
    public int height() {
        IHex iHex = this.game.getBoard().getHex(this.getPosition());
        return this.isProne() || iHex != null && Compute.isInBuilding(this.game, this) ? 0 : 1;
    }

    public void addEngineSinks(int n, boolean bl) {
        this.addEngineSinks(n, bl, this.isClan());
    }

    public void addEngineSinks(int n, boolean bl, boolean bl2) {
        if (bl) {
            this.addEngineSinks(n, bl2 ? "CLDoubleHeatSink" : "ISDoubleHeatSink");
        } else {
            this.addEngineSinks(n, "Heat Sink");
        }
    }

    public void addEngineSinks(int n, String string) {
        int n2 = Math.min(n, this.getEngine().integralHeatSinkCapacity());
        this.addEngineSinks(string, n2);
    }

    public void addEngineSinks(String string, int n) {
        EquipmentType equipmentType = EquipmentType.get(string);
        if (equipmentType == null) {
            System.out.println("Mech: can't find heat sink to add to engine");
        }
        if (n == 0 && this.getEngine().isFusion()) {
            System.out.println("Mech: not putting any heat sinks in the engine?!?!");
        }
        for (int i = 0; i < n; ++i) {
            try {
                this.addEquipment(new Mounted(this, equipmentType), -1, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getEngineCritHeat() {
        int n = 0;
        if (!this.isShutDown() && this.getEngine().isFusion()) {
            n += 5 * this.getHitCriticals(0, 3, 1);
            n += 5 * this.getHitCriticals(0, 3, 3);
            n += 5 * this.getHitCriticals(0, 3, 2);
        }
        return n;
    }

    public int heatSinks() {
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!equipmentType.hasFlag(1L) && !equipmentType.hasFlag(2L)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public int getHeatCapacity() {
        int n = 0;
        int n2 = this.getActiveSinks();
        for (Mounted mounted : this.getMisc()) {
            if (n2 <= 0) break;
            if (mounted.isDestroyed() || mounted.isBreached()) continue;
            if (mounted.getType().hasFlag(1L)) {
                ++n;
                --n2;
                continue;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            --n2;
            n += 2;
        }
        return n;
    }

    @Override
    public int getHeatCapacityWithWater() {
        if (this.hasLaserHeatSinks()) {
            return this.getHeatCapacity();
        }
        return this.getHeatCapacity() + Math.min(this.sinksUnderwater(), 6);
    }

    private int sinksUnderwater() {
        if (this.getPosition() == null || this.isOffBoard()) {
            return 0;
        }
        IHex iHex = this.game.getBoard().getHex(this.getPosition());
        if (iHex.terrainLevel(2) <= 0 || this.getElevation() >= 0) {
            return 0;
        }
        if (this.isProne() || iHex.terrainLevel(2) >= 2) {
            return this.getHeatCapacity();
        }
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            if (mounted.isDestroyed() || mounted.isBreached() || !this.locationIsLeg(mounted.getLocation())) continue;
            if (mounted.getType().hasFlag(1L)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            n += 2;
        }
        return n;
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case -2: {
                return "Skidded";
            }
            case 0: 
            case 11: {
                return "None";
            }
            case 1: {
                return "Walked";
            }
            case 2: {
                return "Ran";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case -2: {
                return "S";
            }
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return !this.isProne();
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        int n2 = n - this.getFacing();
        if (this.canChangeSecondaryFacing()) {
            return n2 == 0 || n2 == 1 || n2 == -1 || n2 == -5;
        }
        return n2 == 0;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        if (this.isValidSecondaryFacing(n)) {
            return n;
        }
        if (!this.canChangeSecondaryFacing()) {
            return this.getFacing();
        }
        int n2 = (n + (6 - this.getFacing())) % 6;
        return n2 >= 3 ? (this.getFacing() + 5) % 6 : (this.getFacing() + 1) % 6;
    }

    @Override
    public boolean hasRearArmor(int n) {
        return n == 1 || n == 2 || n == 3;
    }

    @Override
    public int getArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.rearArmor[n];
        }
        return super.getArmor(n, bl);
    }

    @Override
    public int getOArmor(int n, boolean bl) {
        if (bl && this.hasRearArmor(n)) {
            return this.orig_rearArmor[n];
        }
        return super.getOArmor(n, bl);
    }

    @Override
    public void setArmor(int n, int n2, boolean bl) {
        if (bl && this.hasRearArmor(n2)) {
            this.rearArmor[n2] = n;
        } else {
            super.setArmor(n, n2, bl);
        }
    }

    public void initializeRearArmor(int n, int n2) {
        this.orig_rearArmor[n2] = n;
        this.setArmor(n, n2, true);
    }

    @Override
    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.getType() instanceof WeaponType && mounted.getType().hasFlag(0x1000000000L)) {
            return 0;
        }
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                return 1;
            }
            case 4: {
                return this.getArmsFlipped() ? 4 : 3;
            }
            case 5: {
                return this.getArmsFlipped() ? 4 : 2;
            }
        }
        return 0;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return this.getEquipment(n).getLocation() != 6 && this.getEquipment(n).getLocation() != 7;
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        Object object;
        int n5 = -1;
        if (n3 != -1 && n4 != 0 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        if (n == 0 || n == 6) {
            n5 = Compute.d6(2);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, false));
                            return object;
                        }
                        return this.tac(n, n2, 1, false);
                    }
                    case 3: 
                    case 4: {
                        return new HitData(4);
                    }
                    case 5: {
                        return new HitData(6);
                    }
                    case 6: {
                        return new HitData(2);
                    }
                    case 7: {
                        return new HitData(1);
                    }
                    case 8: {
                        return new HitData(3);
                    }
                    case 9: {
                        return new HitData(7);
                    }
                    case 10: 
                    case 11: {
                        return new HitData(5);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 2) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 3, false));
                            return object;
                        }
                        return this.tac(n, n2, 3, false);
                    }
                    case 3: {
                        return new HitData(7);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        return new HitData(7);
                    }
                    case 7: {
                        return new HitData(3);
                    }
                    case 8: {
                        if (this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations")) {
                            return new HitData(1, true);
                        }
                        return new HitData(1);
                    }
                    case 9: {
                        if (this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations")) {
                            return new HitData(2, true);
                        }
                        return new HitData(2);
                    }
                    case 10: {
                        return new HitData(4);
                    }
                    case 11: {
                        return new HitData(6);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 3) {
                switch (n5) {
                    case 2: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(this.tac(n, n2, 2, false));
                            return object;
                        }
                        return this.tac(n, n2, 2, false);
                    }
                    case 3: {
                        return new HitData(6);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(6);
                    }
                    case 7: {
                        return new HitData(2);
                    }
                    case 8: {
                        if (this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations")) {
                            return new HitData(1, true);
                        }
                        return new HitData(1);
                    }
                    case 9: {
                        if (this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations")) {
                            return new HitData(3, true);
                        }
                        return new HitData(3);
                    }
                    case 10: {
                        return new HitData(5);
                    }
                    case 11: {
                        return new HitData(7);
                    }
                    case 12: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 1) {
                if (this.game.getOptions().booleanOption("tacops_advanced_mech_hit_locations") && this.isProne()) {
                    switch (n5) {
                        case 2: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, true));
                                return object;
                            }
                            return this.tac(n, n2, 1, true);
                        }
                        case 3: {
                            return new HitData(4, true);
                        }
                        case 4: 
                        case 5: {
                            return new HitData(6, true);
                        }
                        case 6: {
                            return new HitData(2, true);
                        }
                        case 7: {
                            return new HitData(1, true);
                        }
                        case 8: {
                            return new HitData(3, true);
                        }
                        case 9: 
                        case 10: {
                            return new HitData(7, true);
                        }
                        case 11: {
                            return new HitData(5, true);
                        }
                        case 12: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(new HitData(0, true));
                                return object;
                            }
                            return new HitData(0, true);
                        }
                    }
                } else {
                    switch (n5) {
                        case 2: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_tac") && !this.game.getOptions().booleanOption("no_tac")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(this.tac(n, n2, 1, true));
                                return object;
                            }
                            return this.tac(n, n2, 1, true);
                        }
                        case 3: 
                        case 4: {
                            return new HitData(4, true);
                        }
                        case 5: {
                            return new HitData(6, true);
                        }
                        case 6: {
                            return new HitData(2, true);
                        }
                        case 7: {
                            return new HitData(1, true);
                        }
                        case 8: {
                            return new HitData(3, true);
                        }
                        case 9: {
                            return new HitData(7, true);
                        }
                        case 10: 
                        case 11: {
                            return new HitData(5, true);
                        }
                        case 12: {
                            if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                                this.crew.decreaseEdge();
                                object = this.rollHitLocation(n, n2, n3, n4);
                                ((HitData)object).setUndoneLocation(new HitData(0, true));
                                return object;
                            }
                            return new HitData(0, true);
                        }
                    }
                }
            }
        }
        if (n == 1) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 1: {
                        return new HitData(5);
                    }
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(2);
                    }
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 2) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(5);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 3) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(2);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
            if (n2 == 1) {
                switch (n5) {
                    case 1: {
                        return new HitData(5, true);
                    }
                    case 2: {
                        return new HitData(3, true);
                    }
                    case 3: {
                        return new HitData(1, true);
                    }
                    case 4: {
                        return new HitData(2, true);
                    }
                    case 5: {
                        return new HitData(4, true);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0, true);
                    }
                }
            }
        }
        if (n == 2) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0 || n2 == 1) {
                switch (n5) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return new HitData(6, n2 == 1);
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        return new HitData(7, n2 == 1);
                    }
                }
            }
            if (n2 == 2) {
                return new HitData(7);
            }
            if (n2 == 3) {
                return new HitData(6);
            }
        }
        if (n == 3 || n == 7) {
            Object object2;
            n5 = Compute.d6(2);
            int n6 = n == 7 ? 0 : 1;
            try {
                object2 = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object2 != null) {
                    ((PrintWriter)object2).print(n);
                    ((PrintWriter)object2).print("\t");
                    ((PrintWriter)object2).print(n2);
                    ((PrintWriter)object2).print("\t");
                    ((PrintWriter)object2).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 2: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object2 = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object2).setUndoneLocation(new HitData(0, false, n6));
                        return object2;
                    }
                    return new HitData(0, false, n6);
                }
                case 3: {
                    return new HitData(1, true, n6);
                }
                case 4: {
                    return new HitData(2, true, n6);
                }
                case 5: {
                    return new HitData(2, false, n6);
                }
                case 6: {
                    return new HitData(4, false, n6);
                }
                case 7: {
                    return new HitData(1, false, n6);
                }
                case 8: {
                    return new HitData(5, false, n6);
                }
                case 9: {
                    return new HitData(3, false, n6);
                }
                case 10: {
                    return new HitData(3, true, n6);
                }
                case 11: {
                    return new HitData(1, true, n6);
                }
                case 12: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object2 = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object2).setUndoneLocation(new HitData(0, false, n6));
                        return object2;
                    }
                    return new HitData(0, false, n6);
                }
            }
        }
        if (n == 4) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 1: {
                    return new HitData(5, n2 == 1);
                }
                case 2: {
                    return new HitData(3, n2 == 1);
                }
                case 3: {
                    return new HitData(1, n2 == 1);
                }
                case 4: {
                    return new HitData(2, n2 == 1);
                }
                case 5: {
                    return new HitData(4, n2 == 1);
                }
                case 6: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object).setUndoneLocation(new HitData(0, n2 == 1));
                        return object;
                    }
                    return new HitData(0, n2 == 1);
                }
            }
        }
        if (n == 5) {
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 1: {
                    return new HitData(7, n2 == 1);
                }
                case 2: {
                    return new HitData(7, n2 == 1);
                }
                case 3: {
                    return new HitData(3, n2 == 1);
                }
                case 4: {
                    return new HitData(2, n2 == 1);
                }
                case 5: {
                    return new HitData(6, n2 == 1);
                }
                case 6: {
                    return new HitData(6, n2 == 1);
                }
            }
        }
        return null;
    }

    protected HitData tac(int n, int n2, int n3, boolean bl) {
        if (this.game.getOptions().booleanOption("no_tac")) {
            return new HitData(n3, bl);
        }
        if (this.game.getOptions().booleanOption("floating_crits")) {
            HitData hitData = this.rollHitLocation(n, n2);
            return new HitData(hitData.getLocation(), hitData.isRear(), 1);
        }
        return new HitData(n3, bl, 1);
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        switch (hitData.getLocation()) {
            case 2: 
            case 3: {
                return new HitData(1, hitData.isRear(), hitData.getEffect(), hitData.hitAimedLocation(), hitData.getSpecCritMod(), hitData.isFromFront(), hitData.getGeneralDamageType(), hitData.glancingMod());
            }
            case 5: 
            case 7: {
                return new HitData(3, hitData.isRear(), hitData.getEffect(), hitData.hitAimedLocation(), hitData.getSpecCritMod(), hitData.isFromFront(), hitData.getGeneralDamageType(), hitData.glancingMod());
            }
            case 4: 
            case 6: {
                return new HitData(2, hitData.isRear(), hitData.getEffect(), hitData.hitAimedLocation(), hitData.getSpecCritMod(), hitData.isFromFront(), hitData.getGeneralDamageType(), hitData.glancingMod());
            }
            case 0: {
                if (this.getCockpitType() == 1) {
                    return new HitData(-1);
                }
                return new HitData(-2);
            }
        }
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        switch (n) {
            case 2: {
                return 4;
            }
            case 3: {
                return 5;
            }
        }
        return -1;
    }

    public abstract void setInternal(int var1, int var2, int var3, int var4, int var5);

    @Override
    public void autoSetInternal() {
        switch ((int)this.weight) {
            case 10: {
                this.setInternal(3, 4, 3, 1, 2);
                break;
            }
            case 15: {
                this.setInternal(3, 5, 4, 2, 3);
                break;
            }
            case 20: {
                this.setInternal(3, 6, 5, 3, 4);
                break;
            }
            case 25: {
                this.setInternal(3, 8, 6, 4, 6);
                break;
            }
            case 30: {
                this.setInternal(3, 10, 7, 5, 7);
                break;
            }
            case 35: {
                this.setInternal(3, 11, 8, 6, 8);
                break;
            }
            case 40: {
                this.setInternal(3, 12, 10, 6, 10);
                break;
            }
            case 45: {
                this.setInternal(3, 14, 11, 7, 11);
                break;
            }
            case 50: {
                this.setInternal(3, 16, 12, 8, 12);
                break;
            }
            case 55: {
                this.setInternal(3, 18, 13, 9, 13);
                break;
            }
            case 60: {
                this.setInternal(3, 20, 14, 10, 14);
                break;
            }
            case 65: {
                this.setInternal(3, 21, 15, 10, 15);
                break;
            }
            case 70: {
                this.setInternal(3, 22, 15, 11, 15);
                break;
            }
            case 75: {
                this.setInternal(3, 23, 16, 12, 16);
                break;
            }
            case 80: {
                this.setInternal(3, 25, 17, 13, 17);
                break;
            }
            case 85: {
                this.setInternal(3, 27, 18, 14, 18);
                break;
            }
            case 90: {
                this.setInternal(3, 29, 19, 15, 19);
                break;
            }
            case 95: {
                this.setInternal(3, 30, 20, 16, 20);
                break;
            }
            case 100: {
                this.setInternal(3, 31, 21, 17, 21);
                break;
            }
            case 105: {
                this.setInternal(4, 32, 22, 17, 22);
                break;
            }
            case 110: {
                this.setInternal(4, 33, 23, 18, 23);
                break;
            }
            case 115: {
                this.setInternal(4, 35, 24, 19, 24);
                break;
            }
            case 120: {
                this.setInternal(4, 36, 25, 20, 25);
                break;
            }
            case 125: {
                this.setInternal(4, 38, 26, 21, 26);
                break;
            }
            case 130: {
                this.setInternal(4, 39, 27, 21, 27);
                break;
            }
            case 135: {
                this.setInternal(4, 41, 28, 22, 28);
                break;
            }
            case 140: {
                this.setInternal(4, 42, 29, 23, 29);
                break;
            }
            case 145: {
                this.setInternal(4, 44, 31, 24, 31);
                break;
            }
            case 150: {
                this.setInternal(4, 45, 32, 25, 32);
                break;
            }
            case 155: {
                this.setInternal(4, 47, 33, 26, 33);
                break;
            }
            case 160: {
                this.setInternal(4, 48, 34, 26, 34);
                break;
            }
            case 165: {
                this.setInternal(4, 50, 35, 27, 35);
                break;
            }
            case 170: {
                this.setInternal(4, 51, 36, 28, 36);
                break;
            }
            case 175: {
                this.setInternal(4, 53, 37, 29, 37);
                break;
            }
            case 180: {
                this.setInternal(4, 54, 38, 30, 38);
                break;
            }
            case 185: {
                this.setInternal(4, 56, 39, 31, 39);
                break;
            }
            case 190: {
                this.setInternal(4, 57, 40, 31, 40);
                break;
            }
            case 195: {
                this.setInternal(4, 59, 41, 32, 41);
                break;
            }
            case 200: {
                this.setInternal(4, 60, 42, 33, 42);
            }
        }
    }

    public void addClanCase() {
        boolean bl = false;
        EquipmentType equipmentType = EquipmentType.get("CLCASE");
        for (int i = 0; i < this.locations(); ++i) {
            bl = false;
            for (Mounted mounted : this.getEquipment()) {
                if (!mounted.getType().isExplosive() || mounted.getLocation() != i) continue;
                bl = true;
            }
            if (!bl) continue;
            try {
                this.addEquipment(new Mounted(this, equipmentType), i, false);
                continue;
            }
            catch (LocationFullException locationFullException) {
                // empty catch block
            }
        }
    }

    @Override
    public void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        if (n == -1) {
            super.addEquipment(mounted, n, bl);
            return;
        }
        int n2 = mounted.getType().getCriticals(this);
        if (mounted.getType().isSpreadable() || mounted.isSplitable()) {
            n2 = 1;
        }
        if (this.getEmptyCriticals(n) < n2) {
            throw new LocationFullException(mounted.getName() + " does not fit in " + this.getLocationAbbr(n) + " on " + this.getDisplayName() + "\n        free criticals in location: " + this.getEmptyCriticals(n) + ", criticals needed: " + n2);
        }
        if (this.getEquipmentNum(mounted) == -1) {
            super.addEquipment(mounted, n, bl);
        }
        int n3 = this.getEquipmentNum(mounted);
        for (int i = 0; i < n2; ++i) {
            CriticalSlot criticalSlot = new CriticalSlot(1, n3, mounted.getType().isHittable(), mounted.isArmored(), mounted);
            this.addCritical(n, criticalSlot);
        }
    }

    @Override
    public int calculateBattleValue() {
        return this.calculateBattleValue(false, false);
    }

    @Override
    public int calculateBattleValue(boolean bl, boolean bl2) {
        Iterator iterator;
        Object object;
        double d;
        Object object2;
        int n;
        int n2;
        String string = "<TABLE>";
        String string2 = "</TABLE>";
        String string3 = "<TR>";
        String string4 = "</TR>";
        String string5 = "<TD>";
        String string6 = "</TD>";
        String string7 = "<BR>";
        this.bvText = new StringBuffer("<HTML><BODY><CENTER><b>Battle Value Calculations For ");
        this.bvText.append(this.getChassis());
        this.bvText.append(" ");
        this.bvText.append(this.getModel());
        this.bvText.append("</b></CENTER>");
        this.bvText.append(string7);
        this.bvText.append("<b>Defensive Battle Rating Calculation:</b>");
        this.bvText.append(string7);
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 1.0;
        switch (this.getArmorType()) {
            case 10: {
                d4 = 0.5;
                break;
            }
            case 4: {
                d4 = 2.0;
                break;
            }
            case 2: 
            case 3: {
                d4 = 1.5;
                break;
            }
            case 12: {
                d4 = 1.2;
                break;
            }
            default: {
                d4 = 1.0;
            }
        }
        this.bvText.append(string);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Total Armor Factor x ");
        this.bvText.append(d4);
        this.bvText.append(string6);
        this.bvText.append(string5);
        if (this.getCockpitType() == 1) {
            d2 += (double)this.getArmor(1);
            d2 += (double)this.getArmor(1, true);
        }
        int n3 = 0;
        for (Mounted mounted : this.getMisc()) {
            if (!mounted.getType().hasFlag(0x200000000000L)) continue;
            n3 += mounted.getBaseDamageCapacity() - mounted.getDamageTaken();
        }
        this.bvText.append(d2 += (double)(this.getTotalArmor() + n3));
        this.bvText.append(" x 2.5 x ");
        this.bvText.append(d4);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append(d2 *= 2.5 * d4);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d5 = 1.0;
        if (this.getStructureType() == 5) {
            d5 = 0.5;
        }
        d2 += (double)this.getTotalInternal() * d5 * 1.5 * this.getEngine().getBVMultiplier();
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Total I.S. Points x IS Multipler x 1.5 x Engine Multipler");
        this.bvText.append(string6 + string5);
        this.bvText.append(this.getTotalInternal());
        this.bvText.append(" x ");
        this.bvText.append(d5);
        this.bvText.append("1.5 x ");
        this.bvText.append(this.getEngine().getBVMultiplier());
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append((double)this.getTotalInternal() * d5 * 1.5 * this.getEngine().getBVMultiplier());
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d6 = 0.5;
        if (this.getGyroType() == 3) {
            d6 = 1.0;
        }
        d2 += (double)this.getWeight() * d6;
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Weight x Gyro Multipler ");
        this.bvText.append(string6 + string5);
        this.bvText.append(this.getWeight());
        this.bvText.append(" x ");
        this.bvText.append(d6);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append((double)this.getWeight() * d6);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Defensive Equipment:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d7 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            EquipmentType equipmentType = mounted.getType();
            if (mounted.isDestroyed() || (!(equipmentType instanceof WeaponType) || !equipmentType.hasFlag(0x800000L) && !equipmentType.hasFlag(0x1000000000L)) && (!(equipmentType instanceof AmmoType) || ((AmmoType)equipmentType).getAmmoType() != 14) && (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x80000000000L) && !equipmentType.hasFlag(0x800000L) && !equipmentType.hasFlag(0x100000000000L) && !equipmentType.hasFlag(0x100000000L) && (!equipmentType.hasFlag(0x2000000L) || !equipmentType.hasSubType(4096L) && !equipmentType.hasSubType(2048L) && !equipmentType.hasSubType(1024L)))) continue;
            double d8 = equipmentType.getBV(this);
            d7 += d8;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append(equipmentType.getName());
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+");
            this.bvText.append(d8);
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        d2 += d7;
        this.bvText.append(string3);
        this.bvText.append(string5);
        double d9 = this.getArmoredCritBV();
        if (d9 > 0.0) {
            this.bvText.append("Armored Components BV Modification");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+");
            this.bvText.append(d9);
            this.bvText.append(string6);
            this.bvText.append(string4);
            d2 += d9;
        }
        this.bvText.append("Total BV of all Defensive Equipment ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append(d7);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d10 = 0.0;
        for (Mounted mounted : this.getEquipment()) {
            n2 = mounted.getLocation();
            n = 15;
            EquipmentType equipmentType = mounted.getType();
            if (!equipmentType.isExplosive() || n2 == -1 || this.hasCASEII(n2) || (!this.isClan() ? this.getEngine().getSideTorsoCriticalSlots().length <= 2 && ((n2 == 2 || n2 == 3) && this.locationHasCase(n2) || n2 == 5 && (this.locationHasCase(n2) || this.locationHasCase(3)) || n2 == 4 && (this.locationHasCase(n2) || this.locationHasCase(2))) : n2 != 1 && n2 != 6 && n2 != 7 && n2 != 0 && (n2 != 2 && n2 != 3 || this.getEngine().getSideTorsoCriticalSlots().length <= 2))) continue;
            if (equipmentType instanceof GaussWeapon) {
                n = 1;
            }
            if (equipmentType instanceof ISMekTaser) {
                n = 1;
            }
            if (equipmentType instanceof WeaponType && ((WeaponType)equipmentType).getAmmoType() == 23) {
                n = 0;
            }
            if (equipmentType instanceof AmmoType && mounted.getShotsLeft() == 0) continue;
            if (equipmentType instanceof WeaponType && (((WeaponType)equipmentType).getAmmoType() == 1 || ((WeaponType)equipmentType).getAmmoType() == 34)) {
                n = 0;
            }
            if (equipmentType instanceof WeaponType && equipmentType.hasFlag(0x1000000000L)) {
                n = 0;
            }
            if (equipmentType instanceof AmmoType && ((AmmoType)equipmentType).getAmmoType() == 36) {
                n = 1;
            }
            d10 += (double)(n *= equipmentType.getCriticals(this));
        }
        d2 = Math.max(1.0, d2 - d10);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Explosive Weapons/Equipment Penalty ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= -");
        this.bvText.append(d10);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("-------------");
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d2);
        this.bvText.append(string6);
        this.bvText.append(string4);
        int n4 = this.getWalkMP(false, true);
        if (this.hasTSM()) {
            ++n4;
        }
        int n5 = this.hasMASCAndSuperCharger() ? (int)Math.ceil((double)n4 * 2.5) : (this.hasMASC() ? n4 * 2 : (int)Math.ceil((double)n4 * 1.5));
        if (this.getArmorType() == 4) {
            --n5;
        }
        n2 = Compute.getTargetMovementModifier(n5, false, false).getValue();
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Run MP");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(n5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Target Movement Modifer For Run");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(n2);
        this.bvText.append(string6);
        this.bvText.append(string4);
        n = Math.max(this.getActiveUMUCount(), this.getJumpMP(false));
        int n6 = Compute.getTargetMovementModifier(n, true, false).getValue();
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Target Movement Modifer For Jumping");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(n6);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d11 = Math.max(n2, n6);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Target Movement Modifer");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d11);
        this.bvText.append(string6);
        this.bvText.append(string4);
        if (this.hasStealth() || this.hasNullSig()) {
            d11 += 2.0;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Stealth +2");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+2");
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        if (this.hasChameleonShield()) {
            d11 += 2.0;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Chameleon +2");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+2");
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        if (this.hasVoidSig()) {
            d11 += 3.0;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Void Sig +3");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+3");
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        double d12 = 1.0 + d11 / 10.0;
        d2 *= d12;
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Multiply by Defensive Movement Factor of ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d12);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(" x ");
        this.bvText.append(d12);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("-------------");
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Defensive Battle Value");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append(d2);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("<b>Offensive Battle Rating Calculation:</b>");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        int n7 = 6 + this.getHeatCapacity();
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Base Heat Efficiency ");
        double d13 = 0.0;
        for (Mounted mounted : this.getAmmo()) {
            if (((AmmoType)mounted.getType()).getAmmoType() != 36) continue;
            d13 += 1.0;
        }
        if (d13 > 0.0) {
            n7 = (int)((double)n7 + (double)this.getHeatCapacity() * Math.ceil(d13 / 5.0));
            this.bvText.append(" + Coolant Pods ");
        }
        if (this.getJumpMP() > 0) {
            n7 -= this.getJumpHeat(this.getJumpMP());
            this.bvText.append(" - Jump Heat ");
        } else {
            n7 -= this.getRunHeat();
            this.bvText.append(" - Run Heat ");
        }
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(6 + this.getHeatCapacity());
        if (d13 > 0.0) {
            this.bvText.append(" + ");
            this.bvText.append(Math.min((double)(2 * this.getNumberOfSinks()), Math.ceil((double)this.getNumberOfSinks() * d13 / 5.0)));
        }
        this.bvText.append(" - ");
        if (this.getJumpMP() > 0) {
            this.bvText.append(this.getJumpHeat(this.getJumpMP()));
        } else {
            this.bvText.append(this.getRunHeat());
        }
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append(n7);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Unmodified Weapon BV:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d14 = 0.0;
        boolean bl3 = this.hasTargComp();
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        ArrayList<Mounted> arrayList = this.getWeaponList();
        for (Mounted serializable2 : arrayList) {
            object2 = (WeaponType)serializable2.getType();
            if (((EquipmentType)object2).hasFlag(0x1000000000L)) continue;
            double hashMap = ((WeaponType)object2).getBV(this);
            if (serializable2.isDestroyed() || ((EquipmentType)object2).hasFlag(0x800000L)) continue;
            if (((EquipmentType)object2).hasFlag(0x100000000L)) {
                double d8 = 0.0;
                for (Mounted mounted : this.getWeaponList()) {
                    if (!mounted.getType().hasFlag(512L) || mounted.getLocation() != serializable2.getLocation()) continue;
                    d8 += mounted.getType().getBV(this);
                }
                hashMap = d8 * 0.67;
            }
            if (((EquipmentType)object2).hasFlag(8L) && serializable2.getLinkedBy() != null) {
                hashMap += ((MiscType)serializable2.getLinkedBy().getType()).getBV(this, serializable2);
            }
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append(((EquipmentType)object2).getName());
            if (serializable2.isRearMounted()) {
                d16 += hashMap;
                this.bvText.append(" (R)");
            } else {
                d15 += hashMap;
            }
            if (!this.isArm(serializable2.getLocation())) {
                if (serializable2.isRearMounted()) {
                    d18 += hashMap;
                } else {
                    d17 += hashMap;
                }
            }
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(hashMap);
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("-------------");
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Unmodified Front BV:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d15);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Unmodfied Rear BV:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d16);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Total Unmodfied BV:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d16 + d15);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append("Unmodified Front non-arm BV:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d17);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Unmodfied Rear non-arm BV:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d18);
        this.bvText.append(string6);
        this.bvText.append(string4);
        boolean bl4 = true;
        if (d17 <= d18) {
            bl4 = false;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("halving front instead of rear weapon BVs");
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Weapon Heat:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        ArrayList arrayList2 = new ArrayList();
        object2 = new ArrayList();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        double d19 = 0.0;
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType weaponType = (WeaponType)mounted.getType();
            if (weaponType.hasFlag(0x1000000000L)) continue;
            double d20 = weaponType.getHeat();
            if (mounted.isMissing() || mounted.isHit() || mounted.isDestroyed() || mounted.isBreached()) continue;
            if (weaponType.getAmmoType() == 29 || weaponType.hasFlag(16384L)) {
                d20 *= 0.25;
            }
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 33) {
                d20 *= 2.0;
            }
            if (weaponType.getAmmoType() == 23) {
                d20 *= 6.0;
            }
            if (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 42 || weaponType.getAmmoType() == 31) {
                d20 *= 0.5;
            }
            if (weaponType.hasFlag(8L) && mounted.getLinkedBy() != null) {
                d20 += 5.0;
            }
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append(weaponType.getName());
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+ ");
            this.bvText.append(d20);
            this.bvText.append(string6);
            this.bvText.append(string4);
            d = weaponType.getBV(this);
            object = mounted.getName() + (mounted.isRearMounted() ? "(R)" : "");
            if (weaponType.hasFlag(0x800000L)) continue;
            if (weaponType.hasFlag(0x100000000L)) {
                double d21 = 0.0;
                for (Mounted mounted2 : this.getWeaponList()) {
                    if (!mounted2.getType().hasFlag(512L) || mounted2.getLocation() != mounted.getLocation()) continue;
                    d21 += mounted2.getType().getBV(this);
                }
                d = d21 * 0.67;
            }
            if (this.hasFunctionalArmAES(mounted.getLocation())) {
                d *= 1.5;
            }
            if (weaponType.hasFlag(1L) && bl3) {
                d *= 1.25;
            }
            if (mounted.getLinkedBy() != null) {
                Mounted mounted3;
                if (weaponType.hasFlag(8L)) {
                    d += ((MiscType)mounted.getLinkedBy().getType()).getBV(this, mounted);
                }
                if ((mounted3 = mounted.getLinkedBy()).getType() instanceof MiscType && mounted3.getType().hasFlag(512L)) {
                    d *= 1.2;
                    object = ((String)object).concat(" with Artemis");
                }
                if (mounted3.getType() instanceof MiscType && mounted3.getType().hasFlag(0x1000000000000L)) {
                    d *= 1.15;
                    object = ((String)object).concat(" with Apollo");
                }
            }
            if (!this.isArm(mounted.getLocation()) && (mounted.isRearMounted() && bl4 || !mounted.isRearMounted() && !bl4)) {
                d /= 2.0;
            }
            iterator = new ArrayList<Object>();
            if (d20 > 0.0) {
                ((ArrayList)((Object)iterator)).add(d);
                ((ArrayList)((Object)iterator)).add(d20);
                ((ArrayList)((Object)iterator)).add(object);
                arrayList2.add(iterator);
            } else {
                ((ArrayList)((Object)iterator)).add(d);
                ((ArrayList)((Object)iterator)).add(object);
                ((ArrayList)object2).add(iterator);
            }
            d19 += d20;
            if (weaponType.hasFlag(131072L) && weaponType.getAmmoType() != 46 || weaponType.hasFlag(16384L) || weaponType.hasFlag(2048L) || weaponType.getAmmoType() == -1) continue;
            String string8 = weaponType.getAmmoType() + ":" + weaponType.getRackSize();
            if (!hashMap.containsKey(string8)) {
                hashMap.put(string8, weaponType.getBV(this));
                continue;
            }
            hashMap.put(string8, weaponType.getBV(this) + (Double)hashMap.get(string8));
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("-------------");
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Total Heat:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("= ");
        this.bvText.append(d19);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Weapons with no heat at full BV:");
        this.bvText.append(string6);
        this.bvText.append(string4);
        Iterator<Mounted> iterator2 = ((ArrayList)object2).iterator();
        while (iterator2.hasNext()) {
            ArrayList arrayList3 = (ArrayList)((Object)iterator2.next());
            d14 += ((Double)arrayList3.get(0)).doubleValue();
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append(arrayList3.get(1));
            if (arrayList3.get(1).toString().length() < 8) {
                this.bvText.append("\t");
            }
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(arrayList3.get(0));
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Heat Modified Weapons BV: ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        if (d19 > (double)n7) {
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("(Heat Exceeds Mech Heat Efficiency) ");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        if (d19 <= (double)n7) {
            for (ArrayList arrayList4 : arrayList2) {
                this.bvText.append(string3);
                this.bvText.append(string5);
                this.bvText.append(arrayList4.get(2));
                d14 += ((Double)arrayList4.get(0)).doubleValue();
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(arrayList4.get(0));
                this.bvText.append(string6);
                this.bvText.append(string4);
            }
        } else {
            Collections.sort(arrayList2, new Comparator<ArrayList<Object>>(){

                @Override
                public int compare(ArrayList<Object> arrayList, ArrayList<Object> arrayList2) {
                    if (arrayList.get(0).equals(arrayList2.get(0))) {
                        return (int)Math.ceil((Double)arrayList.get(1) - (Double)arrayList2.get(1));
                    }
                    return (int)Math.ceil((Double)arrayList2.get(0) - (Double)arrayList.get(0));
                }
            });
            double d22 = 0.0;
            for (ArrayList arrayList5 : arrayList2) {
                this.bvText.append(string3);
                this.bvText.append(string5);
                this.bvText.append(arrayList5.get(2));
                this.bvText.append(string6);
                this.bvText.append(string5);
                double d23 = (Double)arrayList5.get(0);
                if (d22 >= (double)n7) {
                    d23 /= 2.0;
                }
                if (d22 >= (double)n7) {
                    this.bvText.append("Heat efficiency reached, half BV");
                }
                d22 += ((Double)arrayList5.get(1)).doubleValue();
                d14 += d23;
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(d23);
                this.bvText.append(string6);
                this.bvText.append(string4);
                this.bvText.append(string3);
                this.bvText.append(string5);
                this.bvText.append("Heat count: " + d22);
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(string6);
                this.bvText.append(string4);
            }
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("-------------");
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Total Weapons BV Adjusted For Heat:");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d14);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Misc Offensive Equipment: ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d24 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || miscType.hasFlag(0x80000000000L) || miscType.hasFlag(0x100000000000L) || miscType.hasFlag(0x800000L) || miscType.hasFlag(1024L) || miscType.hasFlag(0x100000000L) || miscType.hasFlag(0x2000000L) && (miscType.hasSubType(4096L) || miscType.hasSubType(2048L) || miscType.hasSubType(1024L))) continue;
            d = miscType.getBV(this);
            if ((miscType.hasFlag(0x2000000L) || miscType.hasFlag(0x4000000L)) && this.hasFunctionalArmAES(mounted.getLocation())) {
                d *= 1.5;
            }
            if (d > 0.0) {
                this.bvText.append(string3);
                this.bvText.append(string5);
                this.bvText.append(miscType.getName());
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(string6);
                this.bvText.append(string5);
                this.bvText.append(d);
                this.bvText.append(string6);
                this.bvText.append(string4);
            }
            d24 += d;
            if (!miscType.hasFlag(0x20000000L) || mounted.getLocation() == -1) continue;
            if (this.getArmor(mounted.getLocation(), false) != -3) {
                d24 += (double)this.getArmor(mounted.getLocation());
            }
            if (!this.hasRearArmor(mounted.getLocation()) || this.getArmor(mounted.getLocation(), true) == -3) continue;
            d24 += (double)this.getArmor(mounted.getLocation(), true);
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Total Misc Offensive Equipment BV: ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d24);
        this.bvText.append(string6);
        this.bvText.append(string4);
        d14 += d24;
        double d25 = 0.0;
        double d26 = 0.0;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        object = new ArrayList();
        for (Mounted mounted : this.getAmmo()) {
            String string9;
            Player player;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            if ((ammoType.getMunitionType() == 524288L || ammoType.getMunitionType() == 0x2000000000L) && (player = this.getOwner()) != null) {
                if (player.hasTAG()) {
                    d26 += ammoType.getBV(this);
                } else if (player.getTeam() != 0 && this.game != null) {
                    Enumeration<Team> enumeration = this.game.getTeams();
                    while (enumeration.hasMoreElements()) {
                        Team team = enumeration.nextElement();
                        if (team.getId() != player.getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d26 += ammoType.getBV(this);
                        break;
                    }
                }
            }
            if (!((ArrayList)object).contains(string9 = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                ((ArrayList)object).add(string9);
            }
            if (!hashMap2.containsKey(string9)) {
                hashMap2.put(string9, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(string9, ammoType.getBV(this) + (Double)hashMap2.get(string9));
        }
        iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            String string10 = (String)iterator.next();
            if (hashMap.get(string10) != null) {
                if ((Double)hashMap2.get(string10) > (Double)hashMap.get(string10)) {
                    d25 += ((Double)hashMap.get(string10)).doubleValue();
                    continue;
                }
                d25 += ((Double)hashMap2.get(string10)).doubleValue();
                continue;
            }
            if (!string10.equals(new Integer(36).toString() + "1")) continue;
            d25 += ((Double)hashMap2.get(string10)).doubleValue();
        }
        d14 += d25;
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Toal Ammo BV: ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d25);
        this.bvText.append(string6);
        this.bvText.append(string4);
        double d27 = this.getWeight();
        double d28 = 1.0;
        if (this.hasFunctionalArmAES(5)) {
            d28 += 0.1;
        }
        if (this.hasFunctionalArmAES(4)) {
            d28 += 0.1;
        }
        if (this.hasFunctionalLegAES()) {
            if (this instanceof BipedMech) {
                d28 += 0.2;
            } else if (this instanceof QuadMech) {
                d28 += 0.4;
            }
        }
        d27 *= d28;
        if (d28 > 1.0) {
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Weight x AES Multiplier ");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(d27);
            this.bvText.append(" x ");
            this.bvText.append(d28);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(" = ");
            this.bvText.append(d27);
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        if (this.hasTSM()) {
            d14 += d27 * 1.5;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Add weight + TSM Modifier");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(d27);
            this.bvText.append(" * 1.5");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(d27 * 1.5);
            this.bvText.append(string6);
            this.bvText.append(string4);
        } else if (this.hasIndustrialTSM()) {
            d14 += d27 * 1.15;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Add weight + Industrial TSM Modifier");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(d27);
            this.bvText.append(" * 1.115");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(d27 * 1.15);
            this.bvText.append(string6);
            this.bvText.append(string4);
        } else {
            d14 += d27;
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Add weight");
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append(string6);
            this.bvText.append(string5);
            this.bvText.append("+");
            this.bvText.append(d27);
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        double d29 = Math.pow(1.0 + ((double)n5 + (double)Math.round((double)n / 2.0) - 5.0) / 10.0, 1.2);
        d29 = (double)Math.round(d29 * 100.0) / 100.0;
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Final Speed Factor: ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d29);
        this.bvText.append(string6);
        this.bvText.append(string4);
        d3 = d14 * d29;
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Weapons BV * Speed Factor ");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d14);
        this.bvText.append(" * ");
        this.bvText.append(d29);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(" = ");
        this.bvText.append(d3);
        this.bvText.append(string6);
        this.bvText.append(string4);
        if (this.getCockpitType() == 5) {
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append("Offensive BV * 0.9 for Industrial 'Mech without advanced targeting system");
            this.bvText.append(string6);
            this.bvText.append(string3);
            this.bvText.append(string5);
            this.bvText.append(d3);
            this.bvText.append(" * 0.9 = ");
            this.bvText.append(d3 *= 0.9);
            this.bvText.append(string6);
            this.bvText.append(string4);
        }
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Offensive BV + Defensive BV");
        this.bvText.append(string6);
        this.bvText.append(string5);
        double d30 = d3 + d2;
        this.bvText.append(d2);
        this.bvText.append(" + ");
        this.bvText.append(d3);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(" = ");
        this.bvText.append(d30);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        double d31 = 1.0;
        if (this.getCockpitType() == 2 || this.getCockpitType() == 1) {
            d31 = 0.95;
            d30 *= d31;
        }
        d30 = Math.round(d30);
        this.bvText.append("Total BV * Cockpit Modifier");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d3 + d2);
        this.bvText.append(" * ");
        this.bvText.append(d31);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(" = ");
        this.bvText.append(d30);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append("-------------");
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string3);
        this.bvText.append(string5);
        this.bvText.append("Final BV");
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(string6);
        this.bvText.append(string5);
        this.bvText.append(d30);
        this.bvText.append(string6);
        this.bvText.append(string4);
        this.bvText.append(string2);
        this.bvText.append("</BODY></HTML>");
        double d32 = 0.0;
        d32 += d26;
        if ((this.hasC3MM() && this.calculateFreeC3MNodes() < 2 || this.hasC3M() && this.calculateFreeC3Nodes() < 3 || this.hasC3S() && this.c3Master > -1 || this.hasC3i() && this.calculateFreeC3Nodes() < 5) && !bl && this.game != null) {
            int n8 = 0;
            n8 += this.calculateBattleValue(true, true);
            for (Entity entity : this.game.getC3NetworkMembers(this)) {
                if (this.equals(entity) || !this.onSameC3NetworkAs(entity)) continue;
                n8 += entity.calculateBattleValue(true, true);
            }
            n8 = (int)((double)n8 * 0.05);
            d32 += (double)n8;
        }
        d30 = (int)Math.round(d30 + d32);
        double d33 = 1.0;
        if (!bl2) {
            d33 = this.crew.getBVSkillMultiplier();
        }
        int n9 = (int)Math.round(d30 * d33);
        if (bl) {
            return (int)d30;
        }
        return n9;
    }

    @Override
    public double getCost() {
        return this.getCost(null);
    }

    public double getCost(StringBuffer stringBuffer) {
        double[] dArray = new double[14];
        int n = 0;
        double d = 0.0;
        d = this.getCockpitType() == 1 ? 750000.0 : (this.getCockpitType() == 4 ? 0.0 : (this.getCockpitType() == 3 ? 700000.0 : (this.getCockpitType() == 2 ? 175000.0 : (this.getCockpitType() == 5 ? 100000.0 : 200000.0))));
        if (this.hasEiCockpit() && this.getCrew().getOptions().booleanOption("ei_implant")) {
            d = 400000.0;
        }
        dArray[n++] = d;
        dArray[n++] = 50000.0;
        dArray[n++] = this.weight * 2000.0f;
        int n2 = this.hasTSM() ? 16000 : 2000;
        dArray[n++] = (float)n2 * this.weight;
        dArray[n++] = EquipmentType.getStructureCost(this.structureType) * (double)this.weight;
        dArray[n++] = this.getActuatorCost();
        Engine engine = this.getEngine();
        dArray[n++] = (double)((float)(engine.getBaseCost() * engine.getRating()) * this.weight) / 75.0;
        dArray[n++] = this.getGyroType() == 1 ? (double)(750000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)) * 0.5 : (this.getGyroType() == 2 ? (double)(400000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f)) * 1.5 : (this.getGyroType() == 3 ? (double)(500000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f) * 2) : (double)(300000 * (int)Math.ceil((float)this.getOriginalWalkMP() * this.weight / 100.0f))));
        double d2 = 200.0;
        if (this.hasUMU()) {
            dArray[n++] = Math.pow(this.getAllUMUCount(), 2.0) * (double)this.weight * d2;
        } else {
            if (this.getJumpType() == 3) {
                d2 = 150.0;
            } else if (this.getJumpType() == 2) {
                d2 = 500.0;
            }
            dArray[n++] = Math.pow(this.getOriginalJumpMP(), 2.0) * (double)this.weight * d2;
        }
        int n3 = this.hasDoubleHeatSinks() ? 0 : 10;
        int n4 = this.hasDoubleHeatSinks() ? 6000 : 2000;
        dArray[n++] = n4 * (this.heatSinks() - n3);
        dArray[n++] = this.getArmorWeight() * EquipmentType.getArmorCost(this.armorType);
        dArray[n++] = this.getWeaponsAndEquipmentCost();
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 += dArray[i];
        }
        double d4 = 0.0;
        if (this.isOmni()) {
            d4 = 1.25;
            d3 *= d4;
        }
        dArray[n++] = -d4;
        double d5 = 1.0f + this.weight / 100.0f;
        dArray[n++] = -d5;
        d3 = Math.round(d3 * d5);
        if (stringBuffer != null) {
            this.addCostDetails(d3, stringBuffer, dArray);
        }
        return d3;
    }

    private void addCostDetails(double d, StringBuffer stringBuffer, double[] dArray) {
        int n;
        String[] stringArray = new String[]{"Cockpit", "Life Support", "Sensors", "Myomer", "Structure", "Actuators", "Engine", "Gyro", "Jump Jets", "Heatsinks", "Armor", "Equipment", "Omni Multiplier", "Weight Multiplier"};
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            n2 = Math.max(n2, stringArray[n].length());
            n3 = Math.max(n3, commafy.format(dArray[n]).length());
        }
        n2 += 5;
        n3 = Math.max(n3, commafy.format(d).length());
        for (n = 0; n < stringArray.length; ++n) {
            String string = dArray[n] < 0.0 ? StringUtil.makeLength(stringArray[n], n2) + StringUtil.makeLength("x" + commafy.format(dArray[n] * -1.0), n3, true) : (dArray[n] == 0.0 ? StringUtil.makeLength(stringArray[n], n2) + StringUtil.makeLength("N/A", n3, true) : StringUtil.makeLength(stringArray[n], n2) + StringUtil.makeLength(commafy.format(dArray[n]), n3, true));
            stringBuffer.append(string + "\n");
            n4 = string.length();
        }
        for (n = 0; n < n4; ++n) {
            stringBuffer.append("-");
        }
        stringBuffer.append("\n" + StringUtil.makeLength("Total Cost:", n2) + StringUtil.makeLength(commafy.format(d), n3, true));
    }

    protected double getActuatorCost() {
        return this.getArmActuatorCost() + this.getLegActuatorCost();
    }

    protected abstract double getArmActuatorCost();

    protected abstract double getLegActuatorCost();

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7030);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(false));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        if (this.getBadCriticals(0, 4, 1) > 0) {
            if (this.getGyroType() == 3) {
                if (this.getBadCriticals(0, 4, 1) == 1) {
                    pilotingRollData.addModifier(1, "HD Gyro damaged once");
                } else {
                    pilotingRollData.addModifier(3, "HD Gyro damaged twice");
                }
            } else {
                pilotingRollData.addModifier(3, "Gyro damaged");
            }
        }
        if (this.hasActiveEiCockpit()) {
            pilotingRollData.addModifier(-1, "Enhanced Imaging");
        }
        if (this.getCrew().getOptions().booleanOption("vdni") && !this.getCrew().getOptions().booleanOption("bvdni")) {
            pilotingRollData.addModifier(-1, "VDNI");
        }
        if (this.getCockpitType() == 2 && !this.getCrew().getOptions().booleanOption("bvdni")) {
            pilotingRollData.addModifier(1, "Small Cockpit");
        } else if (this.getCockpitType() == 1) {
            pilotingRollData.addModifier(1, "Torso-Mounted Cockpit");
            int n = this.getBadCriticals(0, 1, 0);
            int n2 = this.getBadCriticals(0, 1, 1);
            if (n + n2 == 3) {
                pilotingRollData.addModifier(4, "Sensors Completely Destroyed for Torso-Mounted Cockpit");
            } else if (n == 2) {
                pilotingRollData.addModifier(4, "Head Sensors Destroyed for Torso-Mounted Cockpit");
            }
        }
        if (this.getArmorType() == 4) {
            pilotingRollData.addModifier(1, "Hardened Armor");
        }
        if (this.hasModularArmor()) {
            pilotingRollData.addModifier(1, "Modular Armor");
        }
        if (this.hasIndustrialTSM()) {
            pilotingRollData.addModifier(1, "Industrial TSM");
        }
        return pilotingRollData;
    }

    @Override
    public int getMaxElevationChange() {
        return 2;
    }

    @Override
    public boolean isStealthActive() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(65536L) || !mounted.curMode().equals("On") || !this.hasActiveECM() || Compute.isAffectedByECCM(this, this.getPosition(), this.getPosition())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStealthOn() {
        for (Mounted mounted : this.getMisc()) {
            MiscType miscType = (MiscType)mounted.getType();
            if (!miscType.hasFlag(65536L) || !mounted.curMode().equals("On")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNullSigActive() {
        if (!this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!equipmentType.hasFlag(0x4000000000000L) || !mounted.curMode().equals("On") || !mounted.isReady()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isVoidSigActive() {
        if (!this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!equipmentType.hasFlag(0x8000000000000L) || !mounted.curMode().equals("On") || !mounted.isReady()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isChameleonShieldActive() {
        if (!this.isShutDown()) {
            for (Mounted mounted : this.getMisc()) {
                EquipmentType equipmentType = mounted.getType();
                if (!equipmentType.hasFlag(0x10000000000000L) || !mounted.curMode().equals("On") || !mounted.isReady()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public TargetRoll getStealthModifier(int n, Entity entity) {
        boolean bl;
        TargetRoll targetRoll = null;
        if (this.isVoidSigActive()) {
            int n2 = 3;
            if (this.delta_distance > 5) {
                n2 = 0;
            } else if (this.delta_distance > 2) {
                n2 = 1;
            } else if (this.delta_distance > 0) {
                n2 = 2;
            }
            return new TargetRoll(n2, "void signature");
        }
        boolean bl2 = bl = entity instanceof Infantry && !(entity instanceof BattleArmor);
        if (!(this.isStealthActive() || this.isNullSigActive() || this.isChameleonShieldActive())) {
            targetRoll = new TargetRoll(0, "stealth not active");
        } else {
            switch (n) {
                case 0: 
                case 1: {
                    if (this.isStealthActive() && !bl) {
                        targetRoll = new TargetRoll(0, "stealth");
                        break;
                    }
                    if (this.isNullSigActive() && !bl) {
                        targetRoll = new TargetRoll(0, "null-sig");
                        if (!this.isChameleonShieldActive()) break;
                        targetRoll.addModifier(0, "chameleon");
                        break;
                    }
                    if (this.isChameleonShieldActive()) {
                        targetRoll = new TargetRoll(0, "chameleon");
                        break;
                    }
                    targetRoll = new TargetRoll(0, "infantry ignore stealth");
                    break;
                }
                case 2: {
                    if (this.isStealthActive() && !bl) {
                        targetRoll = new TargetRoll(1, "stealth");
                        break;
                    }
                    if (this.isNullSigActive() && !bl) {
                        targetRoll = new TargetRoll(1, "null-sig");
                        if (!this.isChameleonShieldActive()) break;
                        targetRoll.addModifier(1, "chameleon");
                        break;
                    }
                    if (this.isChameleonShieldActive()) {
                        targetRoll = new TargetRoll(1, "chameleon");
                        break;
                    }
                    targetRoll = new TargetRoll(0, "infantry ignore stealth");
                    break;
                }
                case 3: {
                    if (this.isStealthActive() && !bl) {
                        targetRoll = new TargetRoll(2, "stealth");
                        break;
                    }
                    if (this.isNullSigActive() && !bl) {
                        targetRoll = new TargetRoll(2, "null-sig");
                        if (!this.isChameleonShieldActive()) break;
                        targetRoll.addModifier(2, "chameleon");
                        break;
                    }
                    if (this.isChameleonShieldActive()) {
                        targetRoll = new TargetRoll(2, "chameleon");
                        break;
                    }
                    targetRoll = new TargetRoll(0, "infantry ignore stealth");
                    break;
                }
                case 4: {
                    if (this.isStealthActive()) {
                        targetRoll = new TargetRoll(2, "stealth");
                        break;
                    }
                    if (this.isNullSigActive()) {
                        targetRoll = new TargetRoll(2, "null-sig");
                        if (!this.isChameleonShieldActive()) break;
                        targetRoll.addModifier(2, "chameleon");
                        break;
                    }
                    if (this.isChameleonShieldActive()) {
                        targetRoll = new TargetRoll(2, "chameleon");
                        break;
                    }
                    targetRoll = new TargetRoll(0, "infantry ignore stealth");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown range constant: " + n);
                }
            }
        }
        return targetRoll;
    }

    @Override
    public boolean isRepairable() {
        int n = this.getInternal(1);
        return this.isSalvage() && n != -2 && n != -3;
    }

    @Override
    public boolean canCharge() {
        return super.canCharge() && (!this.game.getOptions().booleanOption("no_clan_physical") || !this.isClan());
    }

    @Override
    public boolean canDFA() {
        return super.canDFA() && (!this.game.getOptions().booleanOption("no_clan_physical") || !this.isClan());
    }

    public int getNumberOfSinks() {
        int n = 0;
        for (Mounted mounted : this.getMisc()) {
            if (mounted.isDestroyed() || mounted.isBreached()) continue;
            if (mounted.getType().hasFlag(1L)) {
                ++n;
                continue;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasDoubleHeatSinks() {
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getType().hasFlag(1L)) {
                return false;
            }
            if (!mounted.getType().hasFlag(2L)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLaserHeatSinks() {
        if (this.hasLaserHeatSinks == 0) {
            for (Mounted mounted : this.getMisc()) {
                if (mounted.getType().hasFlag(1L)) {
                    this.hasLaserHeatSinks = -1;
                    break;
                }
                if (!mounted.getType().hasFlag(64L)) continue;
                this.hasLaserHeatSinks = 1;
                break;
            }
            if (this.hasLaserHeatSinks == 0) {
                this.hasLaserHeatSinks = -1;
            }
        }
        return this.hasLaserHeatSinks == 1;
    }

    public void setActiveSinksNextRound(int n) {
        this.sinksOnNextRound = n;
    }

    public int getActiveSinks() {
        if (this.sinksOn < 0) {
            this.sinksOnNextRound = this.sinksOn = this.getNumberOfSinks();
        }
        return this.sinksOn;
    }

    public int getActiveSinksNextRound() {
        if (this.sinksOnNextRound < 0) {
            return this.getActiveSinks();
        }
        return this.sinksOnNextRound;
    }

    public boolean isAutoEject() {
        boolean bl = true;
        if (this.getCockpitType() == 1) {
            bl = false;
        }
        if (this.isIndustrial()) {
            for (Mounted mounted : this.miscList) {
                if (!mounted.getType().hasFlag(0x80000000000000L)) continue;
                bl = true;
            }
        }
        return this.autoEject && bl;
    }

    public void setAutoEject(boolean bl) {
        this.autoEject = bl;
    }

    @Override
    public boolean removePartialCoverHits(int n, int n2, int n3) {
        if ((n2 & 0xC) == 12 && (n == 1 || n == 0)) {
            return true;
        }
        if (n3 == 0) {
            if ((n2 & 2) != 0 && n == 7) {
                return true;
            }
            if ((n2 & 1) != 0 && n == 6) {
                return true;
            }
            if ((n2 & 8) != 0 && (n == 5 || n == 3)) {
                return true;
            }
            if ((n2 & 4) != 0 && (n == 4 || n == 2)) {
                return true;
            }
        } else {
            if ((n2 & 1) != 0 && n == 7) {
                return true;
            }
            if ((n2 & 2) != 0 && n == 6) {
                return true;
            }
            if ((n2 & 4) != 0 && (n == 5 || n == 3)) {
                return true;
            }
            if ((n2 & 8) != 0 && (n == 4 || n == 2)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doomedInVacuum() {
        return false;
    }

    @Override
    public boolean doomedOnGround() {
        return false;
    }

    @Override
    public boolean doomedInAtmosphere() {
        return true;
    }

    @Override
    public boolean doomedInSpace() {
        return true;
    }

    @Override
    public boolean hasEiCockpit() {
        return this.isClan() || super.hasEiCockpit();
    }

    @Override
    public boolean hasActiveEiCockpit() {
        if (this.cockpitStatus == 0) {
            return false;
        }
        if (this.getBadCriticals(0, 1, 0) > 0) {
            return false;
        }
        return super.hasActiveEiCockpit();
    }

    public int getCockpitStatus() {
        return this.cockpitStatus;
    }

    public int getCockpitStatusNextRound() {
        return this.cockpitStatusNextRound;
    }

    public void setCockpitStatus(int n) {
        this.cockpitStatusNextRound = n;
        if (n != 0 && this.cockpitStatus != 0) {
            this.cockpitStatus = n;
        }
    }

    @Override
    public int getGyroType() {
        return this.gyroType;
    }

    public int getCockpitType() {
        return this.cockpitType;
    }

    public void setGyroType(int n) {
        this.gyroType = n;
    }

    public void setCockpitType(int n) {
        this.cockpitType = n;
    }

    public String getGyroTypeString() {
        return Mech.getGyroTypeString(this.getGyroType());
    }

    public String getCockpitTypeString() {
        return Mech.getCockpitTypeString(this.getCockpitType());
    }

    public static String getGyroTypeString(int n) {
        if (n < 0 || n >= GYRO_STRING.length) {
            return "Unknown";
        }
        return GYRO_STRING[n];
    }

    public static String getGyroTypeShortString(int n) {
        if (n < 0 || n >= GYRO_SHORT_STRING.length) {
            return "Unknown";
        }
        return GYRO_SHORT_STRING[n];
    }

    public static String getCockpitTypeString(int n) {
        if (n < 0 || n >= COCKPIT_STRING.length) {
            return "Unknown";
        }
        return COCKPIT_STRING[n];
    }

    public static int getGyroTypeForString(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        for (int i = 0; i < GYRO_STRING.length; ++i) {
            if (!string.equals(GYRO_STRING[i]) && !string.equals(GYRO_SHORT_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public static int getCockpitTypeForString(String string) {
        if (string == null || string.length() < 1) {
            return -1;
        }
        for (int i = 0; i < COCKPIT_STRING.length; ++i) {
            if (!string.equals(COCKPIT_STRING[i]) && !string.equals(COCKPIT_SHORT_STRING[i])) continue;
            return i;
        }
        return -1;
    }

    public String getSystemName(int n) {
        if (n == 4) {
            return Mech.getGyroDisplayString(this.gyroType);
        }
        if (n == 2) {
            return Mech.getCockpitDisplayString(this.cockpitType);
        }
        return systemNames[n];
    }

    public static String getGyroDisplayString(int n) {
        String string = "";
        switch (n) {
            case 1: {
                string = "GYRO_XL";
                break;
            }
            case 2: {
                string = "GYRO_COMPACT";
                break;
            }
            case 3: {
                string = "GYRO_HEAVY_DUTY";
                break;
            }
            case 0: {
                string = "GYRO_STANDARD";
                break;
            }
            default: {
                string = "GYRO_UNKNOWN";
            }
        }
        String string2 = EquipmentMessages.getString("SystemType.Gyro." + string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    public static String getCockpitDisplayString(int n) {
        String string = "";
        switch (n) {
            case 3: {
                string = "COCKPIT_COMMAND_CONSOLE";
                break;
            }
            case 2: {
                string = "COCKPIT_SMALL";
                break;
            }
            case 1: {
                string = "COCKPIT_TORSO_MOUNTED";
                break;
            }
            case 4: {
                string = "COCKPIT_DUAL";
                break;
            }
            case 0: {
                string = "COCKPIT_STANDARD";
                break;
            }
            case 5: {
                string = "COCKPIT_INDUSTRIAL";
                break;
            }
            case 6: {
                string = "COCKPIT_PRIMITIVE";
                break;
            }
            case 7: {
                string = "COCKPIT_PRIMITIVE_INDUSTRIAL";
                break;
            }
            default: {
                string = "COCKPIT_UNKNOWN";
            }
        }
        String string2 = EquipmentMessages.getString("SystemType.Cockpit." + string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    @Override
    public boolean canAssaultDrop() {
        return true;
    }

    @Override
    public boolean isHexProhibited(IHex iHex) {
        if (iHex.containsTerrain(33)) {
            return true;
        }
        if (iHex.containsTerrain(11) && this.doomedInSpace()) {
            return true;
        }
        return iHex.terrainLevel(1) > 2 || iHex.terrainLevel(5) > 2;
    }

    public String getMtf() {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        String string = "\r\n";
        boolean bl2 = bl = this.getCockpitType() == 0 && this.getGyroType() == 0;
        if (bl) {
            stringBuffer.append("Version:1.0").append(string);
        } else {
            stringBuffer.append("Version:1.1").append(string);
        }
        stringBuffer.append(this.chassis).append(string);
        stringBuffer.append(this.model).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Config:");
        if (this instanceof BipedMech) {
            stringBuffer.append("Biped");
        } else if (this instanceof QuadMech) {
            stringBuffer.append("Quad");
        }
        if (this.isOmni()) {
            stringBuffer.append(" Omnimech");
        }
        stringBuffer.append(string);
        stringBuffer.append("TechBase:");
        if (this.isMixedTech()) {
            if (this.isClan()) {
                stringBuffer.append("Mixed (Clan Chassis)");
            } else {
                stringBuffer.append("Mixed (IS Chassis)");
            }
        } else {
            stringBuffer.append(TechConstants.getTechName(this.techLevel));
        }
        stringBuffer.append(string);
        stringBuffer.append("Era:").append(this.year).append(string);
        if (this.source != null && this.source.trim().length() > 0) {
            stringBuffer.append("Source:").append(this.source).append(string);
        }
        stringBuffer.append("Rules Level:").append(TechConstants.T_SIMPLE_LEVEL[this.techLevel]);
        stringBuffer.append(string);
        stringBuffer.append(string);
        Float f = new Float(this.weight);
        stringBuffer.append("Mass:").append(f.intValue()).append(string);
        stringBuffer.append("Engine:").append(this.getEngine().getEngineName()).append(" Engine");
        stringBuffer.append(string);
        stringBuffer.append("Structure:");
        stringBuffer.append(EquipmentType.getStructureTypeName(this.getStructureType()));
        stringBuffer.append(string);
        stringBuffer.append("Myomer:");
        if (this.hasTSM()) {
            stringBuffer.append("Triple-Strength");
        } else if (this.hasIndustrialTSM()) {
            stringBuffer.append("Industrial Triple-Strength");
        } else {
            stringBuffer.append("Standard");
        }
        stringBuffer.append(string);
        if (!bl) {
            stringBuffer.append("Cockpit:");
            stringBuffer.append(this.getCockpitTypeString());
            stringBuffer.append(string);
            stringBuffer.append("Gyro:");
            stringBuffer.append(this.getGyroTypeString());
            stringBuffer.append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Heat Sinks:").append(this.heatSinks()).append(" ");
        if (this.hasLaserHeatSinks()) {
            stringBuffer.append("Laser");
        } else if (this.hasDoubleHeatSinks()) {
            stringBuffer.append("Double");
        } else {
            stringBuffer.append("Single");
        }
        stringBuffer.append(string);
        if (this.isOmni()) {
            stringBuffer.append("Base Chassis Heat Sinks:");
            stringBuffer.append(this.getEngine().getBaseChassisHeatSinks());
            stringBuffer.append(string);
        }
        stringBuffer.append("Walk MP:").append(this.walkMP).append(string);
        stringBuffer.append("Jump MP:").append(this.jumpMP).append(string);
        stringBuffer.append(string);
        stringBuffer.append("Armor:").append(EquipmentType.getArmorTypeName(this.getArmorType()));
        stringBuffer.append("(" + TechConstants.getTechName(this.getArmorTechLevel()) + ")");
        stringBuffer.append(string);
        for (int n : MtfFile.locationOrder) {
            stringBuffer.append(this.getLocationAbbr(n)).append(" Armor:");
            stringBuffer.append(this.getOArmor(n, false)).append(string);
        }
        for (int n : MtfFile.rearLocationOrder) {
            stringBuffer.append("RT").append(this.getLocationAbbr(n).charAt(0)).append(" Armor:");
            stringBuffer.append(this.getOArmor(n, true)).append(string);
        }
        stringBuffer.append(string);
        stringBuffer.append("Weapons:").append(this.weaponList.size()).append(string);
        for (int i = 0; i < this.weaponList.size(); ++i) {
            Mounted mounted = (Mounted)this.weaponList.get(i);
            stringBuffer.append(mounted.getName()).append(", ").append(this.getLocationName(mounted.getLocation())).append(string);
        }
        stringBuffer.append(string);
        for (int n : MtfFile.locationOrder) {
            String string2 = this.getLocationName(n);
            stringBuffer.append(string2 + ":");
            stringBuffer.append(string);
            for (int i = 0; i < 12; ++i) {
                if (i < this.getNumberOfCriticals(n)) {
                    stringBuffer.append(this.decodeCritical(this.getCritical(n, i))).append(string);
                    continue;
                }
                stringBuffer.append("-Empty-").append(string);
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String decodeCritical(CriticalSlot criticalSlot) {
        if (criticalSlot == null) {
            return "-Empty-";
        }
        int n = criticalSlot.getType();
        int n2 = criticalSlot.getIndex();
        String string = "";
        if (criticalSlot.isArmored()) {
            string = " (armored)";
        }
        if (n == 0) {
            if (systemNames[n2].indexOf("Upper") != -1 || systemNames[n2].indexOf("Lower") != -1 || systemNames[n2].indexOf("Hand") != -1 || systemNames[n2].indexOf("Foot") != -1) {
                return systemNames[n2] + " Actuator" + string;
            }
            if (systemNames[n2].indexOf("Engine") != -1) {
                return "Fusion " + systemNames[n2] + string;
            }
            return systemNames[n2] + string;
        }
        if (n == 1) {
            Mounted mounted = this.getEquipment(criticalSlot.getIndex());
            if (mounted.isRearMounted()) {
                return mounted.getType().getInternalName() + " (R)" + string;
            }
            return mounted.getType().getInternalName() + string;
        }
        return "?" + n2;
    }

    public boolean addCockpit() {
        if (this.getEmptyCriticals(0) < 5) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.addCritical(0, 5, new CriticalSlot(0, 0));
        this.setCockpitType(0);
        return true;
    }

    public boolean addIndustrialCockpit() {
        if (this.getEmptyCriticals(0) < 5) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.addCritical(0, 5, new CriticalSlot(0, 0));
        this.setCockpitType(5);
        return true;
    }

    public boolean addPrimitiveCockpit() {
        if (this.getEmptyCriticals(0) < 5) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.addCritical(0, 5, new CriticalSlot(0, 0));
        this.setCockpitType(6);
        return true;
    }

    public boolean addIndustrialPrimitiveCockpit() {
        if (this.getEmptyCriticals(0) < 5) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.addCritical(0, 5, new CriticalSlot(0, 0));
        this.setCockpitType(7);
        return true;
    }

    public boolean addSmallCockpit() {
        if (this.getEmptyCriticals(0) < 4) {
            return false;
        }
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 3, new CriticalSlot(0, 1));
        this.setCockpitType(2);
        return true;
    }

    public boolean addCommandConsole() {
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.setCockpitType(3);
        return true;
    }

    public boolean addDualCockpit() {
        this.addCritical(0, 0, new CriticalSlot(0, 0));
        this.addCritical(0, 1, new CriticalSlot(0, 1));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 2, new CriticalSlot(0, 2));
        this.addCritical(0, 4, new CriticalSlot(0, 1));
        this.setCockpitType(4);
        return true;
    }

    public boolean addTorsoMountedCockpit() {
        boolean bl = true;
        if (this.getEmptyCriticals(0) < 2) {
            bl = false;
        } else {
            this.addCritical(0, 0, new CriticalSlot(0, 1));
            this.addCritical(0, 1, new CriticalSlot(0, 1));
        }
        if (this.getEmptyCriticals(1) < 2 || !bl) {
            bl = false;
        } else {
            this.addCritical(1, this.getFirstEmptyCrit(1), new CriticalSlot(0, 2));
            this.addCritical(1, this.getFirstEmptyCrit(1), new CriticalSlot(0, 1));
        }
        if (this.getEmptyCriticals(3) < 1 || this.getEmptyCriticals(2) < 1 || !bl) {
            bl = false;
        } else {
            this.addCritical(3, 0, new CriticalSlot(0, 0));
            this.addCritical(2, 0, new CriticalSlot(0, 0));
        }
        if (bl) {
            this.setCockpitType(1);
        }
        return bl;
    }

    public boolean addGyro() {
        if (this.getEmptyCriticals(1) < 4) {
            return false;
        }
        this.addCompactGyro();
        this.addCritical(1, 5, new CriticalSlot(0, 4));
        this.addCritical(1, 6, new CriticalSlot(0, 4));
        this.setGyroType(0);
        return true;
    }

    public boolean addCompactGyro() {
        if (this.getEmptyCriticals(1) < 2) {
            return false;
        }
        this.addCritical(1, 3, new CriticalSlot(0, 4));
        this.addCritical(1, 4, new CriticalSlot(0, 4));
        this.setGyroType(2);
        return true;
    }

    public boolean addXLGyro() {
        if (this.getEmptyCriticals(1) < 6) {
            return false;
        }
        this.clearEngineCrits();
        this.addGyro();
        this.addCritical(1, 7, new CriticalSlot(0, 4));
        this.addCritical(1, 8, new CriticalSlot(0, 4));
        this.setGyroType(1);
        this.addEngineCrits();
        return true;
    }

    public boolean addHeavyDutyGyro() {
        if (this.addGyro()) {
            this.setGyroType(3);
            return true;
        }
        return false;
    }

    public boolean addEngineCrits() {
        boolean bl = true;
        int[] nArray = this.getEngine().getCenterTorsoCriticalSlots(this.getGyroType());
        if (this.getEmptyCriticals(1) < nArray.length) {
            bl = false;
        } else {
            for (int n : nArray) {
                this.addCritical(1, n, new CriticalSlot(0, 3));
            }
        }
        int[] nArray2 = this.getEngine().getSideTorsoCriticalSlots();
        if (this.getEmptyCriticals(3) < nArray2.length || this.getEmptyCriticals(2) < nArray2.length || !bl) {
            bl = false;
        } else {
            for (int n : nArray2) {
                this.addCritical(3, n, new CriticalSlot(0, 3));
                this.addCritical(2, n, new CriticalSlot(0, 3));
            }
        }
        return bl;
    }

    public void clearEngineCrits() {
        for (int i = 0; i < this.locations(); ++i) {
            this.removeCriticals(i, new CriticalSlot(0, 3));
        }
    }

    public void clearCockpitCrits() {
        for (int i = 0; i < this.locations(); ++i) {
            this.removeCriticals(i, new CriticalSlot(0, 0));
            this.removeCriticals(i, new CriticalSlot(0, 1));
            this.removeCriticals(i, new CriticalSlot(0, 2));
        }
    }

    public void clearGyroCrits() {
        for (int i = 0; i < this.locations(); ++i) {
            this.removeCriticals(i, new CriticalSlot(0, 4));
        }
    }

    public int shieldAbsorptionDamage(int n, int n2, boolean bl) {
        int n3 = n;
        if (this.hasActiveShield(n2, bl)) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (this.hasActiveShield(4)) {
                        n3 = this.getAbsorptionRate(4, n3);
                    }
                    if (!this.hasActiveShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (!this.hasActiveShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                default: {
                    if (!this.hasActiveShield(4)) break;
                    n3 = this.getAbsorptionRate(4, n3);
                }
            }
        }
        if (this.hasPassiveShield(n2, bl)) {
            switch (n2) {
                case 3: 
                case 5: {
                    if (!this.hasPassiveShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                case 2: 
                case 4: {
                    if (!this.hasPassiveShield(4)) break;
                    n3 = this.getAbsorptionRate(4, n3);
                    break;
                }
            }
        }
        if (this.hasNoDefenseShield(n2)) {
            switch (n2) {
                case 5: {
                    if (!this.hasNoDefenseShield(5)) break;
                    n3 = this.getAbsorptionRate(5, n3);
                    break;
                }
                case 4: {
                    if (!this.hasNoDefenseShield(4)) break;
                    n3 = this.getAbsorptionRate(4, n3);
                    break;
                }
            }
        }
        return Math.max(0, n3);
    }

    private int getAbsorptionRate(int n, int n2) {
        int n3 = n2;
        if (n != 4 && n != 5) {
            return n3;
        }
        if (n2 <= 0) {
            return 0;
        }
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            Mounted mounted;
            EquipmentType equipmentType;
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 1 || criticalSlot.isDamaged() || !((equipmentType = (mounted = this.getEquipment(criticalSlot.getIndex())).getType()) instanceof MiscType) || !((MiscType)equipmentType).isShield()) continue;
            ++mounted.damageTaken;
            return Math.max(0, n3 -= mounted.getDamageAbsorption(this, mounted.getLocation()));
        }
        return n3;
    }

    public boolean hasHarJelIn(int n) {
        if (n == 0) {
            return false;
        }
        for (Mounted mounted : this.getMisc()) {
            if (mounted.getLocation() != n || !mounted.isReady() || !mounted.getType().hasFlag(0x20000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setGrappled(int n, boolean bl) {
        this.grappled_id = n;
        this.isGrappleAttacker = bl;
    }

    @Override
    public boolean isGrappleAttacker() {
        return this.isGrappleAttacker;
    }

    @Override
    public int getGrappled() {
        return this.grappled_id;
    }

    @Override
    public boolean isEligibleForMovement() {
        if (this.grappled_id != -1) {
            return false;
        }
        return super.isEligibleForMovement();
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }

    @Override
    public void destroyLocation(int n) {
        super.destroyLocation(n);
        if (this.locationIsLeg(n)) {
            this.game.addPSR(new PilotingRollData(this.getId(), 0x7FFFFFFE, 5, "leg destroyed"));
        }
    }

    @Override
    public boolean hasCASEII(int n) {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getLocation() != n || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x2000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setGameOptions() {
        super.setGameOptions();
        for (Mounted mounted : this.getWeaponList()) {
            int n;
            if (!(mounted.getType() instanceof EnergyWeapon) || ((WeaponType)mounted.getType()).getAmmoType() != -1 || this.game == null || !this.game.getOptions().booleanOption("tacops_energy_weapons")) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            String[] stringArray = new String[]{};
            if (mounted.getType() instanceof PPCWeapon && ((WeaponType)mounted.getType()).getMinimumRange() > 0 && this.game.getOptions().booleanOption("tacops_ppc_inhibitors")) {
                arrayList.add("Field Inhibitor ON");
                arrayList.add("Field Inhibitor OFF");
            }
            if ((n = ((WeaponType)mounted.getType()).getDamage()) == -3) {
                n = ((WeaponType)mounted.getType()).damageShort;
            }
            while (n >= 0) {
                arrayList.add("Damage " + n);
                --n;
            }
            if (((WeaponType)mounted.getType()).hasFlag(2L)) {
                arrayList.add("Heat");
            }
            ((WeaponType)mounted.getType()).setModes(arrayList.toArray(stringArray));
        }
    }

    @Override
    public void setGrappleSide(int n) {
        this.grappledSide = n;
    }

    @Override
    public int getGrappleSide() {
        return this.grappledSide;
    }

    @Override
    public boolean isCarefulStand() {
        return this.isCarefulStanding;
    }

    @Override
    public boolean hasModularArmor() {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.isDestroyed() || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModularArmor(int n) {
        for (Mounted mounted : this.getEquipment()) {
            if (mounted.getLocation() != n || mounted.isDestroyed() || !(mounted.getType() instanceof MiscType) || !((MiscType)mounted.getType()).hasFlag(0x200000000000L)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getCoolantFailureAmount() {
        return this.heatSinkCoolantFailureFactor;
    }

    @Override
    public void addCoolantFailureAmount(int n) {
        this.heatSinkCoolantFailureFactor += n;
    }

    @Override
    public int getTotalCommGearTons() {
        return 1 + this.getExtraCommGearTons();
    }

    @Override
    public int getHQIniBonus() {
        int n = super.getHQIniBonus();
        if ((this.getBadCriticals(0, 4, 1) > 0 || this.hasHipCrit()) && this.mpUsedLastRound > 0) {
            return 0;
        }
        return n;
    }

    @Override
    public int getBARRating() {
        if (this.armorType == 10) {
            return 5;
        }
        if (this.armorType == 14 || this.armorType == 15) {
            return 10;
        }
        return 10;
    }

    public boolean isIndustrial() {
        return this.getStructureType() == 5;
    }

    public void setJustMovedIntoIndustrialKillingWater(boolean bl) {
        this.justMovedIntoIndustrialKillingWater = bl;
    }

    public boolean isJustMovedIntoIndustrialKillingWater() {
        return this.justMovedIntoIndustrialKillingWater;
    }

    public boolean shouldDieAtEndOfTurnBecauseOfWater() {
        return this.shouldDieAtEndOfTurnBecauseOfWater;
    }

    public void setStalled(boolean bl) {
        this.stalled = bl;
        this.stalledThisTurn = true;
    }

    @Override
    public boolean isStalled() {
        return this.stalled;
    }

    @Override
    public boolean isShutDown() {
        return super.isShutDown() || this.isStalled();
    }

    @Override
    public Vector<Report> doCheckEngineStallRoll(Vector<Report> vector) {
        if (this.isIndustrial() && this.getEngine().getEngineType() == 0) {
            Report report = new Report(2280);
            report.addDesc(this);
            report.subject = this.getId();
            report.add(1);
            report.add("ICE-Engine Industrial Mech failed a PSR");
            vector.add(report);
            report = new Report(2285);
            report.subject = this.getId();
            PilotingRollData pilotingRollData = this.getBasePilotingRoll();
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            vector.add(report);
            report = new Report(2290);
            report.subject = this.getId();
            report.indent();
            report.newlines = 0;
            report.add(1);
            report.add(pilotingRollData.getPlainDesc());
            vector.add(report);
            int n = Compute.d6(2);
            report = new Report(2300);
            report.subject = this.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(n);
            if (n <= pilotingRollData.getValue()) {
                report.choose(false);
                this.setStalled(true);
                report.newlines = 0;
                vector.add(report);
                report = new Report(2303);
                report.subject = this.getId();
                vector.add(report);
            } else {
                report.choose(true);
                vector.add(report);
            }
        }
        return vector;
    }

    @Override
    public void checkUnstall(Vector<Report> vector) {
        if (this.stalled && !this.stalledThisTurn && this.isIndustrial() && this.getEngine().getEngineType() == 0) {
            Report report = new Report(2280);
            report.addDesc(this);
            report.subject = this.getId();
            report.add(1);
            report.add("unstall stalled ICE engine");
            vector.add(report);
            report = new Report(2285);
            report.subject = this.getId();
            PilotingRollData pilotingRollData = new PilotingRollData(this.getId(), this.getCrew().getPiloting(), "Base piloting skill");
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            vector.add(report);
            report = new Report(2290);
            report.subject = this.getId();
            report.indent();
            report.newlines = 0;
            report.add(1);
            report.add(pilotingRollData.getPlainDesc());
            vector.add(report);
            int n = Compute.d6(2);
            report = new Report(2300);
            report.subject = this.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(n);
            if (n <= pilotingRollData.getValue()) {
                report.choose(false);
                vector.add(report);
            } else {
                report.choose(true);
                report.newlines = 0;
                vector.add(report);
                this.setStalled(false);
                report = new Report(2304);
                report.subject = this.getId();
                vector.add(report);
            }
        }
    }

    public boolean isPrimitive() {
        return this.getCockpitType() == 6 || this.getCockpitType() == 7;
    }

    private int getFirstEmptyCrit(int n) {
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            if (this.getCritical(n, i) != null) continue;
            return i;
        }
        return -1;
    }

    public boolean hasArmoredCockpit() {
        int n = this.getCockpitType() == 1 ? 1 : 0;
        for (int i = 0; i < this.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != 2) continue;
            return criticalSlot.isArmored();
        }
        return false;
    }

    public boolean hasArmoredGyro() {
        for (int i = 0; i < this.getNumberOfCriticals(1); ++i) {
            CriticalSlot criticalSlot = this.getCritical(1, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != 4) continue;
            return criticalSlot.isArmored();
        }
        return false;
    }

    @Override
    public boolean hasArmoredEngine() {
        for (int i = 0; i < this.getNumberOfCriticals(1); ++i) {
            CriticalSlot criticalSlot = this.getCritical(1, i);
            if (criticalSlot == null || criticalSlot.getType() != 0 || criticalSlot.getIndex() != 3) continue;
            return criticalSlot.isArmored();
        }
        return false;
    }

    public boolean isCheckForCrit() {
        return this.checkForCrit;
    }

    public int getLevelsFallen() {
        return this.levelsFallen;
    }

    public void setLevelsFallen(int n) {
        this.levelsFallen = n;
    }

    public void setCheckForCrit(boolean bl) {
        this.checkForCrit = bl;
    }

    public boolean isArm(int n) {
        return n == 5 || n == 4;
    }

    public double getArmoredCritBV() {
        double d = 0.0;
        for (int i = 0; i <= 7; ++i) {
            for (int j = 0; j < this.getNumberOfCriticals(i); ++j) {
                CriticalSlot criticalSlot = this.getCritical(i, j);
                if (criticalSlot == null || !criticalSlot.isArmored()) continue;
                d += 5.0;
            }
        }
        return d;
    }
}

