/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Enumeration;
import java.util.Vector;
import megamek.common.MMRandom;
import megamek.common.Roll;

public class MMRoll
extends Roll {
    private int total;
    private boolean hasSecond = false;
    private int second;
    private Vector<Integer> all = null;

    public MMRoll(MMRandom mMRandom) {
        super(6, 1);
        this.total = mMRandom.randomInt(this.faces) + this.min;
    }

    public MMRoll(MMRandom mMRandom, int n) {
        super(n, 0);
        this.total = mMRandom.randomInt(this.faces) + this.min;
    }

    public MMRoll(MMRandom mMRandom, int n, int n2) {
        super(n, n2);
        this.total = mMRandom.randomInt(this.faces) + this.min;
    }

    public void addRoll(MMRandom mMRandom) {
        int n = mMRandom.randomInt(this.faces) + this.min;
        if (!this.hasSecond) {
            this.hasSecond = true;
            this.second = n;
        } else {
            if (null == this.all) {
                this.all = new Vector();
                this.all.addElement(new Integer(this.total - this.second));
                this.all.addElement(new Integer(this.second));
            }
            this.all.addElement(new Integer(n));
        }
        this.total += n;
    }

    public int getIntValue() {
        return this.total;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.total);
        if (null != this.all) {
            Enumeration<Integer> enumeration = this.all.elements();
            stringBuffer.append(" (");
            stringBuffer.append(enumeration.nextElement().toString());
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(",");
                stringBuffer.append(enumeration.nextElement().toString());
            }
            stringBuffer.append(")");
        } else if (this.hasSecond) {
            stringBuffer.append(" (");
            stringBuffer.append(this.total - this.second);
            stringBuffer.append("+");
            stringBuffer.append(this.second);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public String getReport() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Roll #").append(this.id).append(" - range: [").append(this.min).append(",").append(this.faces + this.min - 1).append("], result: ").append(this.total);
        if (null != this.all) {
            Enumeration<Integer> enumeration = this.all.elements();
            stringBuffer.append(", rolls: ");
            stringBuffer.append(enumeration.nextElement().toString());
            while (enumeration.hasMoreElements()) {
                stringBuffer.append(", ");
                stringBuffer.append(enumeration.nextElement().toString());
            }
        } else if (this.hasSecond) {
            stringBuffer.append(", rolls: ");
            stringBuffer.append(this.total - this.second);
            stringBuffer.append(", ");
            stringBuffer.append(this.second);
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        MMRandom mMRandom = null;
        int n = 2;
        int n2 = 6;
        int n3 = 1;
        int n4 = 1;
        try {
            if (null == stringArray || 0 == stringArray.length) {
                n = 2;
            } else if (1 == stringArray.length) {
                n = Integer.parseInt(stringArray[0]);
            } else if (2 == stringArray.length) {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
                n3 = 0;
            } else {
                n = Integer.parseInt(stringArray[0]);
                n2 = Integer.parseInt(stringArray[1]);
                n3 = Integer.parseInt(stringArray[2]);
            }
            if (n < 1) {
                System.err.println("You must specify at least one roll.");
                System.exit(2);
            }
            if (n2 < 2) {
                System.err.println("You must specify at least two faces.");
                System.exit(3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("You must only supply integers.");
            System.err.println(numberFormatException.getMessage());
            System.exit(1);
        }
        mMRandom = MMRandom.generate(n4);
        MMRoll mMRoll = new MMRoll(mMRandom, n2, n3);
        for (int i = 1; i < n; ++i) {
            mMRoll.addRoll(mMRandom);
        }
        Roll.output(mMRoll);
        MMRoll mMRoll2 = new MMRoll(mMRandom, n2, n3);
        for (int i = 1; i < n; ++i) {
            mMRoll2.addRoll(mMRandom);
        }
        Roll.output(mMRoll2);
    }
}

