/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.child;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.specs.Spec;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.FilteringClassLoader;
import org.gradle.internal.classloader.SystemClassLoaderSpec;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.reflect.JavaMethod;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.NoSuchMethodException;
import org.gradle.internal.reflect.NoSuchPropertyException;
import org.gradle.internal.reflect.PropertyAccessor;
import org.gradle.internal.reflect.PropertyMutator;
import org.gradle.process.internal.streams.EncodedStream;
import org.gradle.process.internal.worker.GradleWorkerMain;
import org.gradle.process.internal.worker.child.BootstrapSecurityManager;
import org.gradle.process.internal.worker.child.SystemApplicationClassLoaderWorker;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerProcessClassPathProvider
implements ClassPathProvider,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerProcessClassPathProvider.class);
    private final CacheRepository cacheRepository;
    private final Object lock = new Object();
    private ClassPath workerClassPath;
    private PersistentCache workerClassPathCache;

    public WorkerProcessClassPathProvider(CacheRepository cacheRepository) {
        this.cacheRepository = cacheRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassPath findClassPath(String name) {
        if (name.equals("WORKER_MAIN")) {
            Object object = this.lock;
            synchronized (object) {
                if (this.workerClassPath == null) {
                    this.workerClassPathCache = this.cacheRepository.cache("workerMain").withInitializer((Action)new CacheInitializer()).open();
                    this.workerClassPath = DefaultClassPath.of((File[])new File[]{WorkerProcessClassPathProvider.jarFile(this.workerClassPathCache)});
                }
                LOGGER.debug("Using worker process classpath: {}", (Object)this.workerClassPath);
                return this.workerClassPath;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.workerClassPathCache != null) {
                    this.workerClassPathCache.close();
                }
            }
            finally {
                this.workerClassPathCache = null;
                this.workerClassPath = null;
            }
        }
    }

    private static File jarFile(PersistentCache cache) {
        return new File(cache.getBaseDir(), "gradle-worker.jar");
    }

    private static class CacheInitializer
    implements Action<PersistentCache> {
        private final WorkerClassRemapper remapper = new WorkerClassRemapper();

        private CacheInitializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(PersistentCache cache) {
            try {
                File jarFile = WorkerProcessClassPathProvider.jarFile(cache);
                LOGGER.debug("Generating worker process classes to {}.", (Object)jarFile);
                ZipOutputStream outputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jarFile)));
                try {
                    for (Class<?> classToMap : this.getClassesForWorkerJar()) {
                        this.remapClass(classToMap, outputStream);
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            catch (Exception e) {
                throw new GradleException("Could not generate worker process bootstrap classes.", (Throwable)e);
            }
        }

        private Set<Class<?>> getClassesForWorkerJar() {
            List<Class> classes = Arrays.asList(GradleWorkerMain.class, BootstrapSecurityManager.class, EncodedStream.EncodedInput.class, ClassLoaderUtils.class, FilteringClassLoader.class, ClassLoaderHierarchy.class, ClassLoaderVisitor.class, ClassLoaderSpec.class, SystemClassLoaderSpec.class, JavaReflectionUtil.class, JavaMethod.class, GradleException.class, NoSuchPropertyException.class, NoSuchMethodException.class, UncheckedException.class, PropertyAccessor.class, PropertyMutator.class, Factory.class, Spec.class, JavaVersion.class);
            HashSet result = new HashSet(classes);
            for (Class klass : classes) {
                result.addAll(Arrays.asList(klass.getDeclaredClasses()));
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void remapClass(Class<?> classToMap, ZipOutputStream jar) throws IOException {
            ClassReader classReader;
            String internalName = Type.getInternalName(classToMap);
            String resourceName = internalName.concat(".class");
            URL resource = WorkerProcessClassPathProvider.class.getClassLoader().getResource(resourceName);
            if (resource == null) {
                throw new IllegalStateException("Could not locate classpath resource for class " + classToMap.getName());
            }
            InputStream inputStream = resource.openStream();
            try {
                classReader = new ClassReader(inputStream);
            }
            finally {
                inputStream.close();
            }
            ClassWriter classWriter = new ClassWriter(0);
            RemappingClassAdapter remappingVisitor = new RemappingClassAdapter((ClassVisitor)classWriter, (Remapper)this.remapper);
            classReader.accept((ClassVisitor)remappingVisitor, 8);
            byte[] remappedClass = classWriter.toByteArray();
            String remappedClassName = this.remapper.map(internalName).concat(".class");
            jar.putNextEntry(new ZipEntry(remappedClassName));
            jar.write(remappedClass);
        }

        private static class WorkerClassRemapper
        extends Remapper {
            private static final String SYSTEM_APP_WORKER_INTERNAL_NAME = Type.getInternalName(SystemApplicationClassLoaderWorker.class);

            private WorkerClassRemapper() {
            }

            public String map(String typeName) {
                if (typeName.equals(SYSTEM_APP_WORKER_INTERNAL_NAME)) {
                    return typeName;
                }
                if (typeName.startsWith("org/gradle/")) {
                    return "worker/" + typeName;
                }
                return typeName;
            }
        }
    }
}

