/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalDirectorySnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshotVisitor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.caching.internal.DefaultBuildCacheHasher;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.HistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.DefaultHistoricalFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;

public class DefaultCurrentFileCollectionFingerprint
implements CurrentFileCollectionFingerprint {
    private final Map<String, NormalizedFileSnapshot> snapshots;
    private final FingerprintCompareStrategy compareStrategy;
    private final FingerprintingStrategy.Identifier identifier;
    private final Iterable<FileSystemSnapshot> roots;
    private final ImmutableMultimap<String, HashCode> rootHashes;
    private HashCode hash;

    public static CurrentFileCollectionFingerprint from(Iterable<FileSystemSnapshot> roots, FingerprintingStrategy strategy) {
        if (Iterables.isEmpty(roots)) {
            return strategy.getIdentifier().getEmptyFingerprint();
        }
        Map<String, NormalizedFileSnapshot> snapshots = strategy.collectSnapshots(roots);
        if (snapshots.isEmpty()) {
            return strategy.getIdentifier().getEmptyFingerprint();
        }
        return new DefaultCurrentFileCollectionFingerprint(snapshots, strategy.getCompareStrategy(), strategy.getIdentifier(), roots);
    }

    private DefaultCurrentFileCollectionFingerprint(Map<String, NormalizedFileSnapshot> snapshots, FingerprintCompareStrategy compareStrategy, FingerprintingStrategy.Identifier identifier, Iterable<FileSystemSnapshot> roots) {
        this.snapshots = snapshots;
        this.compareStrategy = compareStrategy;
        this.identifier = identifier;
        this.roots = roots;
        final ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        this.visitRoots(new PhysicalSnapshotVisitor(){

            @Override
            public boolean preVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
                builder.put((Object)directorySnapshot.getAbsolutePath(), (Object)directorySnapshot.getHash());
                return false;
            }

            @Override
            public void visit(PhysicalSnapshot fileSnapshot) {
                builder.put((Object)fileSnapshot.getAbsolutePath(), (Object)fileSnapshot.getHash());
            }

            @Override
            public void postVisitDirectory(PhysicalDirectorySnapshot directorySnapshot) {
            }
        });
        this.rootHashes = builder.build();
    }

    @Override
    public boolean visitChangesSince(FileCollectionFingerprint oldFingerprint, String title, boolean includeAdded, TaskStateChangeVisitor visitor) {
        if (this.hasSameRootHashes(oldFingerprint)) {
            return true;
        }
        return this.compareStrategy.visitChangesSince(visitor, this.getSnapshots(), oldFingerprint.getSnapshots(), title, includeAdded);
    }

    private boolean hasSameRootHashes(FileCollectionFingerprint oldFingerprint) {
        return Iterables.elementsEqual((Iterable)this.rootHashes.entries(), (Iterable)oldFingerprint.getRootHashes().entries());
    }

    @Override
    public HashCode getHash() {
        if (this.hash == null) {
            DefaultBuildCacheHasher hasher = new DefaultBuildCacheHasher();
            this.compareStrategy.appendToHasher((BuildCacheHasher)hasher, this.snapshots);
            this.hash = hasher.hash();
        }
        return this.hash;
    }

    @Override
    public Map<String, NormalizedFileSnapshot> getSnapshots() {
        return this.snapshots;
    }

    @Override
    public Multimap<String, HashCode> getRootHashes() {
        return this.rootHashes;
    }

    @Override
    public FingerprintingStrategy.Identifier getStrategyIdentifier() {
        return this.identifier;
    }

    @Override
    public void visitRoots(PhysicalSnapshotVisitor visitor) {
        if (this.roots == null) {
            throw new UnsupportedOperationException("Roots not available.");
        }
        for (FileSystemSnapshot root : this.roots) {
            root.accept(visitor);
        }
    }

    @Override
    public HistoricalFileCollectionFingerprint archive() {
        return new DefaultHistoricalFileCollectionFingerprint(this.snapshots, this.compareStrategy, this.rootHashes);
    }
}

