/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;

public class AbsolutePathFingerprintCompareStrategy
implements FingerprintCompareStrategy.Impl {
    @Override
    public boolean visitChangesSince(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean includeAdded) {
        LinkedHashSet<String> unaccountedForPreviousSnapshots = new LinkedHashSet<String>(previous.keySet());
        for (Map.Entry<String, NormalizedFileSnapshot> currentEntry : current.entrySet()) {
            NormalizedFileSnapshot previousNormalizedSnapshot;
            HashCode previousContentHash;
            String currentAbsolutePath = currentEntry.getKey();
            NormalizedFileSnapshot currentNormalizedSnapshot = currentEntry.getValue();
            HashCode currentContentHash = currentNormalizedSnapshot.getNormalizedContentHash();
            if (!(unaccountedForPreviousSnapshots.remove(currentAbsolutePath) ? !currentContentHash.equals((Object)(previousContentHash = (previousNormalizedSnapshot = previous.get(currentAbsolutePath)).getNormalizedContentHash())) && !visitor.visitChange(FileChange.modified(currentAbsolutePath, propertyTitle, previousNormalizedSnapshot.getType(), currentNormalizedSnapshot.getType())) : includeAdded && !visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentNormalizedSnapshot.getType())))) continue;
            return false;
        }
        for (String previousAbsolutePath : unaccountedForPreviousSnapshots) {
            if (visitor.visitChange(FileChange.removed(previousAbsolutePath, propertyTitle, previous.get(previousAbsolutePath).getType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, snapshots);
    }
}

