/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.BranchingInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.CallInstruction;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.ControlFlowStack;
import org.jetbrains.kotlin.com.intellij.psi.controlFlow.GoToInstruction;

public class ReturnInstruction
extends GoToInstruction {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.controlFlow.ReturnInstruction");
    private final ControlFlowStack myStack;
    private CallInstruction myCallInstruction;
    private boolean myRethrowFromFinally;

    public ReturnInstruction(int offset2, @NotNull ControlFlowStack stack, CallInstruction callInstruction) {
        if (stack == null) {
            ReturnInstruction.$$$reportNull$$$0(0);
        }
        super(offset2, BranchingInstruction.Role.END, false);
        this.myStack = stack;
        this.myCallInstruction = callInstruction;
    }

    @Override
    public String toString() {
        return "RETURN FROM " + this.getProcBegin() + (this.offset == 0 ? "" : " TO " + this.offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(boolean pushBack) {
        ControlFlowStack controlFlowStack = this.myStack;
        synchronized (controlFlowStack) {
            int jumpTo = -1;
            if (this.myStack.size() != 0) {
                jumpTo = this.myStack.pop(pushBack);
            }
            if (this.offset != 0) {
                jumpTo = this.offset;
            }
            return jumpTo;
        }
    }

    @NotNull
    public int[] getPossibleReturnOffsets() {
        int[] nArray;
        if (this.offset == 0) {
            int[] nArray2 = new int[3];
            nArray2[0] = this.getProcBegin() - 5;
            nArray2[1] = this.getProcBegin() - 3;
            nArray = nArray2;
            nArray2[2] = this.getProcBegin() - 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = this.offset;
        }
        if (nArray == null) {
            ReturnInstruction.$$$reportNull$$$0(1);
        }
        return nArray;
    }

    public int getProcBegin() {
        return this.myCallInstruction.procBegin;
    }

    public int getProcEnd() {
        return this.myCallInstruction.procEnd;
    }

    public void setCallInstruction(CallInstruction callInstruction) {
        this.myCallInstruction = callInstruction;
    }

    @Override
    public int nNext() {
        return this.offset == 0 ? 3 : 1;
    }

    @Override
    public int getNext(int index2, int no) {
        if (this.offset == 0) {
            switch (no) {
                case 0: {
                    return this.getProcBegin() - 5;
                }
                case 1: {
                    return this.getProcBegin() - 3;
                }
                case 2: {
                    return this.getProcBegin() - 1;
                }
            }
            LOG.assertTrue(false);
            return -1;
        }
        switch (no) {
            case 0: {
                return this.offset;
            }
        }
        LOG.assertTrue(false);
        return -1;
    }

    @Override
    public void accept(ControlFlowInstructionVisitor visitor2, int offset2, int nextOffset) {
        visitor2.visitReturnInstruction(this, offset2, nextOffset);
    }

    public ControlFlowStack getStack() {
        return this.myStack;
    }

    public void setRethrowFromFinally() {
        this.myRethrowFromFinally = true;
    }

    public boolean isRethrowFromFinally() {
        return this.myRethrowFromFinally;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ReturnInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/ReturnInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleReturnOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

