/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.result;

import com.google.common.base.Objects;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.result.ComponentSelectionCause;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.internal.Describables;

public class DefaultComponentSelectionDescriptor
implements ComponentSelectionDescriptorInternal {
    private final ComponentSelectionCause cause;
    private final Describable description;
    private final boolean hasCustomDescription;
    private final int hashCode;

    public DefaultComponentSelectionDescriptor(ComponentSelectionCause cause) {
        this.cause = cause;
        this.description = Describables.of((Object)cause.getDefaultReason());
        this.hasCustomDescription = false;
        this.hashCode = cause.hashCode();
    }

    public DefaultComponentSelectionDescriptor(ComponentSelectionCause cause, Describable description) {
        this.cause = cause;
        this.description = description;
        this.hasCustomDescription = true;
        this.hashCode = Objects.hashCode((Object[])new Object[]{cause, description});
    }

    public ComponentSelectionCause getCause() {
        return this.cause;
    }

    public String getDescription() {
        return this.description.getDisplayName();
    }

    @Override
    public boolean hasCustomDescription() {
        return this.hasCustomDescription;
    }

    @Override
    public Describable getDescribable() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultComponentSelectionDescriptor that = (DefaultComponentSelectionDescriptor)o;
        return this.cause == that.cause && Objects.equal((Object)this.description, (Object)that.description);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.description.getDisplayName();
    }

    @Override
    public ComponentSelectionDescriptorInternal withReason(Describable reason) {
        if (this.description.equals(reason)) {
            return this;
        }
        return new DefaultComponentSelectionDescriptor(this.cause, reason);
    }
}

